/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util.hadoop;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.gobblin.configuration.State;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Master;
import org.apache.hadoop.mapreduce.security.TokenCache;
import org.apache.hadoop.mapreduce.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.mapreduce.v2.api.HSClientProtocol;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetDelegationTokenRequest;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.log4j.Logger;
import org.apache.thrift.TException;

public class TokenUtils {
    private static final Logger LOG = Logger.getLogger(TokenUtils.class);
    private static final String USER_TO_PROXY = "tokens.user.to.proxy";
    private static final String KEYTAB_USER = "keytab.user";
    private static final String KEYTAB_LOCATION = "keytab.location";
    private static final String HADOOP_SECURITY_AUTHENTICATION = "hadoop.security.authentication";
    private static final String OTHER_NAMENODES = "other_namenodes";
    private static final String KERBEROS = "kerberos";
    private static final String YARN_RESOURCEMANAGER_PRINCIPAL = "yarn.resourcemanager.principal";
    private static final String YARN_RESOURCEMANAGER_ADDRESS = "yarn.resourcemanager.address";
    private static final String MAPRED_JOB_TRACKER = "mapred.job.tracker";
    private static final String MAPREDUCE_JOBTRACKER_ADDRESS = "mapreduce.jobtracker.address";
    private static final Pattern KEYTAB_USER_PATTERN = Pattern.compile(".*\\/.*@.*");
    private static final String KERBEROS_REALM = "kerberos.realm";
    private static final String HIVE_TOKEN_SIGNATURE_KEY = "hive.metastore.token.signature";
    private static final String USER_DEFINED_HIVE_LOCATIONS = "user.defined.hcatLocation";

    public static UserGroupInformation getHadoopAndHiveTokensForProxyUser(final State state, Optional<File> tokenFile, UserGroupInformation ugi, IMetaStoreClient client, String targetUser) throws IOException, InterruptedException {
        final Credentials cred = new Credentials();
        ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                TokenUtils.getHadoopTokens(state, (Optional<File>)Optional.absent(), cred);
                return null;
            }
        });
        ugi.getCredentials().addAll(cred);
        TokenUtils.getHiveToken(state, client, cred, targetUser, ugi);
        if (tokenFile.isPresent()) {
            TokenUtils.persistTokens(cred, (File)tokenFile.get());
        }
        return ugi;
    }

    public static void getHadoopTokens(State state, Optional<File> tokenFile, Credentials cred) throws IOException, InterruptedException {
        Preconditions.checkArgument((boolean)state.contains(KEYTAB_USER), (Object)"Missing required property keytab.user");
        Preconditions.checkArgument((boolean)state.contains(KEYTAB_LOCATION), (Object)"Missing required property keytab.location");
        Configuration configuration = new Configuration();
        configuration.set(HADOOP_SECURITY_AUTHENTICATION, KERBEROS);
        UserGroupInformation.setConfiguration((Configuration)configuration);
        UserGroupInformation.loginUserFromKeytab((String)TokenUtils.obtainKerberosPrincipal(state), (String)state.getProp(KEYTAB_LOCATION));
        Optional userToProxy = Strings.isNullOrEmpty((String)state.getProp(USER_TO_PROXY)) ? Optional.absent() : Optional.fromNullable((Object)state.getProp(USER_TO_PROXY));
        Configuration conf = new Configuration();
        LOG.info((Object)("Getting tokens for " + userToProxy));
        TokenUtils.getJhToken(conf, cred);
        TokenUtils.getFsAndJtTokens(state, conf, (Optional<String>)userToProxy, cred);
        if (tokenFile.isPresent()) {
            TokenUtils.persistTokens(cred, (File)tokenFile.get());
        }
    }

    public static String obtainKerberosPrincipal(State state) throws UnknownHostException {
        if (!state.getProp(KEYTAB_USER).matches(KEYTAB_USER_PATTERN.pattern())) {
            Preconditions.checkArgument((boolean)state.contains(KERBEROS_REALM));
            return state.getProp(KEYTAB_USER) + "/" + InetAddress.getLocalHost().getCanonicalHostName() + "@" + state.getProp(KERBEROS_REALM);
        }
        return state.getProp(KEYTAB_USER);
    }

    public static void getHiveToken(State state, IMetaStoreClient hiveClient, Credentials cred, String userToProxy, UserGroupInformation ugi) {
        try {
            List extraHcatLocations;
            HiveConf hiveConf = new HiveConf();
            Token<DelegationTokenIdentifier> hcatToken = TokenUtils.fetchHcatToken(userToProxy, hiveConf, hiveConf.get(HiveConf.ConfVars.METASTOREURIS.varname), hiveClient);
            cred.addToken(hcatToken.getService(), hcatToken);
            ugi.addToken(hcatToken);
            List list = extraHcatLocations = state.contains(USER_DEFINED_HIVE_LOCATIONS) ? state.getPropAsList(USER_DEFINED_HIVE_LOCATIONS) : Collections.EMPTY_LIST;
            if (!extraHcatLocations.isEmpty()) {
                LOG.info((Object)"Need to fetch extra metaStore tokens from hive.");
                for (String thriftUrl : extraHcatLocations) {
                    LOG.info((Object)("Fetching metaStore token from : " + thriftUrl));
                    hiveConf = new HiveConf();
                    hiveConf.set(HiveConf.ConfVars.METASTOREURIS.varname, thriftUrl);
                    hcatToken = TokenUtils.fetchHcatToken(userToProxy, hiveConf, thriftUrl, hiveClient);
                    cred.addToken(hcatToken.getService(), hcatToken);
                    ugi.addToken(hcatToken);
                    LOG.info((Object)("Successfully fetched token for:" + thriftUrl));
                }
            }
        }
        catch (Throwable t) {
            String message = "Failed to get hive metastore token." + t.getMessage() + t.getCause();
            LOG.error((Object)message, t);
            throw new RuntimeException(message);
        }
    }

    private static Token<DelegationTokenIdentifier> fetchHcatToken(String userToProxy, HiveConf hiveConf, String tokenSignatureOverwrite, IMetaStoreClient hiveClient) throws IOException, TException, InterruptedException {
        LOG.info((Object)(HiveConf.ConfVars.METASTORE_USE_THRIFT_SASL.varname + ": " + hiveConf.get(HiveConf.ConfVars.METASTORE_USE_THRIFT_SASL.varname)));
        LOG.info((Object)(HiveConf.ConfVars.METASTORE_KERBEROS_PRINCIPAL.varname + ": " + hiveConf.get(HiveConf.ConfVars.METASTORE_KERBEROS_PRINCIPAL.varname)));
        Token hcatToken = new Token();
        hcatToken.decodeFromUrlString(hiveClient.getDelegationToken(userToProxy, UserGroupInformation.getLoginUser().getShortUserName()));
        if (hcatToken.getService().getLength() <= 0 && tokenSignatureOverwrite != null && tokenSignatureOverwrite.trim().length() > 0) {
            hcatToken.setService(new Text(tokenSignatureOverwrite.trim().toLowerCase()));
            LOG.info((Object)("hive.metastore.token.signature:" + tokenSignatureOverwrite));
        }
        LOG.info((Object)("Created hive metastore token for user:" + userToProxy + " with kind[" + hcatToken.getKind() + "] and service[" + hcatToken.getService() + "]"));
        return hcatToken;
    }

    private static void getJhToken(Configuration conf, Credentials cred) throws IOException {
        YarnRPC rpc = YarnRPC.create((Configuration)conf);
        String serviceAddr = conf.get("mapreduce.jobhistory.address");
        LOG.debug((Object)("Connecting to HistoryServer at: " + serviceAddr));
        HSClientProtocol hsProxy = (HSClientProtocol)rpc.getProxy(HSClientProtocol.class, NetUtils.createSocketAddr((String)serviceAddr), conf);
        LOG.info((Object)"Pre-fetching JH token from job history server");
        Token<?> jhToken = null;
        try {
            jhToken = TokenUtils.getDelegationTokenFromHS(hsProxy, conf);
        }
        catch (Exception exc) {
            throw new IOException("Failed to fetch JH token.", exc);
        }
        if (jhToken == null) {
            LOG.error((Object)"getDelegationTokenFromHS() returned null");
            throw new IOException("Unable to fetch JH token.");
        }
        LOG.info((Object)("Created JH token: " + jhToken.toString()));
        LOG.info((Object)("Token kind: " + jhToken.getKind()));
        LOG.info((Object)("Token id: " + Arrays.toString(jhToken.getIdentifier())));
        LOG.info((Object)("Token service: " + jhToken.getService()));
        cred.addToken(jhToken.getService(), jhToken);
    }

    private static void getFsAndJtTokens(final State state, final Configuration conf, Optional<String> userToProxy, final Credentials cred) throws IOException, InterruptedException {
        if (userToProxy.isPresent()) {
            UserGroupInformation.createProxyUser((String)((String)userToProxy.get()), (UserGroupInformation)UserGroupInformation.getLoginUser()).doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    TokenUtils.getFsAndJtTokensImpl(state, conf, cred);
                    return null;
                }
            });
        } else {
            TokenUtils.getFsAndJtTokensImpl(state, conf, cred);
        }
    }

    private static void getFsAndJtTokensImpl(State state, Configuration conf, Credentials cred) throws IOException {
        TokenUtils.getHdfsToken(conf, cred);
        if (state.contains(OTHER_NAMENODES)) {
            TokenUtils.getOtherNamenodesToken(state.getPropAsList(OTHER_NAMENODES), conf, cred);
        }
        TokenUtils.getJtToken(cred);
    }

    private static void getHdfsToken(Configuration conf, Credentials cred) throws IOException {
        FileSystem fs = FileSystem.get((Configuration)conf);
        LOG.info((Object)("Getting DFS token from " + fs.getUri()));
        Token fsToken = fs.getDelegationToken(TokenUtils.getMRTokenRenewerInternal(new JobConf()).toString());
        if (fsToken == null) {
            LOG.error((Object)"Failed to fetch DFS token for ");
            throw new IOException("Failed to fetch DFS token.");
        }
        LOG.info((Object)("Created DFS token: " + fsToken.toString()));
        LOG.info((Object)("Token kind: " + fsToken.getKind()));
        LOG.info((Object)("Token id: " + Arrays.toString(fsToken.getIdentifier())));
        LOG.info((Object)("Token service: " + fsToken.getService()));
        cred.addToken(fsToken.getService(), fsToken);
    }

    private static void getOtherNamenodesToken(List<String> otherNamenodes, Configuration conf, Credentials cred) throws IOException {
        LOG.info((Object)("other_namenodes: " + otherNamenodes));
        Path[] ps = new Path[otherNamenodes.size()];
        for (int i = 0; i < ps.length; ++i) {
            ps[i] = new Path(otherNamenodes.get(i).trim());
        }
        TokenCache.obtainTokensForNamenodes((Credentials)cred, (Path[])ps, (Configuration)conf);
        LOG.info((Object)("Successfully fetched tokens for: " + otherNamenodes));
    }

    private static void getJtToken(Credentials cred) throws IOException {
        try {
            JobConf jobConf = new JobConf();
            JobClient jobClient = new JobClient(jobConf);
            LOG.info((Object)"Pre-fetching JT token from JobTracker");
            Token mrdt = jobClient.getDelegationToken(TokenUtils.getMRTokenRenewerInternal(jobConf));
            if (mrdt == null) {
                LOG.error((Object)"Failed to fetch JT token");
                throw new IOException("Failed to fetch JT token.");
            }
            LOG.info((Object)("Created JT token: " + mrdt.toString()));
            LOG.info((Object)("Token kind: " + mrdt.getKind()));
            LOG.info((Object)("Token id: " + Arrays.toString(mrdt.getIdentifier())));
            LOG.info((Object)("Token service: " + mrdt.getService()));
            cred.addToken(mrdt.getService(), mrdt);
        }
        catch (InterruptedException ie) {
            throw new IOException(ie);
        }
    }

    private static void persistTokens(Credentials cred, File tokenFile) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(tokenFile);
             DataOutputStream dos = new DataOutputStream(fos);){
            cred.writeTokenStorageToStream(dos);
        }
        LOG.info((Object)("Tokens loaded in " + tokenFile.getAbsolutePath()));
    }

    private static Token<?> getDelegationTokenFromHS(HSClientProtocol hsProxy, Configuration conf) throws IOException {
        GetDelegationTokenRequest request = (GetDelegationTokenRequest)RecordFactoryProvider.getRecordFactory(null).newRecordInstance(GetDelegationTokenRequest.class);
        request.setRenewer(Master.getMasterPrincipal((Configuration)conf));
        org.apache.hadoop.yarn.api.records.Token mrDelegationToken = hsProxy.getDelegationToken(request).getDelegationToken();
        return ConverterUtils.convertFromYarn((org.apache.hadoop.yarn.api.records.Token)mrDelegationToken, (InetSocketAddress)hsProxy.getConnectAddress());
    }

    private static Text getMRTokenRenewerInternal(JobConf jobConf) throws IOException {
        Text renewer;
        String servicePrincipal = jobConf.get(YARN_RESOURCEMANAGER_PRINCIPAL, jobConf.get("mapreduce.jobtracker.kerberos.principal"));
        if (servicePrincipal != null) {
            String target = jobConf.get(YARN_RESOURCEMANAGER_ADDRESS, jobConf.get(MAPREDUCE_JOBTRACKER_ADDRESS));
            if (target == null) {
                target = jobConf.get(MAPRED_JOB_TRACKER);
            }
            String addr = NetUtils.createSocketAddr((String)target).getHostName();
            renewer = new Text(SecurityUtil.getServerPrincipal((String)servicePrincipal, (String)addr));
        } else {
            renewer = new Text("azkaban mr tokens");
        }
        return renewer;
    }
}

