/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util.filesystem;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import org.apache.commons.io.IOCase;
import org.apache.gobblin.util.filesystem.ExceptionCatchingPathAlterationListenerDecorator;
import org.apache.gobblin.util.filesystem.FileStatusEntry;
import org.apache.gobblin.util.filesystem.PathAlterationListener;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathAlterationObserver {
    private static final Logger log = LoggerFactory.getLogger(PathAlterationObserver.class);
    private final Map<PathAlterationListener, PathAlterationListener> listeners = Maps.newConcurrentMap();
    private final FileStatusEntry rootEntry;
    private final PathFilter pathFilter;
    private final Comparator<Path> comparator;
    private final FileSystem fs;
    private final Path[] EMPTY_PATH_ARRAY = new Path[0];

    public void destroy() {
    }

    public PathAlterationObserver(String directoryName) throws IOException {
        this(new Path(directoryName));
    }

    public PathAlterationObserver(String directoryName, PathFilter pathFilter) throws IOException {
        this(new Path(directoryName), pathFilter);
    }

    public PathAlterationObserver(Path directory) throws IOException {
        this(directory, null);
    }

    public PathAlterationObserver(Path directory, PathFilter pathFilter) throws IOException {
        this(new FileStatusEntry(directory), pathFilter);
    }

    public PathAlterationObserver(FileStatusEntry rootEntry, PathFilter pathFilter) throws IOException {
        if (rootEntry == null) {
            throw new IllegalArgumentException("Root entry is missing");
        }
        if (rootEntry.getPath() == null) {
            throw new IllegalArgumentException("Root directory is missing");
        }
        this.rootEntry = rootEntry;
        this.pathFilter = pathFilter;
        this.fs = rootEntry.getPath().getFileSystem(new Configuration());
        this.comparator = new Comparator<Path>(){

            @Override
            public int compare(Path o1, Path o2) {
                return IOCase.SENSITIVE.checkCompareTo(o1.toUri().toString(), o2.toUri().toString());
            }
        };
    }

    public void addListener(PathAlterationListener listener) {
        if (listener != null) {
            this.listeners.put(listener, new ExceptionCatchingPathAlterationListenerDecorator(listener));
        }
    }

    public void removeListener(PathAlterationListener listener) {
        if (listener != null) {
            this.listeners.remove(listener);
        }
    }

    public Iterable<PathAlterationListener> getListeners() {
        return this.listeners.keySet();
    }

    public void initialize() throws IOException {
        this.rootEntry.refresh(this.rootEntry.getPath());
        FileStatusEntry[] children = this.doListPathsEntry(this.rootEntry.getPath(), this.rootEntry);
        this.rootEntry.setChildren(children);
    }

    public void checkAndNotify() throws IOException {
        for (PathAlterationListener listener : this.listeners.values()) {
            listener.onStart(this);
        }
        Path rootPath = this.rootEntry.getPath();
        if (this.fs.exists(rootPath)) {
            this.checkAndNotify(this.rootEntry, this.rootEntry.getChildren(), this.listPaths(rootPath));
        } else if (this.rootEntry.isExists()) {
            this.checkAndNotify(this.rootEntry, this.rootEntry.getChildren(), this.EMPTY_PATH_ARRAY);
        }
        for (PathAlterationListener listener : this.listeners.values()) {
            listener.onStop(this);
        }
    }

    private void checkAndNotify(FileStatusEntry parent, FileStatusEntry[] previous, Path[] currentPaths) throws IOException {
        int c = 0;
        FileStatusEntry[] current = currentPaths.length > 0 ? new FileStatusEntry[currentPaths.length] : FileStatusEntry.EMPTY_ENTRIES;
        for (FileStatusEntry previousEntry : previous) {
            while (c < currentPaths.length && this.comparator.compare(previousEntry.getPath(), currentPaths[c]) > 0) {
                current[c] = this.createPathEntry(parent, currentPaths[c]);
                this.doCreate(current[c]);
                ++c;
            }
            if (c < currentPaths.length && this.comparator.compare(previousEntry.getPath(), currentPaths[c]) == 0) {
                this.doMatch(previousEntry, currentPaths[c]);
                this.checkAndNotify(previousEntry, previousEntry.getChildren(), this.listPaths(currentPaths[c]));
                current[c] = previousEntry;
                ++c;
                continue;
            }
            this.checkAndNotify(previousEntry, previousEntry.getChildren(), this.EMPTY_PATH_ARRAY);
            this.doDelete(previousEntry);
        }
        while (c < currentPaths.length) {
            current[c] = this.createPathEntry(parent, currentPaths[c]);
            this.doCreate(current[c]);
            ++c;
        }
        parent.setChildren(current);
    }

    private FileStatusEntry createPathEntry(FileStatusEntry parent, Path childPath) throws IOException {
        FileStatusEntry entry = parent.newChildInstance(childPath);
        entry.refresh(childPath);
        FileStatusEntry[] children = this.doListPathsEntry(childPath, entry);
        entry.setChildren(children);
        return entry;
    }

    private FileStatusEntry[] doListPathsEntry(Path path, FileStatusEntry entry) throws IOException {
        Path[] paths = this.listPaths(path);
        FileStatusEntry[] children = paths.length > 0 ? new FileStatusEntry[paths.length] : FileStatusEntry.EMPTY_ENTRIES;
        for (int i = 0; i < paths.length; ++i) {
            children[i] = this.createPathEntry(entry, paths[i]);
        }
        return children;
    }

    private void doCreate(FileStatusEntry entry) {
        FileStatusEntry[] children;
        for (PathAlterationListener listener : this.listeners.values()) {
            if (entry.isDirectory()) {
                listener.onDirectoryCreate(entry.getPath());
                continue;
            }
            listener.onFileCreate(entry.getPath());
        }
        for (FileStatusEntry aChildren : children = entry.getChildren()) {
            this.doCreate(aChildren);
        }
    }

    private void doMatch(FileStatusEntry entry, Path path) throws IOException {
        if (entry.refresh(path)) {
            for (PathAlterationListener listener : this.listeners.values()) {
                if (entry.isDirectory()) {
                    listener.onDirectoryChange(path);
                    continue;
                }
                listener.onFileChange(path);
            }
        }
    }

    private void doDelete(FileStatusEntry entry) {
        for (PathAlterationListener listener : this.listeners.values()) {
            if (entry.isDirectory()) {
                listener.onDirectoryDelete(entry.getPath());
                continue;
            }
            listener.onFileDelete(entry.getPath());
        }
    }

    private Path[] listPaths(Path path) throws IOException {
        Path[] children = null;
        ArrayList<Path> tmpChildrenPath = new ArrayList<Path>();
        if (this.fs.isDirectory(path)) {
            FileStatus[] chiledrenFileStatus;
            for (FileStatus childFileStatus : chiledrenFileStatus = this.pathFilter == null ? this.fs.listStatus(path) : this.fs.listStatus(path, this.pathFilter)) {
                tmpChildrenPath.add(childFileStatus.getPath());
            }
            children = tmpChildrenPath.toArray(new Path[tmpChildrenPath.size()]);
        }
        if (children == null) {
            children = this.EMPTY_PATH_ARRAY;
        }
        if (this.comparator != null && children.length > 1) {
            Arrays.sort(children, this.comparator);
        }
        return children;
    }
}

