/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.gobblin.password.PasswordManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveJdbcConnector
implements Closeable {
    public static final String HIVESERVER_VERSION = "hiveserver.version";
    public static final String DEFAULT_HIVESERVER_VERSION = "2";
    public static final String HIVESERVER_CONNECTION_STRING = "hiveserver.connection.string";
    public static final String HIVESERVER_URL = "hiveserver.url";
    public static final String HIVESERVER_USER = "hiveserver.user";
    public static final String HIVESERVER_PASSWORD = "hiveserver.password";
    public static final String HIVESITE_DIR = "hivesite.dir";
    public static final String HIVE_EXECUTION_SIMULATE = "hive.execution.simulate";
    private static final String HIVE_JDBC_DRIVER_NAME = "org.apache.hadoop.hive.jdbc.HiveDriver";
    private static final String HIVE2_JDBC_DRIVER_NAME = "org.apache.hive.jdbc.HiveDriver";
    private static final String HIVE_EMBEDDED_CONNECTION_STRING = "jdbc:hive://";
    private static final String HIVE2_EMBEDDED_CONNECTION_STRING = "jdbc:hive2://";
    private static final String HIVE_CONFIG_KEY_PREFIX = "hive.";
    private static final int MAX_OUTPUT_STMT_LENGTH = 1000;
    private static final Logger LOG = LoggerFactory.getLogger(HiveJdbcConnector.class);
    private Connection conn;
    private int hiveServerVersion;
    private boolean isSimulate;

    private HiveJdbcConnector() {
        this(false);
    }

    private HiveJdbcConnector(boolean isSimulate) {
        this.isSimulate = isSimulate;
    }

    public static HiveJdbcConnector newEmbeddedConnector(int hiveServerVersion) throws SQLException {
        return new HiveJdbcConnector().withHiveServerVersion(hiveServerVersion).withHiveEmbeddedConnection();
    }

    public static HiveJdbcConnector newConnectorWithProps(Properties compactRunProps) throws SQLException {
        boolean isSimulate = Boolean.valueOf(compactRunProps.getProperty(HIVE_EXECUTION_SIMULATE));
        HiveJdbcConnector hiveJdbcConnector = new HiveJdbcConnector(isSimulate);
        hiveJdbcConnector.withHiveServerVersion(Integer.parseInt(compactRunProps.getProperty(HIVESERVER_VERSION, DEFAULT_HIVESERVER_VERSION)));
        if (compactRunProps.containsKey(HIVESITE_DIR)) {
            HiveJdbcConnector.addHiveSiteDirToClasspath(compactRunProps.getProperty(HIVESITE_DIR));
        }
        if (compactRunProps.containsKey(HIVESERVER_CONNECTION_STRING)) {
            hiveJdbcConnector.withHiveConnectionFromUrl(compactRunProps.getProperty(HIVESERVER_CONNECTION_STRING));
        } else if (compactRunProps.containsKey(HIVESERVER_URL)) {
            hiveJdbcConnector.withHiveConnectionFromUrlUserPassword(compactRunProps.getProperty(HIVESERVER_URL), compactRunProps.getProperty(HIVESERVER_USER), PasswordManager.getInstance((Properties)compactRunProps).readPassword(compactRunProps.getProperty(HIVESERVER_PASSWORD)));
        } else {
            hiveJdbcConnector.withHiveEmbeddedConnection();
        }
        hiveJdbcConnector.setHiveProperties(compactRunProps);
        return hiveJdbcConnector;
    }

    private HiveJdbcConnector withHiveServerVersion(int hiveServerVersion) {
        block4: {
            try {
                if (hiveServerVersion == 1) {
                    Class.forName(HIVE_JDBC_DRIVER_NAME);
                    break block4;
                }
                if (hiveServerVersion == 2) {
                    Class.forName(HIVE2_JDBC_DRIVER_NAME);
                    break block4;
                }
                throw new RuntimeException(hiveServerVersion + " is not a valid HiveServer version.");
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Cannot find a suitable driver of HiveServer version " + hiveServerVersion + ".", e);
            }
        }
        this.hiveServerVersion = hiveServerVersion;
        return this;
    }

    private HiveJdbcConnector withHiveConnectionFromUrl(String hiveServerUrl) throws SQLException {
        this.conn = DriverManager.getConnection(hiveServerUrl);
        return this;
    }

    private HiveJdbcConnector withHiveConnectionFromUrlUserPassword(String hiveServerUrl, String hiveServerUser, String hiveServerPassword) throws SQLException {
        this.conn = DriverManager.getConnection(hiveServerUrl, hiveServerUser, hiveServerPassword);
        return this;
    }

    private HiveJdbcConnector withHiveEmbeddedConnection() throws SQLException {
        this.conn = this.hiveServerVersion == 1 ? DriverManager.getConnection(HIVE_EMBEDDED_CONNECTION_STRING) : DriverManager.getConnection(HIVE2_EMBEDDED_CONNECTION_STRING);
        return this;
    }

    private static void addHiveSiteDirToClasspath(String hiveSiteDir) {
        LOG.info("Adding " + hiveSiteDir + " to CLASSPATH");
        File f = new File(hiveSiteDir);
        try {
            URL u = f.toURI().toURL();
            URLClassLoader urlClassLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
            Class<URLClassLoader> urlClass = URLClassLoader.class;
            Method method = urlClass.getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
            method.invoke((Object)urlClassLoader, u);
        }
        catch (IOException | ReflectiveOperationException e) {
            throw new RuntimeException("Unable to add hive.site.dir to CLASSPATH", e);
        }
    }

    private void setHiveProperties(Properties props) throws SQLException {
        Preconditions.checkNotNull((Object)this.conn, (Object)"The Hive connection must be set before any queries can be run");
        try (PreparedStatement preparedStatement = this.conn.prepareStatement("set ?=?");){
            Enumeration<?> enumeration = props.propertyNames();
            while (enumeration.hasMoreElements()) {
                String propertyName = (String)enumeration.nextElement();
                if (!propertyName.startsWith(HIVE_CONFIG_KEY_PREFIX)) continue;
                preparedStatement.setString(1, propertyName);
                preparedStatement.setString(2, props.getProperty(propertyName));
                preparedStatement.execute();
            }
        }
    }

    public void executeStatements(String ... statements) throws SQLException {
        Preconditions.checkNotNull((Object)this.conn, (Object)"The Hive connection must be set before any queries can be run");
        for (String statement : statements) {
            if (this.isSimulate) {
                LOG.info("[SIMULATE MODE] STATEMENT NOT RUN: " + HiveJdbcConnector.choppedStatement(statement));
                continue;
            }
            LOG.info("RUNNING STATEMENT: " + HiveJdbcConnector.choppedStatement(statement));
            try (Statement stmt = this.conn.createStatement();){
                try {
                    stmt.execute(statement);
                }
                catch (SQLException sqe) {
                    LOG.error("Failed statement: " + statement);
                    throw sqe;
                }
            }
        }
    }

    private static String choppedStatement(String statement) {
        if (statement.length() <= 1000) {
            return statement;
        }
        return statement.substring(0, 1000) + "...... (" + (statement.length() - 1000) + " characters ommitted)";
    }

    public Connection getConnection() {
        return this.conn;
    }

    @Override
    public void close() throws IOException {
        if (this.conn != null) {
            try {
                this.conn.close();
            }
            catch (SQLException e) {
                LOG.error("Failed to close JDBC connection", (Throwable)e);
            }
        }
    }
}

