/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.source.extractor.extract.google;

import com.github.rholder.retry.RetryException;
import com.github.rholder.retry.Retryer;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.services.analytics.Analytics;
import com.google.api.services.analytics.model.UnsampledReport;
import com.google.api.services.drive.Drive;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Closer;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.gobblin.config.ConfigBuilder;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.exception.NonTransientException;
import org.apache.gobblin.instrumented.Instrumented;
import org.apache.gobblin.metrics.ContextAwareTimer;
import org.apache.gobblin.metrics.GobblinMetrics;
import org.apache.gobblin.source.extractor.DataRecordException;
import org.apache.gobblin.source.extractor.Extractor;
import org.apache.gobblin.source.extractor.Watermark;
import org.apache.gobblin.source.extractor.extract.LongWatermark;
import org.apache.gobblin.source.extractor.extract.google.GoogleCommon;
import org.apache.gobblin.source.extractor.extract.google.GoogleDriveExtractor;
import org.apache.gobblin.source.extractor.extract.google.GoogleDriveFsHelper;
import org.apache.gobblin.source.extractor.filebased.CsvFileDownloader;
import org.apache.gobblin.source.extractor.filebased.FileBasedHelper;
import org.apache.gobblin.source.workunit.WorkUnit;
import org.apache.gobblin.util.retry.RetryerFactory;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoogleAnalyticsUnsampledExtractor<S, D>
implements Extractor<S, D> {
    private static final Logger LOG = LoggerFactory.getLogger(GoogleAnalyticsUnsampledExtractor.class);
    static final String GA_UNSAMPLED_REPORT_PREFIX = "source.google_analytics.report.unsampled.";
    static final String GA_UNSAMPLED_REPORT_CREATION_TIMER = "source.google_analytics.report.unsampled.creation.timer";
    static final String REQUEST_RETRY_PREFIX = "source.google_analytics.report.request_retry.";
    static final String POLL_RETRY_PREFIX = "source.google_analytics.report.poll.";
    static final Config POLL_RETRY_DEFAULTS;
    static final String WATERMARK_INPUTFORMAT = "yyyyMMddHHmmss";
    static final String DELETE_TEMP_UNSAMPLED_REPORT = "source.google_analytics.report.unsampled.delete_temp_unsampled_report";
    static final String DOWNLOAD_TYPE_GOOGLE_DRIVE = "GOOGLE_DRIVE";
    private final Closer closer = Closer.create();
    private final Analytics gaService;
    private final WorkUnitState wuState;
    private final Extractor<S, D> actualExtractor;
    private final DateTimeFormatter googleAnalyticsFormatter;
    private final DateTimeFormatter watermarkFormatter;
    private final long nextWatermark;

    public GoogleAnalyticsUnsampledExtractor(WorkUnitState wuState) throws IOException {
        this.wuState = wuState;
        this.googleAnalyticsFormatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd").withZone(DateTimeZone.forID((String)wuState.getProp("source.timezone", "America/Los_Angeles")));
        this.watermarkFormatter = DateTimeFormat.forPattern((String)WATERMARK_INPUTFORMAT).withZone(DateTimeZone.forID((String)wuState.getProp("source.timezone", "America/Los_Angeles")));
        Credential credential = new GoogleCommon.CredentialBuilder(wuState.getProp("source.conn.private.key"), wuState.getPropAsList("source.google.api_scopes")).fileSystemUri(wuState.getProp("source.google.privatekey_fs_uri")).proxyUrl(wuState.getProp("source.conn.use.proxy.url")).port(wuState.getProp("source.conn.use.proxy.port")).serviceAccountId(wuState.getProp("source.conn.username")).build();
        this.gaService = new Analytics.Builder(credential.getTransport(), GoogleCommon.getJsonFactory(), (HttpRequestInitializer)credential).setApplicationName((String)Preconditions.checkNotNull((Object)wuState.getProp("source.google.application_name"))).build();
        Drive driveClient = new Drive.Builder(credential.getTransport(), GoogleCommon.getJsonFactory(), (HttpRequestInitializer)Preconditions.checkNotNull((Object)credential, (Object)"Credential is required")).setApplicationName((String)Preconditions.checkNotNull((Object)wuState.getProp("source.google.application_name"), (Object)"ApplicationName is required")).build();
        GoogleDriveFsHelper fsHelper = (GoogleDriveFsHelper)((Object)this.closer.register((Closeable)((Object)new GoogleDriveFsHelper((State)wuState, driveClient))));
        UnsampledReport request = new UnsampledReport().setAccountId((String)Preconditions.checkNotNull((Object)wuState.getProp("source.google_analytics.report.account_id"), (Object)"source.google_analytics.report.account_id is required")).setWebPropertyId((String)Preconditions.checkNotNull((Object)wuState.getProp("source.google_analytics.report.web_property_id"), (Object)"source.google_analytics.report.web_property_id is required")).setProfileId((String)Preconditions.checkNotNull((Object)wuState.getProp("source.google_analytics.report.view_id"), (Object)"source.google_analytics.report.view_id is required")).setTitle((String)Preconditions.checkNotNull((Object)wuState.getProp("source.entity"), (Object)"source.entity is required.")).setStartDate(this.convertFormat(((LongWatermark)wuState.getWorkunit().getLowWatermark(LongWatermark.class)).getValue())).setEndDate(this.convertFormat(((LongWatermark)wuState.getWorkunit().getExpectedHighWatermark(LongWatermark.class)).getValue())).setMetrics((String)Preconditions.checkNotNull((Object)wuState.getProp("source.google_analytics.report.metrics"), (Object)"source.google_analytics.report.metrics is required.")).setDimensions(wuState.getProp("source.google_analytics.report.dimensions")).setSegment(wuState.getProp("source.google_analytics.report.segments")).setFilters(wuState.getProp("source.google_analytics.report.filters"));
        UnsampledReport createdReport = this.prepareUnsampledReport(request, fsHelper, wuState.getPropAsBoolean(DELETE_TEMP_UNSAMPLED_REPORT, true));
        DateTime nextWatermarkDateTime = this.googleAnalyticsFormatter.parseDateTime(createdReport.getEndDate()).plusDays(1);
        this.nextWatermark = Long.parseLong(this.watermarkFormatter.print((ReadableInstant)nextWatermarkDateTime));
        this.actualExtractor = (Extractor)this.closer.register(new GoogleDriveExtractor(this.copyOf(wuState), (FileBasedHelper)fsHelper));
    }

    @VisibleForTesting
    GoogleAnalyticsUnsampledExtractor(WorkUnitState state, Extractor<S, D> actualExtractor, Analytics gaService) throws IOException {
        this.wuState = state;
        this.googleAnalyticsFormatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd").withZone(DateTimeZone.forID((String)state.getProp("source.timezone", "America/Los_Angeles")));
        this.watermarkFormatter = DateTimeFormat.forPattern((String)WATERMARK_INPUTFORMAT).withZone(DateTimeZone.forID((String)state.getProp("source.timezone", "America/Los_Angeles")));
        this.actualExtractor = actualExtractor;
        this.gaService = gaService;
        this.nextWatermark = -1L;
    }

    private WorkUnitState copyOf(WorkUnitState src) {
        WorkUnit copiedWorkUnit = WorkUnit.copyOf((WorkUnit)src.getWorkunit());
        copiedWorkUnit.addAllIfNotExist(src.getJobState());
        WorkUnitState workUnitState = new WorkUnitState(copiedWorkUnit, src.getJobState());
        workUnitState.addAll((State)src);
        return workUnitState;
    }

    @VisibleForTesting
    UnsampledReport prepareUnsampledReport(UnsampledReport request, final GoogleDriveFsHelper fsHelper, boolean isDeleteTempReport) throws IOException {
        UnsampledReport createdReport = this.createUnsampledReports(request);
        final String fileId = createdReport.getDriveDownloadDetails().getDocumentId();
        LOG.info("Temporary unsampled report created in Google Drive: " + fileId);
        if (isDeleteTempReport) {
            this.closer.register(new Closeable(){

                @Override
                public void close() throws IOException {
                    LOG.info("Deleting created temporary unsampled report from Google drive " + fileId);
                    fsHelper.deleteFile(fileId);
                }
            });
        } else {
            LOG.warn("Temporary unsampled report will not be deleted as requested. File ID: " + fileId);
        }
        this.wuState.setProp("source.filebased.files.to.pull", (Object)fileId);
        if (!this.wuState.contains("source.filebased.downloader.class")) {
            this.wuState.setProp("source.filebased.downloader.class", (Object)CsvFileDownloader.class.getName());
        }
        return createdReport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    UnsampledReport createUnsampledReports(UnsampledReport request) throws IOException {
        long startTimeInMillis = System.currentTimeMillis();
        try {
            UnsampledReport requestedReport = this.requestUnsampledReport(request);
            UnsampledReport createdReport = this.pollForCompletion((State)this.wuState, this.gaService, requestedReport);
            createdReport.setEndDate(requestedReport.getEndDate());
            UnsampledReport unsampledReport = createdReport;
            return unsampledReport;
        }
        finally {
            long delta = System.currentTimeMillis() - startTimeInMillis;
            if (GobblinMetrics.isEnabled((State)this.wuState)) {
                ContextAwareTimer timer = Instrumented.getMetricContext((State)this.wuState, this.getClass()).timer(GA_UNSAMPLED_REPORT_CREATION_TIMER);
                Instrumented.updateTimer((Optional)Optional.of((Object)timer), (long)delta, (TimeUnit)TimeUnit.MILLISECONDS);
            }
        }
    }

    @VisibleForTesting
    UnsampledReport requestUnsampledReport(UnsampledReport request) throws IOException {
        String accountId = request.getAccountId();
        String webPropertyId = request.getWebPropertyId();
        String profileId = request.getProfileId();
        request.setAccountId(null).setWebPropertyId(null).setProfileId(null);
        final String endDate = request.getEndDate();
        final Analytics.Management.UnsampledReports.Insert insertRequest = this.gaService.management().unsampledReports().insert(accountId, webPropertyId, profileId, request);
        Config config = ConfigBuilder.create().loadProps(this.wuState.getProperties(), REQUEST_RETRY_PREFIX).build();
        Retryer retryer = RetryerFactory.newInstance((Config)config);
        LOG.info("Requesting to create unsampled report " + request);
        try {
            return (UnsampledReport)retryer.call((Callable)new Callable<UnsampledReport>(){

                @Override
                public UnsampledReport call() throws Exception {
                    UnsampledReport response = (UnsampledReport)insertRequest.execute();
                    if (ReportCreationStatus.FAILED.name().equals(response.getStatus())) {
                        throw new NonTransientException("Failed to create unsampled report " + response);
                    }
                    response.setEndDate(endDate);
                    return response;
                }
            });
        }
        catch (ExecutionException e) {
            throw new IOException(e);
        }
        catch (RetryException e) {
            throw new RuntimeException(e);
        }
    }

    private String convertFormat(long watermark) {
        Preconditions.checkArgument((watermark > 0L ? 1 : 0) != 0, (Object)"Watermark should be positive number.");
        return this.googleAnalyticsFormatter.print((ReadableInstant)this.watermarkFormatter.parseDateTime(Long.toString(watermark)));
    }

    @VisibleForTesting
    UnsampledReport pollForCompletion(State state, final Analytics gaService, final UnsampledReport requestedReport) throws IOException {
        Config config = ConfigBuilder.create().loadProps(state.getProperties(), POLL_RETRY_PREFIX).build().withFallback((ConfigMergeable)POLL_RETRY_DEFAULTS);
        Retryer retryer = RetryerFactory.newInstance((Config)config);
        LOG.info("Will poll for completion on unsampled report with retry config: " + config);
        final Stopwatch stopwatch = Stopwatch.createStarted();
        UnsampledReport result = null;
        try {
            result = (UnsampledReport)retryer.call((Callable)new Callable<UnsampledReport>(){

                @Override
                public UnsampledReport call() throws Exception {
                    UnsampledReport response = null;
                    try {
                        response = (UnsampledReport)gaService.management().unsampledReports().get(requestedReport.getAccountId(), requestedReport.getWebPropertyId(), requestedReport.getProfileId(), requestedReport.getId()).execute();
                    }
                    catch (Exception e) {
                        LOG.warn("Encountered exception while polling for unsampled report. Will keep polling. Elasped so far: " + stopwatch.elapsed(TimeUnit.SECONDS) + " seconds", (Throwable)e);
                        throw e;
                    }
                    ReportCreationStatus status = ReportCreationStatus.valueOf(response.getStatus());
                    switch (status) {
                        case FAILED: {
                            throw new NonTransientException("Unsampled report has failed to be generated. " + response);
                        }
                        case PENDING: {
                            LOG.info("Waiting for report completion. Elasped so far: " + stopwatch.elapsed(TimeUnit.SECONDS) + " seconds for unsampled report: " + response);
                            throw new RuntimeException("Not completed yet. This will be retried. " + response);
                        }
                        case COMPLETED: {
                            return response;
                        }
                    }
                    throw new NonTransientException((Object)((Object)status) + " is not supported. " + response);
                }
            });
        }
        catch (ExecutionException e) {
            throw new IOException(e);
        }
        catch (RetryException e) {
            throw new RuntimeException(e);
        }
        LOG.info("Unsampled report creation has been completed. " + result);
        Preconditions.checkArgument((boolean)DOWNLOAD_TYPE_GOOGLE_DRIVE.equals(result.getDownloadType()), (Object)(result.getDownloadType() + " DownloadType is not supported."));
        return result;
    }

    public void close() throws IOException {
        LOG.info("Updating the current state high water mark with " + this.nextWatermark);
        this.wuState.setActualHighWatermark((Watermark)new LongWatermark(this.nextWatermark));
        this.closer.close();
    }

    public S getSchema() throws IOException {
        return (S)this.actualExtractor.getSchema();
    }

    public D readRecord(D reuse) throws DataRecordException, IOException {
        return (D)this.actualExtractor.readRecord(reuse);
    }

    public long getExpectedRecordCount() {
        return this.actualExtractor.getExpectedRecordCount();
    }

    public long getHighWatermark() {
        return this.actualExtractor.getHighWatermark();
    }

    static {
        ImmutableMap configMap = ImmutableMap.builder().put((Object)"time_out_ms", (Object)TimeUnit.HOURS.toMillis(1L)).put((Object)"interval_ms", (Object)TimeUnit.MINUTES.toMillis(1L)).put((Object)"retry_type", (Object)RetryerFactory.RetryType.FIXED.name()).build();
        POLL_RETRY_DEFAULTS = ConfigFactory.parseMap((Map)configMap);
    }

    static enum ReportCreationStatus {
        FAILED,
        PENDING,
        COMPLETED;

    }
}

