/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.HashTableLoaderFactory;
import org.apache.hadoop.hive.ql.exec.AbstractMapJoinOperator;
import org.apache.hadoop.hive.ql.exec.HashTableLoader;
import org.apache.hadoop.hive.ql.exec.ObjectCache;
import org.apache.hadoop.hive.ql.exec.ObjectCacheFactory;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinKey;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinObjectSerDeContext;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinRowContainer;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinTableContainer;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinTableContainerSerDe;
import org.apache.hadoop.hive.ql.exec.persistence.UnwrapRowContainer;
import org.apache.hadoop.hive.ql.log.PerfLogger;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.MapJoinDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.plan.api.OperatorType;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.SerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeUtils;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.util.ReflectionUtils;

public class MapJoinOperator
extends AbstractMapJoinOperator<MapJoinDesc>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log LOG = LogFactory.getLog((String)MapJoinOperator.class.getName());
    private static final String CLASS_NAME = MapJoinOperator.class.getName();
    private final PerfLogger perfLogger = PerfLogger.getPerfLogger();
    private transient String tableKey;
    private transient String serdeKey;
    private transient ObjectCache cache;
    protected HashTableLoader loader;
    protected transient MapJoinTableContainer[] mapJoinTables;
    private transient MapJoinTableContainerSerDe[] mapJoinTableSerdes;
    private transient boolean hashTblInitedOnce;
    private transient MapJoinTableContainer.ReusableGetAdaptor[] hashMapRowGetters;
    private UnwrapRowContainer[] unwrapContainer;

    public MapJoinOperator() {
    }

    public MapJoinOperator(AbstractMapJoinOperator<? extends MapJoinDesc> mjop) {
        super(mjop);
    }

    @Override
    public void endGroup() throws HiveException {
        this.defaultEndGroup();
    }

    @Override
    public void startGroup() throws HiveException {
        this.defaultStartGroup();
    }

    @Override
    protected void initializeOp(Configuration hconf) throws HiveException {
        this.unwrapContainer = new UnwrapRowContainer[((MapJoinDesc)this.conf).getTagLength()];
        super.initializeOp(hconf);
        int tagLen = ((MapJoinDesc)this.conf).getTagLength();
        this.tableKey = "__HASH_MAP_" + this.getOperatorId() + "_container";
        this.serdeKey = "__HASH_MAP_" + this.getOperatorId() + "_serde";
        this.cache = ObjectCacheFactory.getCache(hconf);
        this.loader = HashTableLoaderFactory.getLoader(hconf);
        this.hashMapRowGetters = null;
        this.mapJoinTables = (MapJoinTableContainer[])this.cache.retrieve(this.tableKey);
        this.mapJoinTableSerdes = (MapJoinTableContainerSerDe[])this.cache.retrieve(this.serdeKey);
        this.hashTblInitedOnce = true;
        LOG.info((Object)"Try to retrieve from cache");
        if (this.mapJoinTables == null || this.mapJoinTableSerdes == null) {
            LOG.info((Object)"Did not find tables in cache");
            this.mapJoinTables = new MapJoinTableContainer[tagLen];
            this.mapJoinTableSerdes = new MapJoinTableContainerSerDe[tagLen];
            this.hashTblInitedOnce = false;
        }
    }

    @Override
    protected List<ObjectInspector> getValueObjectInspectors(byte alias, List<ObjectInspector>[] aliasToObjectInspectors) {
        int[] valueIndex = ((MapJoinDesc)this.conf).getValueIndex(alias);
        if (valueIndex == null) {
            return super.getValueObjectInspectors(alias, aliasToObjectInspectors);
        }
        this.unwrapContainer[alias] = new UnwrapRowContainer(alias, valueIndex, this.hasFilter(alias));
        List<ObjectInspector> inspectors = aliasToObjectInspectors[alias];
        int bigPos = ((MapJoinDesc)this.conf).getPosBigTable();
        ArrayList<ObjectInspector> valueOI = new ArrayList<ObjectInspector>();
        for (int i = 0; i < valueIndex.length; ++i) {
            if (valueIndex[i] >= 0 && !this.joinKeysObjectInspectors[bigPos].isEmpty()) {
                valueOI.add((ObjectInspector)this.joinKeysObjectInspectors[bigPos].get(valueIndex[i]));
                continue;
            }
            valueOI.add(inspectors.get(i));
        }
        return valueOI;
    }

    public void generateMapMetaData() throws HiveException, SerDeException {
        TableDesc keyTableDesc = ((MapJoinDesc)this.conf).getKeyTblDesc();
        SerDe keySerializer = (SerDe)ReflectionUtils.newInstance(keyTableDesc.getDeserializerClass(), null);
        SerDeUtils.initializeSerDe((Deserializer)keySerializer, null, (Properties)keyTableDesc.getProperties(), null);
        MapJoinObjectSerDeContext keyContext = new MapJoinObjectSerDeContext(keySerializer, false);
        for (int pos = 0; pos < this.order.length; ++pos) {
            if (pos == this.posBigTable) continue;
            TableDesc valueTableDesc = ((MapJoinDesc)this.conf).getNoOuterJoin() ? ((MapJoinDesc)this.conf).getValueTblDescs().get(pos) : ((MapJoinDesc)this.conf).getValueFilteredTblDescs().get(pos);
            SerDe valueSerDe = (SerDe)ReflectionUtils.newInstance(valueTableDesc.getDeserializerClass(), null);
            SerDeUtils.initializeSerDe((Deserializer)valueSerDe, null, (Properties)valueTableDesc.getProperties(), null);
            MapJoinObjectSerDeContext valueContext = new MapJoinObjectSerDeContext(valueSerDe, this.hasFilter(pos));
            this.mapJoinTableSerdes[pos] = new MapJoinTableContainerSerDe(keyContext, valueContext);
        }
    }

    private void loadHashTable() throws HiveException {
        if (this.getExecContext() == null || this.getExecContext().getLocalWork() == null || !this.getExecContext().getLocalWork().getInputFileChangeSensitive()) {
            if (this.hashTblInitedOnce) {
                return;
            }
            this.hashTblInitedOnce = true;
        }
        this.perfLogger.PerfLogBegin(CLASS_NAME, "LoadHashtable");
        this.loader.init(this.getExecContext(), this.hconf, this);
        this.loader.load(this.mapJoinTables, this.mapJoinTableSerdes);
        if (!((MapJoinDesc)this.conf).isBucketMapJoin()) {
            LOG.info((Object)"This is not bucket map join, so cache");
            this.cache.cache(this.tableKey, this.mapJoinTables);
            this.cache.cache(this.serdeKey, this.mapJoinTableSerdes);
        }
        this.perfLogger.PerfLogEnd(CLASS_NAME, "LoadHashtable");
    }

    @Override
    public void cleanUpInputFileChangedOp() throws HiveException {
        try {
            if (this.firstRow) {
                this.generateMapMetaData();
                this.firstRow = false;
            }
            this.loadHashTable();
        }
        catch (SerDeException e) {
            throw new HiveException(e);
        }
    }

    protected void setMapJoinKey(MapJoinTableContainer.ReusableGetAdaptor dest, Object row, byte alias) throws HiveException {
        dest.setFromRow(row, this.joinKeys[alias], this.joinKeysObjectInspectors[alias]);
    }

    protected MapJoinKey getRefKey(byte alias) {
        for (int pos = 0; pos < this.order.length; pos = (int)((byte)(pos + 1))) {
            MapJoinKey refKey;
            if (pos == alias || (refKey = this.mapJoinTables[pos].getAnyKey()) == null) continue;
            return refKey;
        }
        return null;
    }

    @Override
    public void processOp(Object row, int tag) throws HiveException {
        try {
            int pos;
            if (this.firstRow) {
                this.generateMapMetaData();
                this.loadHashTable();
                this.firstRow = false;
            }
            this.alias = (byte)tag;
            if (this.hashMapRowGetters == null) {
                this.hashMapRowGetters = new MapJoinTableContainer.ReusableGetAdaptor[this.mapJoinTables.length];
                MapJoinKey refKey = this.getRefKey(this.alias);
                for (int pos2 = 0; pos2 < this.order.length; pos2 = (int)((byte)(pos2 + 1))) {
                    if (pos2 == this.alias) continue;
                    this.hashMapRowGetters[pos2] = this.mapJoinTables[pos2].createGetter(refKey);
                }
            }
            MapJoinTableContainer.ReusableGetAdaptor firstSetKey = null;
            int fieldCount = this.joinKeys[this.alias].size();
            boolean joinNeeded = false;
            for (pos = 0; pos < this.order.length; pos = (int)((byte)(pos + 1))) {
                MapJoinTableContainer.ReusableGetAdaptor adaptor;
                if (pos == this.alias) continue;
                if (firstSetKey == null) {
                    adaptor = firstSetKey = this.hashMapRowGetters[pos];
                    this.setMapJoinKey(firstSetKey, row, this.alias);
                } else {
                    adaptor = this.hashMapRowGetters[pos];
                    adaptor.setFromOther(firstSetKey);
                }
                MapJoinRowContainer rowContainer = adaptor.getCurrentRows();
                if (rowContainer != null && this.unwrapContainer[pos] != null) {
                    Object[] currentKey = firstSetKey.getCurrentKey();
                    rowContainer = this.unwrapContainer[pos].setInternal(rowContainer, currentKey);
                }
                if (rowContainer == null || firstSetKey.hasAnyNulls(fieldCount, this.nullsafes)) {
                    if (!this.noOuterJoin) {
                        joinNeeded = true;
                        this.storage[pos] = this.dummyObjVectors[pos];
                        continue;
                    }
                    this.storage[pos] = this.emptyList;
                    continue;
                }
                joinNeeded = true;
                this.storage[pos] = rowContainer.copy();
                this.aliasFilterTags[pos] = rowContainer.getAliasFilter();
            }
            if (joinNeeded) {
                List<Object> value = this.getFilteredValue(this.alias, row);
                this.storage[this.alias].addRow(value);
                this.checkAndGenObject();
            }
            this.storage[tag].clearRows();
            for (pos = 0; pos < this.order.length; pos = (int)((byte)(pos + 1))) {
                if (pos == tag) continue;
                this.storage[pos] = null;
            }
        }
        catch (Exception e) {
            String msg = "Unexpected exception: " + e.getMessage();
            LOG.error((Object)msg, (Throwable)e);
            throw new HiveException(msg, e);
        }
    }

    @Override
    public void closeOp(boolean abort) throws HiveException {
        for (MapJoinTableContainer tableContainer : this.mapJoinTables) {
            if (tableContainer == null) continue;
            tableContainer.dumpMetrics();
        }
        if (this.getExecContext() != null && this.getExecContext().getLocalWork() != null && this.getExecContext().getLocalWork().getInputFileChangeSensitive() && this.mapJoinTables != null) {
            for (MapJoinTableContainer tableContainer : this.mapJoinTables) {
                if (tableContainer == null) continue;
                tableContainer.clear();
            }
        }
        super.closeOp(abort);
    }

    @Override
    public String getName() {
        return MapJoinOperator.getOperatorName();
    }

    public static String getOperatorName() {
        return "MAPJOIN";
    }

    @Override
    public OperatorType getType() {
        return OperatorType.MAPJOIN;
    }
}

