/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.metadata;

import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.SemiJoin;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.core.Union;
import org.apache.calcite.rel.metadata.ReflectiveRelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMdUtil;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.util.BuiltInMethod;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.NumberUtil;

public class RelMdRowCount {
    public static final RelMetadataProvider SOURCE = ReflectiveRelMetadataProvider.reflectiveSource(BuiltInMethod.ROW_COUNT.method, new RelMdRowCount());

    public Double getRowCount(Union rel) {
        double nRows = 0.0;
        for (RelNode input : rel.getInputs()) {
            Double partialRowCount = RelMetadataQuery.getRowCount(input);
            if (partialRowCount == null) {
                return null;
            }
            nRows += partialRowCount.doubleValue();
        }
        return nRows;
    }

    public Double getRowCount(Filter rel) {
        return NumberUtil.multiply(RelMetadataQuery.getSelectivity(rel.getInput(), rel.getCondition()), RelMetadataQuery.getRowCount(rel.getInput()));
    }

    public Double getRowCount(Project rel) {
        return RelMetadataQuery.getRowCount(rel.getInput());
    }

    public Double getRowCount(Sort rel) {
        return RelMetadataQuery.getRowCount(rel.getInput());
    }

    public Double getRowCount(SemiJoin rel) {
        RexNode semiJoinSelectivity = RelMdUtil.makeSemiJoinSelectivityRexNode(rel);
        return NumberUtil.multiply(RelMetadataQuery.getSelectivity(rel.getLeft(), semiJoinSelectivity), RelMetadataQuery.getRowCount(rel.getLeft()));
    }

    public Double getRowCount(Aggregate rel) {
        ImmutableBitSet groupKey = ImmutableBitSet.range(rel.getGroupCount());
        Double distinctRowCount = RelMetadataQuery.getDistinctRowCount(rel.getInput(), groupKey, null);
        if (distinctRowCount == null) {
            return RelMetadataQuery.getRowCount(rel.getInput()) / 10.0;
        }
        return distinctRowCount;
    }

    public Double getRowCount(RelNode rel) {
        return rel.getRows();
    }
}

