/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.server;

import com.linkedin.data.template.RecordTemplate;
import com.linkedin.restli.common.HttpStatus;
import com.linkedin.restli.server.RestLiServiceException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class BatchResult<K, V extends RecordTemplate>
implements Map<K, V> {
    private final Map<K, V> _data;
    private final Map<K, HttpStatus> _statuses;
    private final Map<K, RestLiServiceException> _errors;

    public BatchResult(Map<K, V> data, Map<K, RestLiServiceException> errors) {
        this(data, null, errors);
    }

    public BatchResult(Map<K, V> data, Map<K, HttpStatus> statuses, Map<K, RestLiServiceException> errors) {
        this._data = data == null ? new HashMap() : data;
        this._statuses = statuses == null ? new HashMap() : statuses;
        this._errors = errors == null ? new HashMap() : errors;
    }

    @Override
    public int size() {
        return this._data.size();
    }

    @Override
    public boolean isEmpty() {
        return this._data.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this._data.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this._data.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return (V)((RecordTemplate)this._data.get(key));
    }

    @Override
    public V put(K key, V value) {
        return (V)((RecordTemplate)this._data.put(key, value));
    }

    @Override
    public V remove(Object key) {
        return (V)((RecordTemplate)this._data.remove(key));
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this._data.putAll(m);
    }

    @Override
    public void clear() {
        this._data.clear();
    }

    @Override
    public Set<K> keySet() {
        return this._data.keySet();
    }

    @Override
    public Collection<V> values() {
        return this._data.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this._data.entrySet();
    }

    public Map<K, HttpStatus> getStatuses() {
        return Collections.unmodifiableMap(this._statuses);
    }

    public Map<K, RestLiServiceException> getErrors() {
        return Collections.unmodifiableMap(this._errors);
    }
}

