/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.internal.server.filter;

import com.linkedin.data.DataMap;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.transform.filter.request.MaskTree;
import com.linkedin.restli.common.ProtocolVersion;
import com.linkedin.restli.common.ResourceMethod;
import com.linkedin.restli.internal.server.ServerResourceContext;
import com.linkedin.restli.internal.server.filter.FilterRequestContextInternal;
import com.linkedin.restli.internal.server.filter.FilterResourceModelImpl;
import com.linkedin.restli.internal.server.model.ResourceMethodDescriptor;
import com.linkedin.restli.server.PathKeys;
import com.linkedin.restli.server.ProjectionMode;
import com.linkedin.restli.server.RestLiRequestData;
import com.linkedin.restli.server.filter.FilterResourceModel;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class FilterRequestContextInternalImpl
implements FilterRequestContextInternal {
    private RestLiRequestData _requestData;
    private final ServerResourceContext _context;
    private final ResourceMethodDescriptor _resourceMethod;
    private final Map<String, Object> _scratchPad;
    private final FilterResourceModel _resourceModel;
    private final RecordDataSchema _collectionCustomTypeSchema;

    public FilterRequestContextInternalImpl(ServerResourceContext context, ResourceMethodDescriptor resourceMethod) {
        this._context = context;
        this._resourceMethod = resourceMethod;
        this._scratchPad = new HashMap<String, Object>();
        this._resourceModel = new FilterResourceModelImpl(resourceMethod.getResourceModel());
        this._collectionCustomTypeSchema = resourceMethod.getFinderMetadataType() == null ? null : (RecordDataSchema)DataTemplateUtil.getSchema(resourceMethod.getFinderMetadataType());
    }

    @Override
    public String getResourceName() {
        return this.getFilterResourceModel().getResourceName();
    }

    @Override
    public ProjectionMode getProjectionMode() {
        return this._context.getProjectionMode();
    }

    @Override
    public MaskTree getProjectionMask() {
        return this._context.getProjectionMask();
    }

    @Override
    public void setProjectionMask(MaskTree projectionMask) {
        this._context.setProjectionMask(projectionMask);
    }

    @Override
    public PathKeys getPathKeys() {
        return this._context.getPathKeys();
    }

    @Override
    public String getResourceNamespace() {
        return this.getFilterResourceModel().getResourceNamespace();
    }

    @Override
    public ResourceMethod getMethodType() {
        return this._resourceMethod.getMethodType();
    }

    @Override
    public Map<String, String> getRequestHeaders() {
        return this._context.getRequestHeaders();
    }

    @Override
    public DataMap getCustomAnnotations() {
        return this._resourceMethod.getCustomAnnotationData();
    }

    @Override
    public URI getRequestURI() {
        return this._context.getRequestURI();
    }

    @Override
    public ProtocolVersion getRestliProtocolVersion() {
        return this._context.getRestliProtocolVersion();
    }

    @Override
    public DataMap getQueryParameters() {
        return this._context.getParameters();
    }

    @Override
    public RestLiRequestData getRequestData() {
        return this._requestData;
    }

    @Override
    public void setRequestData(RestLiRequestData data) {
        this._requestData = data;
    }

    @Override
    public Map<String, Object> getFilterScratchpad() {
        return this._scratchPad;
    }

    @Override
    public String getFinderName() {
        return this._resourceMethod.getFinderName();
    }

    @Override
    public String getActionName() {
        return this._resourceMethod.getActionName();
    }

    @Override
    public FilterResourceModel getFilterResourceModel() {
        return this._resourceModel;
    }

    @Override
    public RecordDataSchema getCollectionCustomMetadataSchema() {
        return this._collectionCustomTypeSchema;
    }

    @Override
    public RecordDataSchema getActionRequestSchema() {
        return this._resourceMethod.getRequestDataSchema();
    }

    @Override
    public RecordDataSchema getActionResponseSchema() {
        return this._resourceMethod.getActionReturnRecordDataSchema();
    }

    @Override
    public Method getMethod() {
        return this._resourceMethod.getMethod();
    }

    @Override
    public Map<String, Object> getRequestContextLocalAttrs() {
        return Collections.unmodifiableMap(this._context.getRawRequestContext().getLocalAttrs());
    }

    @Override
    public Optional<Object> getCustomContextData(String key) {
        return this._context.getCustomContextData(key);
    }

    @Override
    public void putCustomContextData(String key, Object data) {
        this._context.putCustomContextData(key, data);
    }

    @Override
    public Optional<Object> removeCustomContextData(String key) {
        return this._context.removeCustomContextData(key);
    }
}

