/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.wan.serial;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.DataSerializer;
import org.apache.geode.cache.CacheEvent;
import org.apache.geode.cache.CacheWriterException;
import org.apache.geode.cache.EntryNotFoundException;
import org.apache.geode.cache.TimeoutException;
import org.apache.geode.cache.wan.GatewayEventFilter;
import org.apache.geode.cache.wan.GatewayQueueEvent;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.ConflationKey;
import org.apache.geode.distributed.internal.DirectReplyProcessor;
import org.apache.geode.internal.cache.DistributedCacheOperation;
import org.apache.geode.internal.cache.DistributedRegion;
import org.apache.geode.internal.cache.EntryEventImpl;
import org.apache.geode.internal.cache.EventID;
import org.apache.geode.internal.cache.InternalCacheEvent;
import org.apache.geode.internal.cache.InternalRegion;
import org.apache.geode.internal.cache.wan.serial.ConcurrentSerialGatewaySenderEventProcessor;
import org.apache.geode.internal.cache.wan.serial.SerialGatewaySenderEventProcessor;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.SerializationContext;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class BatchDestroyOperation
extends DistributedCacheOperation {
    private static final Logger logger = LogService.getLogger();

    public BatchDestroyOperation(EntryEventImpl event) {
        super(event);
    }

    @Override
    protected DistributedCacheOperation.CacheOperationMessage createMessage() {
        return new DestroyMessage(this.event);
    }

    @Override
    protected void initMessage(DistributedCacheOperation.CacheOperationMessage msg, DirectReplyProcessor processor) {
        super.initMessage(msg, processor);
        DestroyMessage m = (DestroyMessage)msg;
        EntryEventImpl event = this.getEvent();
        m.key = event.getKey();
        m.eventId = event.getEventId();
    }

    public static class DestroyMessage
    extends DistributedCacheOperation.CacheOperationMessage {
        protected EventID eventId = null;
        protected Object key;
        protected EntryEventImpl event = null;
        private Long tailKey = 0L;

        public DestroyMessage() {
        }

        public DestroyMessage(InternalCacheEvent event) {
            this.event = (EntryEventImpl)event;
        }

        @Override
        protected boolean operateOnRegion(CacheEvent event, ClusterDistributionManager dm) throws EntryNotFoundException {
            EntryEventImpl ev = (EntryEventImpl)event;
            DistributedRegion rgn = (DistributedRegion)ev.getRegion();
            boolean isDebugEnabled = logger.isDebugEnabled();
            try {
                if (isDebugEnabled) {
                    logger.debug("Received batch destroyed message with key {} tail key {} this size of the region is {} they keys are {}", this.key, (Object)this.tailKey, (Object)rgn.size(), (Object)rgn.keys());
                }
                for (long k = ((Long)this.key).longValue(); k <= this.tailKey && this.tailKey != -1L; ++k) {
                    try {
                        for (GatewayEventFilter filter : rgn.getSerialGatewaySender().getGatewayEventFilters()) {
                            GatewayQueueEvent eventForFilter = (GatewayQueueEvent)rgn.get(k);
                            try {
                                if (eventForFilter == null) continue;
                                filter.afterAcknowledgement(eventForFilter);
                            }
                            catch (Exception e) {
                                logger.fatal(String.format("Exception occurred while handling call to %s.afterAcknowledgement for event %s:", filter.toString(), eventForFilter), (Throwable)e);
                            }
                        }
                        rgn.localDestroy(k, "WAN_QUEUE_TOKEN");
                        continue;
                    }
                    catch (EntryNotFoundException e) {
                        if (!isDebugEnabled) continue;
                        logger.debug("For key {} there is no entry in the region.", (Object)k);
                    }
                }
                if (this.tailKey == -1L) {
                    boolean removed;
                    SerialGatewaySenderEventProcessor ep = null;
                    int index = ((Long)this.key).intValue();
                    if (index == -1) {
                        ep = (SerialGatewaySenderEventProcessor)rgn.getSerialGatewaySender().getEventProcessor();
                    } else {
                        ConcurrentSerialGatewaySenderEventProcessor csgep = (ConcurrentSerialGatewaySenderEventProcessor)rgn.getSerialGatewaySender().getEventProcessor();
                        if (csgep != null && csgep.processors != null) {
                            ep = csgep.processors.get(index);
                        }
                    }
                    if (ep != null && (removed = ep.basicHandlePrimaryDestroy(ev.getEventId())) && isDebugEnabled) {
                        logger.debug("Removed a dropped event {} from unprocessedEvents.", (Object)((EntryEventImpl)event));
                    }
                }
                this.appliedOperation = true;
            }
            catch (CacheWriterException e) {
                throw new Error("CacheWriter should not be called", e);
            }
            catch (TimeoutException e) {
                throw new Error("DistributedLock should not be acquired", e);
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected InternalCacheEvent createEvent(DistributedRegion rgn) throws EntryNotFoundException {
            EntryEventImpl ev = this.createEntryEvent(rgn);
            boolean evReturned = false;
            try {
                ev.setEventId(this.eventId);
                ev.setOldValueFromRegion();
                if (this.filterRouting != null) {
                    ev.setLocalFilterInfo(this.filterRouting.getFilterInfo(rgn.getCache().getMyId()));
                }
                ev.setTailKey(this.tailKey);
                evReturned = true;
                EntryEventImpl entryEventImpl = ev;
                return entryEventImpl;
            }
            finally {
                if (!evReturned) {
                    ev.release();
                }
            }
        }

        EntryEventImpl createEntryEvent(DistributedRegion rgn) {
            EntryEventImpl event = EntryEventImpl.create((InternalRegion)rgn, this.getOperation(), this.key, null, this.callbackArg, true, this.getSender());
            this.setOldValueInEvent(event);
            event.setTailKey(this.tailKey);
            return event;
        }

        @Override
        protected void appendFields(StringBuilder buff) {
            super.appendFields(buff);
            buff.append(" lastDestroydKey=").append(this.key).append(" lastDispatchedKey=").append(this.tailKey).append(" id=").append(this.eventId);
        }

        public int getDSFID() {
            return 2148;
        }

        @Override
        public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
            super.fromData(in, context);
            this.eventId = (EventID)DataSerializer.readObject(in);
            this.key = DataSerializer.readObject(in);
            Boolean hasTailKey = DataSerializer.readBoolean(in);
            if (hasTailKey.booleanValue()) {
                this.tailKey = DataSerializer.readLong(in);
            }
        }

        @Override
        public void toData(DataOutput out, SerializationContext context) throws IOException {
            super.toData(out, context);
            DataSerializer.writeObject(this.eventId, out);
            DataSerializer.writeObject(this.key, out);
            DataSerializer.writeBoolean(Boolean.TRUE, out);
            DataSerializer.writeLong(this.event.getTailKey(), out);
        }

        @Override
        public ConflationKey getConflationKey() {
            if (!this.regionAllowsConflation || this.getProcessorId() != 0) {
                return null;
            }
            return new ConflationKey(this.key, this.regionPath, false);
        }
    }
}

