/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.List;
import java.util.Set;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.GfshCommand;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.functions.GetSubscriptionQueueSizeFunction;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.cli.result.model.TabularResultModel;
import org.apache.geode.management.internal.functions.CliFunctionResult;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class CountDurableCQEventsCommand
extends GfshCommand {
    @CliCommand(value={"show subscription-queue-size"}, help="Shows the number of events in the subscription queue.  If a cq name is provided, counts the number of events in the subscription queue for the specified cq.")
    @CliMetaData
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.READ)
    public ResultModel countDurableCqEvents(@CliOption(key={"durable-client-id"}, mandatory=true, help="The id used to identify the durable client.") String durableClientId, @CliOption(key={"durable-cq-name"}, help="The name that identifies the cq.") String cqName, @CliOption(key={"member", "members"}, help="Name/Id of the member for which the subscription events are to be counted.", optionContext="geode.converter.member.idOrName:disable-string-converter") String[] memberNameOrId, @CliOption(key={"group", "groups"}, help="Group of members for which the subscription queue events are to be counted.", optionContext="geode.converter.member.groups:disable-string-converter") String[] group) {
        Set<DistributedMember> targetMembers = this.findMembers(group, memberNameOrId);
        if (targetMembers.isEmpty()) {
            return ResultModel.createError("No Members Found");
        }
        String[] params = new String[]{durableClientId, cqName};
        ResultCollector<?, ?> rc = this.executeFunction((Function<?>)new GetSubscriptionQueueSizeFunction(), (Object)params, targetMembers);
        List funcResults = (List)rc.getResult();
        ResultModel result = new ResultModel();
        TabularResultModel table = result.addTable("subscription-queue-size");
        for (CliFunctionResult oneResult : funcResults) {
            table.accumulate("Member", oneResult.getMemberIdOrName());
            table.accumulate("Status", oneResult.getStatus());
            table.accumulate("Queue Size", oneResult.getStatusMessage());
            if (oneResult.isSuccessful()) continue;
            result.setStatus(Result.Status.ERROR);
        }
        return result;
    }
}

