/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.distributed.internal.PoolStatHelper;
import org.apache.geode.distributed.internal.PooledExecutorWithDMStats;
import org.apache.geode.internal.monitoring.ThreadsMonitoring;

public class SerialQueuedExecutorWithDMStats
extends ThreadPoolExecutor {
    private final PoolStatHelper poolStatHelper;
    private final ThreadsMonitoring threadsMonitoring;

    public SerialQueuedExecutorWithDMStats(BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, PoolStatHelper poolStatHelper, ThreadsMonitoring threadsMonitoring) {
        super(1, 1, 60L, TimeUnit.SECONDS, workQueue, threadFactory, new PooledExecutorWithDMStats.BlockHandler());
        this.poolStatHelper = poolStatHelper;
        this.threadsMonitoring = threadsMonitoring;
    }

    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        if (this.poolStatHelper != null) {
            this.poolStatHelper.startJob();
        }
        if (this.threadsMonitoring != null) {
            this.threadsMonitoring.startMonitor(ThreadsMonitoring.Mode.SerialQueuedExecutor);
        }
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        if (this.poolStatHelper != null) {
            this.poolStatHelper.endJob();
        }
        if (this.threadsMonitoring != null) {
            this.threadsMonitoring.endMonitor();
        }
    }

    @VisibleForTesting
    public PoolStatHelper getPoolStatHelper() {
        return this.poolStatHelper;
    }
}

