/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.serialization;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class VersioningIO {
    private VersioningIO() {
    }

    public static short readOrdinal(DataInput in) throws IOException {
        byte ordinal = in.readByte();
        if (ordinal != -1) {
            return ordinal;
        }
        return in.readShort();
    }

    public static void writeOrdinal(DataOutput out, short ordinal, boolean compressed) throws IOException {
        if (compressed && ordinal <= 127) {
            out.writeByte(ordinal);
        } else {
            out.writeByte(-1);
            out.writeShort(ordinal);
        }
    }

    public static short readOrdinalFromInputStream(InputStream is) throws IOException {
        int ordinal = is.read();
        if (ordinal != -1) {
            int ordinalPart2;
            if (ordinal != 255) {
                return (short)ordinal;
            }
            int ordinalPart1 = is.read();
            if ((ordinalPart1 | (ordinalPart2 = is.read())) >= 0) {
                return (short)(ordinalPart1 << 8 | ordinalPart2);
            }
            return -1;
        }
        return -1;
    }

    public static void writeOrdinal(ByteBuffer buffer, short ordinal, boolean compressed) {
        if (compressed && ordinal <= 127) {
            buffer.put((byte)ordinal);
        } else {
            buffer.put((byte)-1);
            buffer.putShort(ordinal);
        }
    }
}

