/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query.internal;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.geode.cache.query.FunctionDomainException;
import org.apache.geode.cache.query.NameResolutionException;
import org.apache.geode.cache.query.QueryInvocationTargetException;
import org.apache.geode.cache.query.QueryService;
import org.apache.geode.cache.query.TypeMismatchException;
import org.apache.geode.cache.query.internal.AbstractCompiledValue;
import org.apache.geode.cache.query.internal.CompiledValue;
import org.apache.geode.cache.query.internal.ExecutionContext;

public class CompiledNegation
extends AbstractCompiledValue {
    private final CompiledValue _value;

    public CompiledNegation(CompiledValue value) {
        this._value = value;
    }

    @Override
    public List getChildren() {
        return Collections.singletonList(this._value);
    }

    @Override
    public int getType() {
        return 103;
    }

    @Override
    public Object evaluate(ExecutionContext context) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        return this.negateObject(this._value.evaluate(context));
    }

    @Override
    public Set computeDependencies(ExecutionContext context) throws TypeMismatchException, NameResolutionException {
        return context.addDependencies(this, this._value.computeDependencies(context));
    }

    private Object negateObject(Object obj) throws TypeMismatchException {
        if (obj instanceof Boolean) {
            return (Boolean)obj == false;
        }
        if (obj == null || obj == QueryService.UNDEFINED) {
            return QueryService.UNDEFINED;
        }
        throw new TypeMismatchException(String.format("%s cannot be negated", obj.getClass()));
    }

    @Override
    public void generateCanonicalizedExpression(StringBuilder clauseBuffer, ExecutionContext context) throws TypeMismatchException, NameResolutionException {
        clauseBuffer.insert(0, ')');
        this._value.generateCanonicalizedExpression(clauseBuffer, context);
        clauseBuffer.insert(0, "NOT(");
    }
}

