/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.admin.jmx.internal;

import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.modelmbean.ModelMBean;
import javax.naming.OperationNotSupportedException;
import org.apache.commons.modeler.ManagedBean;
import org.apache.geode.CancelException;
import org.apache.geode.SystemFailure;
import org.apache.geode.admin.AdminException;
import org.apache.geode.admin.OperationCancelledException;
import org.apache.geode.admin.Statistic;
import org.apache.geode.admin.internal.StatisticResourceImpl;
import org.apache.geode.admin.jmx.internal.AdminDistributedSystemJmxImpl;
import org.apache.geode.admin.jmx.internal.DynamicManagedBean;
import org.apache.geode.admin.jmx.internal.MBeanUtils;
import org.apache.geode.admin.jmx.internal.ManagedResource;
import org.apache.geode.admin.jmx.internal.ManagedResourceType;
import org.apache.geode.admin.jmx.internal.RefreshNotificationType;
import org.apache.geode.admin.jmx.internal.StatisticAttributeInfo;
import org.apache.geode.admin.jmx.internal.SystemMemberJmx;
import org.apache.geode.internal.admin.StatResource;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

@Deprecated
public class StatisticResourceJmxImpl
extends StatisticResourceImpl
implements NotificationListener,
ManagedResource {
    private static final Logger logger = LogService.getLogger();
    private int refreshInterval = 0;
    private ObjectName objectName;
    private boolean timerInited = false;
    private String mbeanName;
    private ModelMBean modelMBean;

    public StatisticResourceJmxImpl(StatResource statResource, SystemMemberJmx member) throws AdminException {
        super(statResource, member);
        this.initializeMBean();
    }

    private void initializeMBean() throws AdminException {
        this.mbeanName = "GemFire.Statistic:source=" + MBeanUtils.makeCompliantMBeanNameProperty(this.member.getId()) + ",type=" + MBeanUtils.makeCompliantMBeanNameProperty(this.getType()) + ",name=" + MBeanUtils.makeCompliantMBeanNameProperty(this.getName()) + ",uid=" + this.getUniqueId();
        this.objectName = MBeanUtils.createMBean(this, this.addDynamicAttributes(MBeanUtils.lookupManagedBean(this)));
        AdminDistributedSystemJmxImpl sysJmx = (AdminDistributedSystemJmxImpl)this.member.getDistributedSystem();
        if (sysJmx.getRefreshInterval() > 0) {
            this.refreshInterval = sysJmx.getRefreshInterval();
        }
    }

    public int getRefreshInterval() {
        return this.refreshInterval;
    }

    private void _setRefreshInterval(int refreshInterval) {
        boolean isRegistered = MBeanUtils.isRefreshNotificationRegistered(this, RefreshNotificationType.STATISTIC_RESOURCE_STATISTICS);
        if (isRegistered && this.getRefreshInterval() == refreshInterval) {
            return;
        }
        try {
            MBeanUtils.registerRefreshNotification(this, this.getMBeanName(), RefreshNotificationType.STATISTIC_RESOURCE_STATISTICS, refreshInterval);
            this.refreshInterval = refreshInterval;
            this.timerInited = true;
        }
        catch (RuntimeException e) {
            logger.warn(e.getMessage(), (Throwable)e);
            this.refreshInterval = 0;
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Error e) {
            SystemFailure.checkFailure();
            logger.error(e.getMessage(), (Throwable)e);
            this.refreshInterval = 0;
        }
    }

    @Deprecated
    public void setRefreshInterval(int refreshInterval) throws OperationNotSupportedException {
        throw new OperationNotSupportedException("RefreshInterval can not be set directly. Use DistributedSystemConfig.refreshInterval.");
    }

    @Override
    public void handleNotification(Notification notification, Object hb) {
        AdminDistributedSystemJmxImpl adminDSJmx = (AdminDistributedSystemJmxImpl)this.member.getDistributedSystem();
        String typeStatResourceStats = RefreshNotificationType.STATISTIC_RESOURCE_STATISTICS.getType();
        if (typeStatResourceStats.equals(notification.getType()) && this.getMBeanName().equals(notification.getUserData()) && !adminDSJmx.isRmiClientCountZero()) {
            try {
                this.refresh();
            }
            catch (AdminException e) {
                logger.warn(e.getMessage(), (Throwable)e);
            }
            catch (OperationCancelledException e) {
                logger.warn(e.getMessage(), (Throwable)e);
                this._setRefreshInterval(0);
            }
            catch (CancelException e) {
            }
            catch (RuntimeException e) {
                logger.debug(e.getMessage(), (Throwable)e);
                this._setRefreshInterval(0);
            }
            catch (VirtualMachineError err) {
                SystemFailure.initiateFailure(err);
                throw err;
            }
            catch (Error e) {
                SystemFailure.checkFailure();
                logger.error(e.getMessage(), (Throwable)e);
                this.refreshInterval = 0;
            }
        }
    }

    ManagedBean addDynamicAttributes(ManagedBean managed) throws AdminException {
        if (managed == null) {
            throw new IllegalArgumentException("ManagedBean is null");
        }
        this.refresh();
        DynamicManagedBean newManagedBean = new DynamicManagedBean(managed);
        for (Statistic statistic : this.statistics) {
            StatisticAttributeInfo attrInfo = new StatisticAttributeInfo();
            attrInfo.setName(statistic.getName());
            attrInfo.setDisplayName(statistic.getName());
            attrInfo.setDescription(statistic.getDescription());
            attrInfo.setType("java.lang.Number");
            attrInfo.setIs(false);
            attrInfo.setReadable(true);
            attrInfo.setWriteable(false);
            attrInfo.setStat(statistic);
            newManagedBean.addAttribute(attrInfo);
        }
        return newManagedBean;
    }

    @Override
    public Statistic[] getStatistics() {
        if (!this.timerInited && this.refreshInterval > 0) {
            this._setRefreshInterval(this.refreshInterval);
        }
        if (this.statistics == null) {
            try {
                this.refresh();
            }
            catch (AdminException e) {
                this.statistics = new Statistic[0];
            }
        }
        return this.statistics;
    }

    @Override
    public String getMBeanName() {
        return this.mbeanName;
    }

    @Override
    public ModelMBean getModelMBean() {
        return this.modelMBean;
    }

    @Override
    public void setModelMBean(ModelMBean modelMBean) {
        this.modelMBean = modelMBean;
    }

    @Override
    public ObjectName getObjectName() {
        return this.objectName;
    }

    @Override
    public ManagedResourceType getManagedResourceType() {
        return ManagedResourceType.STATISTIC_RESOURCE;
    }

    @Override
    public void cleanupResource() {
        this.modelMBean = null;
        this.member = null;
        this.statistics = null;
        this.statResource = null;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof StatisticResourceJmxImpl)) {
            return false;
        }
        StatisticResourceJmxImpl other = (StatisticResourceJmxImpl)obj;
        return this.getMBeanName().equals(other.getMBeanName());
    }

    public int hashCode() {
        return this.getMBeanName().hashCode();
    }
}

