/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.key;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.cache.execute.FunctionService;
import org.apache.geode.cache.partition.PartitionRegionHelper;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.execute.InternalFunction;
import org.apache.geode.internal.cache.execute.RegionFunctionContextImpl;
import org.apache.geode.redis.internal.data.CommandHelper;
import org.apache.geode.redis.internal.data.RedisData;
import org.apache.geode.redis.internal.data.RedisKey;
import org.apache.geode.redis.internal.data.RedisKeyCommandsFunctionExecutor;
import org.apache.geode.redis.internal.executor.SingleResultCollector;
import org.apache.geode.redis.internal.executor.StripedExecutor;
import org.apache.geode.redis.internal.statistics.RedisStats;

public class RenameFunction
implements InternalFunction {
    public static final String ID = "REDIS_RENAME_FUNCTION";
    private static final long serialVersionUID = 7047473969356686453L;
    private final transient PartitionedRegion partitionedRegion;
    private final transient CommandHelper commandHelper;
    private final transient RedisKeyCommandsFunctionExecutor keyCommands;

    public static void register(Region<RedisKey, RedisData> dataRegion, StripedExecutor stripedExecutor, RedisStats redisStats) {
        FunctionService.registerFunction((Function)new RenameFunction(dataRegion, stripedExecutor, redisStats));
    }

    public RenameFunction(Region<RedisKey, RedisData> dataRegion, StripedExecutor stripedExecutor, RedisStats redisStats) {
        this.partitionedRegion = (PartitionedRegion)dataRegion;
        this.commandHelper = new CommandHelper(dataRegion, redisStats, stripedExecutor);
        this.keyCommands = new RedisKeyCommandsFunctionExecutor(this.commandHelper);
    }

    public void execute(FunctionContext context) {
        RenameContext renameContext = new RenameContext(context);
        if (renameContext.getKeysFixedOnPrimary().size() < 2) {
            Runnable computation = () -> {
                boolean result = this.fixKeysOnPrimary(renameContext);
                context.getResultSender().lastResult((Object)result);
            };
            this.partitionedRegion.computeWithPrimaryLocked((Object)renameContext.getKeyToLock(), computation);
        } else {
            Boolean result = this.acquireLockIfNeeded(renameContext);
            context.getResultSender().lastResult((Object)result);
        }
    }

    private boolean fixKeysOnPrimary(RenameContext context) {
        context.getKeysFixedOnPrimary().add(context.getKeyToLock());
        context.getKeysToOperateOn().remove(context.getKeyToLock());
        if (!context.getKeysToOperateOn().isEmpty()) {
            return this.getLockForNextKey(context);
        }
        ArrayList keysToOperateOn = new ArrayList(context.getKeysFixedOnPrimary());
        context.getKeysToOperateOn().addAll(keysToOperateOn);
        context.getKeysToOperateOn().sort((o1, o2) -> this.compare(o1, o2, context));
        return this.getLockForNextKey(context);
    }

    private StripedExecutor getStripedExecutor() {
        return this.commandHelper.getStripedExecutor();
    }

    private int compare(Object object1, Object object2, RenameContext context) {
        int result = this.getStripedExecutor().compareStripes(object1, object2);
        if (result == 0) {
            DistributedMember distributedMember1 = PartitionRegionHelper.getPrimaryMemberForKey((Region)context.getDataRegion(), (Object)object1);
            DistributedMember distributedMember2 = PartitionRegionHelper.getPrimaryMemberForKey((Region)context.getDataRegion(), (Object)object2);
            result = distributedMember1.compareTo((Object)distributedMember2);
        }
        return result;
    }

    private boolean acquireLockIfNeeded(RenameContext context) {
        if (this.isLockNeededForCurrentKey(context)) {
            return this.getStripedExecutor().execute(context.getKeyToLock(), () -> this.renameOrGetLockForNextKey(context));
        }
        return this.renameOrGetLockForNextKey(context);
    }

    private boolean isLockNeededForCurrentKey(RenameContext context) {
        return context.getLockedKeys().stream().noneMatch(lockedKey -> this.alreadyHaveLockForCurrentKey((RedisKey)lockedKey, context));
    }

    private boolean renameOrGetLockForNextKey(RenameContext context) {
        this.markCurrentKeyAsLocked(context);
        if (this.allKeysHaveLocks(context)) {
            return this.rename(context);
        }
        return this.getLockForNextKey(context);
    }

    private boolean allKeysHaveLocks(RenameContext context) {
        return context.getKeysToOperateOn().isEmpty();
    }

    private boolean rename(RenameContext context) {
        return this.keyCommands.rename(context.getOldKey(), context.getNewKey());
    }

    private void markCurrentKeyAsLocked(RenameContext context) {
        RedisKey keyToMarkAsLocked = context.getKeyToLock();
        context.getLockedKeys().add(keyToMarkAsLocked);
        context.getKeysToOperateOn().remove(keyToMarkAsLocked);
    }

    private boolean alreadyHaveLockForCurrentKey(RedisKey lockedKey, RenameContext context) {
        boolean stripesAreTheSame;
        boolean bl = stripesAreTheSame = this.getStripedExecutor().compareStripes(lockedKey, context.getKeyToLock()) == 0;
        if (!stripesAreTheSame) {
            return false;
        }
        Region region = context.getDataRegion();
        DistributedMember primaryMemberForCurrentKey = PartitionRegionHelper.getPrimaryMemberForKey((Region)region, (Object)context.getKeyToLock());
        DistributedMember primaryMemberForLockedKey = PartitionRegionHelper.getPrimaryMemberForKey((Region)region, (Object)lockedKey);
        return primaryMemberForCurrentKey.equals(primaryMemberForLockedKey);
    }

    private boolean getLockForNextKey(RenameContext context) {
        SingleResultCollector rc = new SingleResultCollector();
        FunctionService.onRegion((Region)context.getDataRegion()).withFilter(Collections.singleton(context.getKeysToOperateOn().get(0))).setArguments((Object)new Object[]{context.getOldKey(), context.getNewKey(), context.getKeysToOperateOn(), context.getKeysFixedOnPrimary(), context.getLockedKeys()}).withCollector(rc).execute(ID).getResult();
        return (Boolean)rc.getResult();
    }

    public String getId() {
        return ID;
    }

    public boolean optimizeForWrite() {
        return true;
    }

    public boolean isHA() {
        return false;
    }

    private static class RenameContext {
        private final RegionFunctionContextImpl context;

        public RenameContext(FunctionContext context) {
            this.context = (RegionFunctionContextImpl)context;
        }

        private RedisKey getOldKey() {
            return (RedisKey)((Object[])this.context.getArguments())[0];
        }

        private RedisKey getNewKey() {
            return (RedisKey)((Object[])this.context.getArguments())[1];
        }

        private List<RedisKey> getKeysToOperateOn() {
            return (List)((Object[])this.context.getArguments())[2];
        }

        private List<RedisKey> getKeysFixedOnPrimary() {
            return (List)((Object[])this.context.getArguments())[3];
        }

        private List<RedisKey> getLockedKeys() {
            return (List)((Object[])this.context.getArguments())[4];
        }

        private RedisKey getKeyToLock() {
            return (RedisKey)this.context.getFilter().iterator().next();
        }

        private Region getDataRegion() {
            return this.context.getDataSet();
        }
    }
}

