/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.cache.Region;
import org.apache.geode.redis.internal.data.ByteArrayWrapper;
import org.apache.geode.redis.internal.data.CommandHelper;
import org.apache.geode.redis.internal.data.RedisData;
import org.apache.geode.redis.internal.data.RedisKey;
import org.apache.geode.redis.internal.data.RedisSet;
import org.apache.geode.redis.internal.executor.set.RedisSetCommandsFunctionInvoker;

class NullRedisSet
extends RedisSet {
    NullRedisSet() {
        super(new HashSet<ByteArrayWrapper>());
    }

    @Override
    public boolean isNull() {
        return true;
    }

    @Override
    Collection<ByteArrayWrapper> spop(Region<RedisKey, RedisData> region, RedisKey key, int popCount) {
        return Collections.emptyList();
    }

    @Override
    Collection<ByteArrayWrapper> srandmember(int count) {
        return Collections.emptyList();
    }

    @Override
    public boolean sismember(ByteArrayWrapper member) {
        return false;
    }

    @Override
    public int scard() {
        return 0;
    }

    @Override
    long sadd(ArrayList<ByteArrayWrapper> membersToAdd, Region<RedisKey, RedisData> region, RedisKey key) {
        region.create((Object)key, (Object)new RedisSet(membersToAdd));
        return membersToAdd.size();
    }

    @Override
    long srem(ArrayList<ByteArrayWrapper> membersToRemove, Region<RedisKey, RedisData> region, RedisKey key) {
        return 0L;
    }

    @Override
    @VisibleForTesting
    Set<ByteArrayWrapper> smembers() {
        return new HashSet<ByteArrayWrapper>();
    }

    public int sunionstore(CommandHelper helper, RedisKey destination, ArrayList<RedisKey> setKeys) {
        return this.doSetOp(SetOp.UNION, helper, destination, setKeys);
    }

    public int sinterstore(CommandHelper helper, RedisKey destination, ArrayList<RedisKey> setKeys) {
        return this.doSetOp(SetOp.INTERSECTION, helper, destination, setKeys);
    }

    public int sdiffstore(CommandHelper helper, RedisKey destination, ArrayList<RedisKey> setKeys) {
        return this.doSetOp(SetOp.DIFF, helper, destination, setKeys);
    }

    private int doSetOp(SetOp setOp, CommandHelper helper, RedisKey destination, ArrayList<RedisKey> setKeys) {
        ArrayList<Set<ByteArrayWrapper>> nonDestinationSets = this.fetchSets(helper.getRegion(), setKeys, destination);
        return helper.getStripedExecutor().execute(destination, () -> this.doSetOpWhileLocked(setOp, helper, destination, nonDestinationSets));
    }

    private int doSetOpWhileLocked(SetOp setOp, CommandHelper helper, RedisKey destination, ArrayList<Set<ByteArrayWrapper>> nonDestinationSets) {
        Set<ByteArrayWrapper> result = this.computeSetOp(setOp, nonDestinationSets, helper, destination);
        if (result.isEmpty()) {
            helper.getRegion().remove((Object)destination);
            return 0;
        }
        helper.getRegion().put((Object)destination, (Object)new RedisSet(result));
        return result.size();
    }

    private Set<ByteArrayWrapper> computeSetOp(SetOp setOp, ArrayList<Set<ByteArrayWrapper>> nonDestinationSets, CommandHelper helper, RedisKey destination) {
        Set<ByteArrayWrapper> result = null;
        if (nonDestinationSets.isEmpty()) {
            return Collections.emptySet();
        }
        for (Set<ByteArrayWrapper> set : nonDestinationSets) {
            if (set == null) {
                set = helper.getRedisSet(destination, false).smembers();
            }
            if (result == null) {
                result = set;
                continue;
            }
            switch (setOp) {
                case UNION: {
                    result.addAll(set);
                    break;
                }
                case INTERSECTION: {
                    result.retainAll(set);
                    break;
                }
                case DIFF: {
                    result.removeAll(set);
                }
            }
        }
        return result;
    }

    private ArrayList<Set<ByteArrayWrapper>> fetchSets(Region<RedisKey, RedisData> region, ArrayList<RedisKey> setKeys, RedisKey destination) {
        ArrayList<Set<ByteArrayWrapper>> result = new ArrayList<Set<ByteArrayWrapper>>(setKeys.size());
        RedisSetCommandsFunctionInvoker redisSetCommands = new RedisSetCommandsFunctionInvoker(region);
        for (RedisKey key : setKeys) {
            if (key.equals(destination)) {
                result.add(null);
                continue;
            }
            result.add(redisSetCommands.internalsmembers(key));
        }
        return result;
    }

    private static enum SetOp {
        UNION,
        INTERSECTION,
        DIFF;

    }
}

