/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.sequencelog.model;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.geode.internal.sequencelog.model.Edge;
import org.apache.geode.internal.sequencelog.model.GraphID;
import org.apache.geode.internal.sequencelog.model.Vertex;

public class Graph {
    private GraphID id;
    private Set<Edge> edges = new HashSet<Edge>();
    private Map<String, SortedMap<Long, Vertex>> indexedVertices = new HashMap<String, SortedMap<Long, Vertex>>();

    public Graph(GraphID id) {
        this.id = id;
    }

    public void addEdge(long timestamp, String edgeName, String state, String source, String dest, boolean isFromPattern) {
        Long previousKey;
        Vertex previousVertex;
        SortedMap<Long, Vertex> headMap;
        Vertex destVertex = new Vertex(this, dest, state, timestamp);
        SortedMap<Long, Vertex> map = this.indexedVertices.get(dest);
        if (map == null) {
            map = new TreeMap<Long, Vertex>();
            this.indexedVertices.put(dest, map);
        }
        if (isFromPattern && ((headMap = map.headMap(timestamp)) != null && !headMap.isEmpty() ? (previousVertex = (Vertex)headMap.get(previousKey = headMap.lastKey())).getState().equals(state) : state.equals("destroyed"))) {
            return;
        }
        map.put(timestamp, destVertex);
        this.edges.add(new Edge(this, timestamp, edgeName, source, destVertex));
    }

    public Collection<Edge> getEdges() {
        return this.edges;
    }

    Map<String, SortedMap<Long, Vertex>> getIndexedVertices() {
        return this.indexedVertices;
    }
}

