/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.jndi;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;
import javax.sql.DataSource;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.apache.geode.LogWriter;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.annotations.internal.MakeNotStatic;
import org.apache.geode.annotations.internal.MutableForTesting;
import org.apache.geode.distributed.DistributedSystem;
import org.apache.geode.internal.ClassPathLoader;
import org.apache.geode.internal.datasource.ClientConnectionFactoryWrapper;
import org.apache.geode.internal.datasource.ConfigProperty;
import org.apache.geode.internal.datasource.DataSourceCreateException;
import org.apache.geode.internal.datasource.DataSourceFactory;
import org.apache.geode.internal.datasource.GemFireTransactionDataSource;
import org.apache.geode.internal.jta.TransactionManagerImpl;
import org.apache.geode.internal.jta.TransactionUtils;
import org.apache.geode.internal.jta.UserTransactionImpl;
import org.apache.geode.internal.util.DriverJarUtil;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class JNDIInvoker {
    private static final Logger logger = LogService.getLogger();
    @MakeNotStatic
    private static Context ctx;
    @MakeNotStatic
    private static TransactionManager transactionManager;
    private static final String[][] knownJNDIManagers;
    private static final String WS_FACTORY_CLASS_5_1 = "com.ibm.ws.Transaction.TransactionManagerFactory";
    private static final String WS_FACTORY_CLASS_5_0 = "com.ibm.ejs.jts.jta.TransactionManagerFactory";
    private static final String WS_FACTORY_CLASS_4 = "com.ibm.ejs.jts.jta.JTSXA";
    @MakeNotStatic
    private static final ConcurrentMap<String, Object> dataSourceMap;
    @MutableForTesting
    private static boolean IGNORE_JTA;
    @Immutable
    private static final DataSourceFactory dataSourceFactory;

    public static void mapTransactions(DistributedSystem distSystem) {
        block19: {
            try {
                TransactionUtils.setLogWriter(distSystem.getLogWriter());
                JNDIInvoker.cleanup();
                if (IGNORE_JTA) {
                    return;
                }
                ctx = new InitialContext();
                JNDIInvoker.doTransactionLookup();
            }
            catch (NamingException ne) {
                LogWriter writer = TransactionUtils.getLogWriter();
                if (ne instanceof NoInitialContextException) {
                    String exception = "JNDIInvoker::mapTransactions:: No application server context found, Starting GemFire JNDI Context Context ";
                    if (writer.finerEnabled()) {
                        writer.finer(exception);
                    }
                    try {
                        JNDIInvoker.initializeGemFireContext();
                        transactionManager = TransactionManagerImpl.getTransactionManager();
                        ctx.rebind("java:/TransactionManager", (Object)transactionManager);
                        if (writer.fineEnabled()) {
                            writer.fine("JNDIInvoker::mapTransactions::Bound TransactionManager to Context GemFire JNDI Tree");
                        }
                        UserTransactionImpl utx = new UserTransactionImpl();
                        ctx.rebind("java:/UserTransaction", (Object)utx);
                        if (writer.fineEnabled()) {
                            writer.fine("JNDIInvoker::mapTransactions::Bound Transaction to Context GemFire JNDI Tree");
                        }
                    }
                    catch (NamingException ne1) {
                        if (writer.infoEnabled()) {
                            writer.info("JNDIInvoker::mapTransactions::NamingException while binding TransactionManager/UserTransaction to GemFire JNDI Tree");
                        }
                        break block19;
                    }
                    catch (SystemException se1) {
                        if (writer.infoEnabled()) {
                            writer.info("JNDIInvoker::mapTransactions::SystemException while binding UserTransaction to GemFire JNDI Tree");
                        }
                        break block19;
                    }
                }
                if (!(ne instanceof NameNotFoundException)) break block19;
                String exception = "JNDIInvoker::mapTransactions:: No TransactionManager associated to Application server context, trying to bind GemFire TransactionManager";
                if (writer.finerEnabled()) {
                    writer.finer(exception);
                }
                try {
                    transactionManager = TransactionManagerImpl.getTransactionManager();
                    ctx.rebind("java:/TransactionManager", (Object)transactionManager);
                    if (writer.fineEnabled()) {
                        writer.fine("JNDIInvoker::mapTransactions::Bound TransactionManager to Application Server Context");
                    }
                    UserTransactionImpl utx = new UserTransactionImpl();
                    ctx.rebind("java:/UserTransaction", (Object)utx);
                    if (writer.fineEnabled()) {
                        writer.fine("JNDIInvoker::mapTransactions::Bound UserTransaction to Application Server Context");
                    }
                }
                catch (NamingException ne1) {
                    if (writer.infoEnabled()) {
                        writer.info("JNDIInvoker::mapTransactions::NamingException while binding TransactionManager/UserTransaction to Application Server JNDI Tree");
                    }
                }
                catch (SystemException se1) {
                    if (!writer.infoEnabled()) break block19;
                    writer.info("JNDIInvoker::mapTransactions::SystemException while binding TransactionManager/UserTransaction to Application Server JNDI Tree");
                }
            }
        }
    }

    private static void cleanup() {
        if (transactionManager instanceof TransactionManagerImpl) {
            TransactionManagerImpl.refresh();
            transactionManager = null;
            try {
                if (ctx != null) {
                    ctx.unbind("java:/TransactionManager");
                }
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
        dataSourceMap.values().stream().forEach(JNDIInvoker::closeDataSource);
        dataSourceMap.clear();
        IGNORE_JTA = Boolean.getBoolean("gemfire.ignoreJTA");
    }

    private static void closeDataSource(Object dataSource) {
        block3: {
            if (dataSource instanceof AutoCloseable) {
                try {
                    ((AutoCloseable)dataSource).close();
                }
                catch (Exception e) {
                    if (!logger.isDebugEnabled()) break block3;
                    logger.debug("Exception closing DataSource", (Throwable)e);
                }
            }
        }
    }

    private static void doTransactionLookup() throws NamingException {
        Class<?> clazz;
        Object jndiObject = null;
        LogWriter writer = TransactionUtils.getLogWriter();
        for (int i = 0; i < knownJNDIManagers.length; ++i) {
            String exception;
            block19: {
                try {
                    jndiObject = ctx.lookup(knownJNDIManagers[i][0]);
                }
                catch (NamingException e) {
                    String exception2 = "JNDIInvoker::doTransactionLookup::Couldn't lookup [" + knownJNDIManagers[i][0] + " (" + knownJNDIManagers[i][1] + ")]";
                    if (!writer.finerEnabled()) break block19;
                    writer.finer(exception2);
                }
            }
            if (jndiObject instanceof TransactionManager) {
                transactionManager = (TransactionManager)jndiObject;
                exception = "JNDIInvoker::doTransactionLookup::Found TransactionManager for " + knownJNDIManagers[i][1];
                if (writer.fineEnabled()) {
                    writer.fine(exception);
                }
                return;
            }
            exception = "JNDIInvoker::doTransactionLookup::Found TransactionManager of class " + (jndiObject == null ? "null" : jndiObject.getClass()) + " but is not of type javax.transaction.TransactionManager";
            if (!writer.fineEnabled()) continue;
            writer.fine(exception);
        }
        try {
            if (writer.finerEnabled()) {
                writer.finer("JNDIInvoker::doTransactionLookup::Trying WebSphere 5.1: com.ibm.ws.Transaction.TransactionManagerFactory");
            }
            clazz = ClassPathLoader.getLatest().forName(WS_FACTORY_CLASS_5_1);
            if (writer.fineEnabled()) {
                writer.fine("JNDIInvoker::doTransactionLookup::Found WebSphere 5.1: com.ibm.ws.Transaction.TransactionManagerFactory");
            }
        }
        catch (ClassNotFoundException ex) {
            try {
                if (writer.finerEnabled()) {
                    writer.finer("JNDIInvoker::doTransactionLookup::Trying WebSphere 5.0: com.ibm.ejs.jts.jta.TransactionManagerFactory");
                }
                clazz = ClassPathLoader.getLatest().forName(WS_FACTORY_CLASS_5_0);
                if (writer.fineEnabled()) {
                    writer.fine("JNDIInvoker::doTransactionLookup::Found WebSphere 5.0: com.ibm.ejs.jts.jta.TransactionManagerFactory");
                }
            }
            catch (ClassNotFoundException ex2) {
                try {
                    clazz = ClassPathLoader.getLatest().forName(WS_FACTORY_CLASS_4);
                    String exception = "JNDIInvoker::doTransactionLookup::Found WebSphere 4: com.ibm.ejs.jts.jta.JTSXA";
                    if (writer.fineEnabled()) {
                        writer.fine(exception, ex);
                    }
                }
                catch (ClassNotFoundException ex3) {
                    if (writer.finerEnabled()) {
                        writer.finer("JNDIInvoker::doTransactionLookup::Couldn't find any WebSphere TransactionManager factory class, neither for WebSphere version 5.1 nor 5.0 nor 4");
                    }
                    throw new NoInitialContextException();
                }
            }
        }
        try {
            Method method = clazz.getMethod("getTransactionManager", null);
            transactionManager = (TransactionManager)method.invoke(null, (Object[])null);
        }
        catch (Exception ex) {
            writer.warning(String.format("JNDIInvoker::doTransactionLookup::Found WebSphere TransactionManager factory class [%s], but could not invoke its static 'getTransactionManager' method", clazz.getName()), ex);
            throw new NameNotFoundException(String.format("JNDIInvoker::doTransactionLookup::Found WebSphere TransactionManager factory class [%s], but could not invoke its static 'getTransactionManager' method", clazz.getName()));
        }
    }

    private static void initializeGemFireContext() throws NamingException {
        Hashtable<String, String> table = new Hashtable<String, String>();
        table.put("java.naming.factory.initial", "org.apache.geode.internal.jndi.InitialContextFactoryImpl");
        ctx = new InitialContext(table);
    }

    public static void mapDatasource(Map map, List<ConfigProperty> props) throws NamingException, DataSourceCreateException, ClassNotFoundException, SQLException, InstantiationException, IllegalAccessException {
        JNDIInvoker.mapDatasource(map, props, dataSourceFactory, ctx);
    }

    static void mapDatasource(Map map, List<ConfigProperty> props, DataSourceFactory dataSourceFactory, Context context) throws NamingException, DataSourceCreateException, ClassNotFoundException, SQLException, InstantiationException, IllegalAccessException {
        String driverClassName = null;
        if (map != null) {
            driverClassName = (String)map.get("jdbc-driver-class");
            DriverJarUtil util = new DriverJarUtil();
            if (driverClassName != null) {
                util.registerDriver(driverClassName);
            }
        }
        String value = (String)map.get("type");
        String jndiName = "";
        jndiName = (String)map.get("jndi-name");
        if (value.equals("PooledDataSource")) {
            JNDIInvoker.validateAndBindDataSource(context, jndiName, dataSourceFactory.getPooledDataSource(map, props), props);
        } else if (value.equals("XAPooledDataSource")) {
            JNDIInvoker.validateAndBindDataSource(context, jndiName, dataSourceFactory.getTranxDataSource(map, props), props);
        } else if (value.equals("SimpleDataSource")) {
            JNDIInvoker.validateAndBindDataSource(context, jndiName, dataSourceFactory.getSimpleDataSource(map), props);
        } else if (value.equals("ManagedDataSource")) {
            ClientConnectionFactoryWrapper wrapper = dataSourceFactory.getManagedDataSource(map, props);
            ctx.rebind("java:/" + jndiName, wrapper.getClientConnFactory());
            dataSourceMap.put(jndiName, wrapper);
            if (logger.isDebugEnabled()) {
                logger.debug("Bound java:/" + jndiName + " to Context");
            }
        } else {
            String exception = "JNDIInvoker::mapDataSource::No correct type of DataSource";
            if (logger.isDebugEnabled()) {
                logger.debug(exception);
            }
            throw new DataSourceCreateException(exception);
        }
    }

    private static void validateAndBindDataSource(Context context, String jndiName, DataSource dataSource, List<ConfigProperty> props) throws NamingException, DataSourceCreateException {
        try {
            Connection connection = JNDIInvoker.getConnection(dataSource, props);
            Throwable throwable = null;
            if (connection != null) {
                if (throwable != null) {
                    try {
                        connection.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    connection.close();
                }
            }
        }
        catch (SQLException sqlEx) {
            JNDIInvoker.closeDataSource(dataSource);
            throw new DataSourceCreateException("Failed to connect to \"" + jndiName + "\". See log for details", sqlEx);
        }
        context.rebind("java:/" + jndiName, (Object)dataSource);
        dataSourceMap.put(jndiName, dataSource);
        if (logger.isDebugEnabled()) {
            logger.debug("Bound java:/" + jndiName + " to Context");
        }
    }

    private static Connection getConnection(DataSource dataSource, List<ConfigProperty> props) throws SQLException {
        return dataSource.getConnection();
    }

    public static void unMapDatasource(String jndiName) throws NamingException {
        ctx.unbind("java:/" + jndiName);
        Object removedDataSource = dataSourceMap.remove(jndiName);
        JNDIInvoker.closeDataSource(removedDataSource);
    }

    public static DataSource getDataSource(String name) {
        Object result = dataSourceMap.get(name);
        if (result instanceof DataSource) {
            return (DataSource)result;
        }
        return null;
    }

    public static boolean isValidDataSource(String name) {
        Object dataSource = dataSourceMap.get(name);
        return dataSource == null || dataSource instanceof DataSource && !(dataSource instanceof GemFireTransactionDataSource);
    }

    public static Context getJNDIContext() {
        return ctx;
    }

    public static TransactionManager getTransactionManager() {
        return transactionManager;
    }

    public static int getNoOfAvailableDataSources() {
        return dataSourceMap.size();
    }

    public static Map<String, String> getBindingNamesRecursively(Context ctx) throws Exception {
        HashMap<String, String> result = new HashMap<String, String>();
        NamingEnumeration<Binding> enumeration = ctx.listBindings("");
        while (enumeration.hasMore()) {
            Binding binding = enumeration.next();
            String name = binding.getName();
            String separator = name.endsWith(":") ? "" : "/";
            Object o = binding.getObject();
            if (o instanceof Context) {
                Map<String, String> innerBindings = JNDIInvoker.getBindingNamesRecursively((Context)o);
                innerBindings.forEach((k, v) -> result.put(name + separator + k, (String)v));
                continue;
            }
            result.put(name, binding.getClassName());
        }
        return result;
    }

    static {
        knownJNDIManagers = new String[][]{{"java:/TransactionManager", "JBoss"}, {"java:comp/TransactionManager", "Cosminexus"}, {"java:appserver/TransactionManager", "GlassFish"}, {"java:pm/TransactionManager", "SunONE"}, {"java:comp/UserTransaction", "Orion, JTOM, BEA WebLogic"}, {"javax.transaction.TransactionManager", "BEA WebLogic"}};
        dataSourceMap = new ConcurrentHashMap<String, Object>();
        IGNORE_JTA = Boolean.getBoolean("gemfire.ignoreJTA");
        dataSourceFactory = new DataSourceFactory();
    }
}

