/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.asyncqueue.internal;

import org.apache.geode.CancelException;
import org.apache.geode.StatisticsFactory;
import org.apache.geode.cache.asyncqueue.AsyncEventListener;
import org.apache.geode.cache.asyncqueue.internal.AsyncEventQueueImpl;
import org.apache.geode.cache.asyncqueue.internal.AsyncEventQueueStats;
import org.apache.geode.cache.wan.GatewayEventFilter;
import org.apache.geode.cache.wan.GatewayTransportFilter;
import org.apache.geode.distributed.DistributedLockService;
import org.apache.geode.distributed.internal.DistributionAdvisor;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.ResourceEvent;
import org.apache.geode.internal.cache.EntryEventImpl;
import org.apache.geode.internal.cache.EventID;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.RegionQueue;
import org.apache.geode.internal.cache.UpdateAttributesProcessor;
import org.apache.geode.internal.cache.ha.ThreadIdentifier;
import org.apache.geode.internal.cache.wan.AbstractGatewaySender;
import org.apache.geode.internal.cache.wan.AbstractGatewaySenderEventProcessor;
import org.apache.geode.internal.cache.wan.GatewaySenderAdvisor;
import org.apache.geode.internal.cache.wan.GatewaySenderAttributes;
import org.apache.geode.internal.cache.wan.GatewaySenderConfigurationException;
import org.apache.geode.internal.cache.wan.serial.ConcurrentSerialGatewaySenderEventProcessor;
import org.apache.geode.internal.cache.wan.serial.SerialGatewaySenderEventProcessor;
import org.apache.geode.internal.cache.wan.serial.SerialGatewaySenderQueue;
import org.apache.geode.internal.cache.xmlcache.CacheCreation;
import org.apache.geode.internal.monitoring.ThreadsMonitoring;
import org.apache.geode.internal.statistics.StatisticsClock;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class SerialAsyncEventQueueImpl
extends AbstractGatewaySender {
    private static final Logger logger = LogService.getLogger();

    public SerialAsyncEventQueueImpl(InternalCache cache, StatisticsFactory statisticsFactory, StatisticsClock statisticsClock, GatewaySenderAttributes attrs) {
        super(cache, statisticsClock, attrs);
        if (!(this.cache instanceof CacheCreation)) {
            this.statistics = new AsyncEventQueueStats(statisticsFactory, AsyncEventQueueImpl.getAsyncEventQueueIdFromSenderId(this.id), statisticsClock);
        }
    }

    @Override
    public void start() {
        this.start(false);
    }

    @Override
    public void startWithCleanQueue() {
        this.start(true);
    }

    private void start(boolean cleanQueues) {
        if (logger.isDebugEnabled()) {
            logger.debug("Starting gatewaySender : {}", (Object)this);
        }
        this.getLifeCycleLock().writeLock().lock();
        try {
            String locators;
            if (this.isRunning()) {
                logger.warn("Gateway Sender {} is already running", (Object)this.getId());
                return;
            }
            if (this.remoteDSId != -1 && (locators = this.cache.getInternalDistributedSystem().getConfig().getLocators()).length() == 0) {
                throw new GatewaySenderConfigurationException("Locators must be configured before starting gateway-sender.");
            }
            this.getSenderAdvisor().initDLockService();
            if (!this.isPrimary()) {
                if (this.getSenderAdvisor().volunteerForPrimary()) {
                    this.getSenderAdvisor().makePrimary();
                } else {
                    this.getSenderAdvisor().makeSecondary();
                }
            }
            this.eventProcessor = this.createEventProcessor(cleanQueues);
            if (this.startEventProcessorInPausedState) {
                this.pauseEvenIfProcessorStopped();
            }
            this.eventProcessor.start();
            this.waitForRunningStatus();
            this.startTime = System.currentTimeMillis();
            if (!this.isAsyncEventQueue()) {
                this.getCache().getPdxRegistry().gatewaySenderStarted(this);
            }
            new UpdateAttributesProcessor(this).distribute(false);
            InternalDistributedSystem system = (InternalDistributedSystem)this.cache.getDistributedSystem();
            system.handleResourceEvent(ResourceEvent.GATEWAYSENDER_START, this);
            logger.info("Started {}", (Object)this);
            this.enqueueTempEvents();
        }
        finally {
            this.getLifeCycleLock().writeLock().unlock();
        }
    }

    protected AbstractGatewaySenderEventProcessor createEventProcessor(boolean cleanQueues) {
        AbstractGatewaySenderEventProcessor eventProcessor = this.getDispatcherThreads() > 1 ? new ConcurrentSerialGatewaySenderEventProcessor(this, this.getThreadMonitorObj(), cleanQueues) : new SerialGatewaySenderEventProcessor(this, this.getId(), this.getThreadMonitorObj(), cleanQueues);
        return eventProcessor;
    }

    @Override
    public void stop() {
        if (logger.isDebugEnabled()) {
            logger.debug("Stopping Gateway Sender : {}", (Object)this);
        }
        this.getLifeCycleLock().writeLock().lock();
        try {
            this.stopProcessing();
            this.stompProxyDead();
            for (AsyncEventListener listener : this.listeners) {
                listener.close();
            }
            logger.info("Stopped {}", (Object)this);
            this.clearTempEventsAfterSenderStopped();
        }
        finally {
            this.getLifeCycleLock().writeLock().unlock();
        }
        if (this.isPrimary()) {
            try {
                DistributedLockService.destroy(this.getSenderAdvisor().getDLockServiceName());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (this.getQueues() != null && !this.getQueues().isEmpty()) {
            for (RegionQueue q : this.getQueues()) {
                ((SerialGatewaySenderQueue)q).cleanUp();
            }
        }
        this.setIsPrimary(false);
        try {
            new UpdateAttributesProcessor(this).distribute(false);
        }
        catch (CancelException cancelException) {
            // empty catch block
        }
        Thread lockObtainingThread = this.getSenderAdvisor().getLockObtainingThread();
        if (lockObtainingThread != null && lockObtainingThread.isAlive()) {
            try {
                lockObtainingThread.join(3000L);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
            if (lockObtainingThread.isAlive()) {
                logger.info("Could not stop lock obtaining thread during gateway sender stop");
            }
        }
        InternalDistributedSystem system = (InternalDistributedSystem)this.cache.getDistributedSystem();
        system.handleResourceEvent(ResourceEvent.GATEWAYSENDER_STOP, this);
        this.eventProcessor = null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getSimpleName());
        sb.append("{");
        sb.append("id=" + this.getId());
        sb.append(",remoteDsId=" + this.getRemoteDSId());
        sb.append(",isRunning =" + this.isRunning());
        sb.append(",isPrimary =" + this.isPrimary());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public void fillInProfile(DistributionAdvisor.Profile profile) {
        assert (profile instanceof GatewaySenderAdvisor.GatewaySenderProfile);
        GatewaySenderAdvisor.GatewaySenderProfile pf = (GatewaySenderAdvisor.GatewaySenderProfile)profile;
        pf.Id = this.getId();
        pf.startTime = this.getStartTime();
        pf.remoteDSId = this.getRemoteDSId();
        pf.isRunning = this.isRunning();
        pf.isPrimary = this.isPrimary();
        pf.isParallel = false;
        pf.isBatchConflationEnabled = this.isBatchConflationEnabled();
        pf.isPersistenceEnabled = this.isPersistenceEnabled();
        pf.alertThreshold = this.getAlertThreshold();
        pf.manualStart = this.isManualStart();
        for (GatewayEventFilter gatewayEventFilter : this.getGatewayEventFilters()) {
            pf.eventFiltersClassNames.add(gatewayEventFilter.getClass().getName());
        }
        for (GatewayTransportFilter gatewayTransportFilter : this.getGatewayTransportFilters()) {
            pf.transFiltersClassNames.add(gatewayTransportFilter.getClass().getName());
        }
        for (AsyncEventListener asyncEventListener : this.getAsyncEventListeners()) {
            pf.senderEventListenerClassNames.add(asyncEventListener.getClass().getName());
        }
        pf.isDiskSynchronous = this.isDiskSynchronous();
        pf.dispatcherThreads = this.getDispatcherThreads();
        pf.orderPolicy = this.getOrderPolicy();
        pf.serverLocation = this.getServerLocation();
    }

    @Override
    public void setModifiedEventId(EntryEventImpl clonedEvent) {
        EventID originalEventId = clonedEvent.getEventId();
        long originalThreadId = originalEventId.getThreadID();
        long newThreadId = originalThreadId;
        if (!ThreadIdentifier.isWanTypeThreadID(newThreadId)) {
            newThreadId = ThreadIdentifier.createFakeThreadIDForParallelGSPrimaryBucket(0, originalThreadId, this.getEventIdIndex());
        }
        EventID newEventId = new EventID(originalEventId.getMembershipID(), newThreadId, originalEventId.getSequenceID());
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Generated event id for event with key={}, original event id={}, originalThreadId={}, new event id={}, newThreadId={}", (Object)this, clonedEvent.getKey(), (Object)originalEventId, (Object)originalThreadId, (Object)newEventId, (Object)newThreadId);
        }
        clonedEvent.setEventId(newEventId);
    }

    private ThreadsMonitoring getThreadMonitorObj() {
        DistributionManager distributionManager = this.cache.getDistributionManager();
        if (distributionManager != null) {
            return distributionManager.getThreadMonitoring();
        }
        return null;
    }
}

