/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.string;

import java.util.List;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.TimeoutException;
import org.apache.geode.redis.internal.AutoCloseableLock;
import org.apache.geode.redis.internal.ByteArrayWrapper;
import org.apache.geode.redis.internal.Coder;
import org.apache.geode.redis.internal.Command;
import org.apache.geode.redis.internal.ExecutionHandlerContext;
import org.apache.geode.redis.internal.RedisDataType;
import org.apache.geode.redis.internal.executor.string.StringExecutor;

public class GetSetExecutor
extends StringExecutor {
    private final int VALUE_INDEX = 2;

    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        ByteArrayWrapper oldValueWrapper;
        List<byte[]> commandElems = command.getProcessedCommand();
        if (commandElems.size() != 3) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The wrong number of arguments or syntax was provided, the format for the GETSET command is \"GETSET key value\""));
            return;
        }
        Region<ByteArrayWrapper, ByteArrayWrapper> region = context.getRegionProvider().getStringsRegion();
        ByteArrayWrapper key = command.getKey();
        this.checkAndSetDataType(key, context);
        byte[] newCharValue = commandElems.get(2);
        ByteArrayWrapper newValueWrapper = new ByteArrayWrapper(newCharValue);
        try (AutoCloseableLock regionLock = this.withRegionLock(context, key);){
            oldValueWrapper = (ByteArrayWrapper)region.get((Object)key);
            if (oldValueWrapper != null) {
                try {
                    this.checkDataType(oldValueWrapper, RedisDataType.REDIS_STRING, context);
                }
                catch (Exception e) {
                    command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "Operation against a key holding the wrong kind of value"));
                    if (regionLock != null) {
                        if (var10_11 != null) {
                            try {
                                regionLock.close();
                            }
                            catch (Throwable throwable) {
                                var10_11.addSuppressed(throwable);
                            }
                        } else {
                            regionLock.close();
                        }
                    }
                    return;
                }
            }
            region.put((Object)key, (Object)newValueWrapper);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "Thread interrupted."));
            return;
        }
        catch (TimeoutException e) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "Timeout acquiring lock. Please try again."));
            return;
        }
        this.respondBulkStrings(command, context, oldValueWrapper);
    }
}

