/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.list;

import java.util.List;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.query.Query;
import org.apache.geode.cache.query.SelectResults;
import org.apache.geode.redis.internal.ByteArrayWrapper;
import org.apache.geode.redis.internal.Coder;
import org.apache.geode.redis.internal.Command;
import org.apache.geode.redis.internal.ExecutionHandlerContext;
import org.apache.geode.redis.internal.RedisDataType;
import org.apache.geode.redis.internal.executor.ListQuery;
import org.apache.geode.redis.internal.executor.list.ListExecutor;

public class LTrimExecutor
extends ListExecutor {
    private static final String ERROR_KEY_NOT_EXISTS = "The key does not exists on this server";
    private static final String ERROR_NOT_NUMERIC = "The index provided is not numeric";
    private static final String SUCCESS = "OK";

    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        List<Integer> keepList;
        int redisStop;
        int redisStart;
        List<byte[]> commandElems = command.getProcessedCommand();
        if (commandElems.size() < 4) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The wrong number of arguments or syntax was provided, the format for the LTRIM command is \"LTRIM key start stop\""));
            return;
        }
        ByteArrayWrapper key = command.getKey();
        byte[] startArray = commandElems.get(2);
        byte[] stopArray = commandElems.get(3);
        this.checkDataType(key, RedisDataType.REDIS_LIST, context);
        Region<Object, Object> keyRegion = this.getRegion(context, key);
        if (keyRegion == null) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), ERROR_KEY_NOT_EXISTS));
            return;
        }
        int listSize = keyRegion.size() - 2;
        if (listSize == 0) {
            command.setResponse(Coder.getSimpleStringResponse(context.getByteBufAllocator(), SUCCESS));
            return;
        }
        try {
            redisStart = Coder.bytesToInt(startArray);
            redisStop = Coder.bytesToInt(stopArray);
        }
        catch (NumberFormatException e) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), ERROR_NOT_NUMERIC));
            return;
        }
        redisStart = this.getBoundedStartIndex(redisStart, listSize);
        redisStop = this.getBoundedEndIndex(redisStop, listSize);
        redisStart = Math.min(redisStart, listSize - 1);
        redisStop = Math.min(redisStop, listSize - 1);
        if (redisStart == 0 && redisStop == listSize - 1) {
            command.setResponse(Coder.getSimpleStringResponse(context.getByteBufAllocator(), SUCCESS));
            return;
        }
        if (redisStart == 0 && redisStop < redisStart) {
            context.getRegionProvider().removeKey(key, RedisDataType.REDIS_LIST);
            command.setResponse(Coder.getSimpleStringResponse(context.getByteBufAllocator(), SUCCESS));
            return;
        }
        try {
            keepList = this.getRange(context, key, redisStart, redisStop);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        for (Object keyElement : keyRegion.keySet()) {
            if (keepList.contains(keyElement) || !(keyElement instanceof Integer)) continue;
            keyRegion.remove(keyElement);
        }
        keyRegion.put((Object)"head", (Object)keepList.get(0));
        keyRegion.put((Object)"tail", (Object)keepList.get(keepList.size() - 1));
        command.setResponse(Coder.getSimpleStringResponse(context.getByteBufAllocator(), SUCCESS));
    }

    private List<Integer> getRange(ExecutionHandlerContext context, ByteArrayWrapper key, int start, int stop) throws Exception {
        Object[] params;
        Query query = this.getQuery(key, ListQuery.LTRIM, context);
        SelectResults results = (SelectResults)query.execute(params = new Object[]{stop + 1});
        if (results == null || results.size() <= start) {
            return null;
        }
        return results.asList().subList(start, results.size());
    }
}

