/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor;

import java.util.List;
import org.apache.geode.redis.internal.ByteArrayWrapper;
import org.apache.geode.redis.internal.Coder;
import org.apache.geode.redis.internal.Command;
import org.apache.geode.redis.internal.ExecutionHandlerContext;
import org.apache.geode.redis.internal.Extendable;
import org.apache.geode.redis.internal.RegionProvider;
import org.apache.geode.redis.internal.executor.AbstractExecutor;

public class ExpireExecutor
extends AbstractExecutor
implements Extendable {
    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        boolean expirationSucessfullySet;
        long delay;
        List<byte[]> commandElems = command.getProcessedCommand();
        int NOT_SET = 0;
        int SET = 1;
        int SECONDS_INDEX = 2;
        if (commandElems.size() != 3) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), this.getArgsError()));
            return;
        }
        ByteArrayWrapper key = command.getKey();
        RegionProvider regionProvider = context.getRegionProvider();
        byte[] delayByteArray = commandElems.get(SECONDS_INDEX);
        try {
            delay = Coder.bytesToLong(delayByteArray);
        }
        catch (NumberFormatException e) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "value is not an integer or out of range"));
            return;
        }
        if (delay <= 0L) {
            command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), NOT_SET));
            return;
        }
        if (!this.timeUnitMillis()) {
            delay *= 1000L;
        }
        if (expirationSucessfullySet = regionProvider.hasExpiration(key) ? regionProvider.modifyExpiration(key, delay) : regionProvider.setExpiration(key, delay)) {
            command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), SET));
        } else {
            command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), NOT_SET));
        }
    }

    protected boolean timeUnitMillis() {
        return false;
    }

    @Override
    public String getArgsError() {
        return "The wrong number of arguments or syntax was provided, the format for the EXPIRE command is \"EXPIRE key seconds\"";
    }
}

