/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal.membership.api;

import java.io.NotSerializableException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import org.apache.geode.distributed.internal.membership.api.MemberDisconnectedException;
import org.apache.geode.distributed.internal.membership.api.MemberIdentifier;
import org.apache.geode.distributed.internal.membership.api.MemberShunnedException;
import org.apache.geode.distributed.internal.membership.api.MemberStartupException;
import org.apache.geode.distributed.internal.membership.api.MembershipClosedException;
import org.apache.geode.distributed.internal.membership.api.MembershipView;
import org.apache.geode.distributed.internal.membership.api.Message;
import org.apache.geode.distributed.internal.membership.api.QuorumChecker;

public interface Membership<ID extends MemberIdentifier> {
    public MembershipView<ID> getView();

    public ID getLocalMember();

    public Set<ID> send(ID[] var1, Message<ID> var2) throws NotSerializableException;

    public Map<String, Long> getMessageState(ID var1, boolean var2, Map<String, Long> var3);

    public void waitForMessageState(ID var1, Map<String, Long> var2) throws InterruptedException, TimeoutException;

    public boolean requestMemberRemoval(ID var1, String var2) throws MemberDisconnectedException;

    public boolean verifyMember(ID var1, String var2);

    public boolean isShunned(ID var1);

    public <V> V doWithViewLocked(Supplier<V> var1);

    public boolean memberExists(ID var1);

    public boolean isConnected();

    public void beSick();

    public void playDead();

    public void beHealthy();

    public boolean isBeingSick();

    public void disconnect(boolean var1);

    public void shutdown();

    public void uncleanShutdown(String var1, Exception var2);

    public void shutdownMessageReceived(ID var1, String var2);

    public void waitForEventProcessing() throws InterruptedException;

    public void startEventProcessing();

    public void setShutdown();

    public void setReconnectCompleted(boolean var1);

    public boolean shutdownInProgress();

    public boolean waitForNewMember(ID var1);

    public void emergencyClose();

    public void addSurpriseMemberForTesting(ID var1, long var2);

    public void suspectMembers(Set<ID> var1, String var2);

    public void suspectMember(ID var1, String var2);

    public Throwable getShutdownCause();

    public void warnShun(ID var1);

    public boolean addSurpriseMember(ID var1);

    public void startupMessageFailed(ID var1, String var2);

    public boolean testMulticast();

    public boolean isSurpriseMember(ID var1);

    public QuorumChecker getQuorumChecker();

    public ID getCoordinator();

    public Set<ID> getMembersNotShuttingDown();

    public void processMessage(Message<ID> var1) throws MemberShunnedException;

    public void checkCancelled() throws MembershipClosedException;

    public void waitIfPlayingDead();

    public boolean isJoining();

    public ID[] getAllMembers(ID[] var1);

    public boolean hasMember(ID var1);

    public void start() throws MemberStartupException;

    public void setCloseInProgress();
}

