/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.shaded.org.apache.orc.impl.writer;

import java.io.IOException;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.ql.util.JavaDataModel;
import org.apache.flink.table.store.shaded.org.apache.orc.OrcProto;
import org.apache.flink.table.store.shaded.org.apache.orc.TypeDescription;
import org.apache.flink.table.store.shaded.org.apache.orc.impl.IntegerWriter;
import org.apache.flink.table.store.shaded.org.apache.orc.impl.OutStream;
import org.apache.flink.table.store.shaded.org.apache.orc.impl.PositionRecorder;
import org.apache.flink.table.store.shaded.org.apache.orc.impl.writer.TreeWriterBase;
import org.apache.flink.table.store.shaded.org.apache.orc.impl.writer.WriterContext;

public class DateTreeWriter
extends TreeWriterBase {
    private final IntegerWriter writer;
    private final boolean isDirectV2;

    public DateTreeWriter(int columnId, TypeDescription schema, WriterContext writer, boolean nullable) throws IOException {
        super(columnId, schema, writer, nullable);
        OutStream out = writer.createStream(this.id, OrcProto.Stream.Kind.DATA);
        this.isDirectV2 = this.isNewWriteFormat(writer);
        this.writer = this.createIntegerWriter(out, true, this.isDirectV2, writer);
        if (this.rowIndexPosition != null) {
            this.recordPosition(this.rowIndexPosition);
        }
    }

    @Override
    public void writeBatch(ColumnVector vector, int offset, int length) throws IOException {
        block6: {
            LongColumnVector vec;
            block5: {
                super.writeBatch(vector, offset, length);
                vec = (LongColumnVector)vector;
                if (!vector.isRepeating) break block5;
                if (!vector.noNulls && vector.isNull[0]) break block6;
                int value = (int)vec.vector[0];
                this.indexStatistics.updateDate(value);
                if (this.createBloomFilter) {
                    if (this.bloomFilter != null) {
                        this.bloomFilter.addLong(value);
                    }
                    this.bloomFilterUtf8.addLong(value);
                }
                for (int i = 0; i < length; ++i) {
                    this.writer.write(value);
                }
                break block6;
            }
            for (int i = 0; i < length; ++i) {
                if (!vec.noNulls && vec.isNull[i + offset]) continue;
                int value = (int)vec.vector[i + offset];
                this.writer.write(value);
                this.indexStatistics.updateDate(value);
                if (!this.createBloomFilter) continue;
                if (this.bloomFilter != null) {
                    this.bloomFilter.addLong(value);
                }
                this.bloomFilterUtf8.addLong(value);
            }
        }
    }

    @Override
    public void writeStripe(OrcProto.StripeFooter.Builder builder, OrcProto.StripeStatistics.Builder stats, int requiredIndexEntries) throws IOException {
        super.writeStripe(builder, stats, requiredIndexEntries);
        if (this.rowIndexPosition != null) {
            this.recordPosition(this.rowIndexPosition);
        }
    }

    @Override
    void recordPosition(PositionRecorder recorder) throws IOException {
        super.recordPosition(recorder);
        this.writer.getPosition(recorder);
    }

    @Override
    OrcProto.ColumnEncoding.Builder getEncoding() {
        OrcProto.ColumnEncoding.Builder result = super.getEncoding();
        if (this.isDirectV2) {
            result.setKind(OrcProto.ColumnEncoding.Kind.DIRECT_V2);
        } else {
            result.setKind(OrcProto.ColumnEncoding.Kind.DIRECT);
        }
        return result;
    }

    @Override
    public long estimateMemory() {
        return super.estimateMemory() + this.writer.estimateMemory();
    }

    @Override
    public long getRawDataSize() {
        return this.fileStatistics.getNumberOfValues() * (long)JavaDataModel.get().lengthOfDate();
    }

    @Override
    public void flushStreams() throws IOException {
        super.flushStreams();
        this.writer.flush();
    }
}

