/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.feature.kbinsdiscretizer;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.serialization.Encoder;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.base.IntSerializer;
import org.apache.flink.api.common.typeutils.base.array.DoublePrimitiveArraySerializer;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.connector.file.src.reader.SimpleStreamFormat;
import org.apache.flink.connector.file.src.reader.StreamFormat;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.table.api.internal.TableImpl;

public class KBinsDiscretizerModelData {
    public double[][] binEdges;

    public KBinsDiscretizerModelData() {
    }

    public KBinsDiscretizerModelData(double[][] binEdges) {
        this.binEdges = binEdges;
    }

    public static DataStream<KBinsDiscretizerModelData> getModelDataStream(Table modelDataTable) {
        StreamTableEnvironment tEnv = (StreamTableEnvironment)((TableImpl)modelDataTable).getTableEnvironment();
        return tEnv.toDataStream(modelDataTable).map((MapFunction & Serializable)x -> new KBinsDiscretizerModelData((double[][])x.getField(0)));
    }

    public static class ModelDataDecoder
    extends SimpleStreamFormat<KBinsDiscretizerModelData> {
        public StreamFormat.Reader<KBinsDiscretizerModelData> createReader(Configuration config, final FSDataInputStream stream) {
            return new StreamFormat.Reader<KBinsDiscretizerModelData>(){

                public KBinsDiscretizerModelData read() throws IOException {
                    DataInputViewStreamWrapper source = new DataInputViewStreamWrapper((InputStream)stream);
                    try {
                        int numColumns = IntSerializer.INSTANCE.deserialize((DataInputView)source);
                        double[][] binEdges = new double[numColumns][];
                        DoublePrimitiveArraySerializer doubleArraySerializer = DoublePrimitiveArraySerializer.INSTANCE;
                        for (int i = 0; i < numColumns; ++i) {
                            binEdges[i] = doubleArraySerializer.deserialize((DataInputView)source);
                        }
                        return new KBinsDiscretizerModelData(binEdges);
                    }
                    catch (EOFException e) {
                        return null;
                    }
                }

                public void close() throws IOException {
                    stream.close();
                }
            };
        }

        public TypeInformation<KBinsDiscretizerModelData> getProducedType() {
            return TypeInformation.of(KBinsDiscretizerModelData.class);
        }
    }

    public static class ModelDataEncoder
    implements Encoder<KBinsDiscretizerModelData> {
        public void encode(KBinsDiscretizerModelData modelData, OutputStream outputStream) throws IOException {
            DataOutputViewStreamWrapper dataOutputView = new DataOutputViewStreamWrapper(outputStream);
            IntSerializer.INSTANCE.serialize(Integer.valueOf(modelData.binEdges.length), (DataOutputView)dataOutputView);
            DoublePrimitiveArraySerializer doubleArraySerializer = DoublePrimitiveArraySerializer.INSTANCE;
            for (double[] binEdge : modelData.binEdges) {
                doubleArraySerializer.serialize(binEdge, (DataOutputView)dataOutputView);
            }
        }
    }
}

