/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.flink.core.nettyclient;

import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import javax.net.ssl.SSLException;
import org.apache.flink.core.fs.CloseableRegistry;
import org.apache.flink.shaded.netty4.io.netty.bootstrap.Bootstrap;
import org.apache.flink.shaded.netty4.io.netty.channel.EventLoopGroup;
import org.apache.flink.shaded.netty4.io.netty.channel.epoll.Epoll;
import org.apache.flink.shaded.netty4.io.netty.channel.epoll.EpollEventLoopGroup;
import org.apache.flink.shaded.netty4.io.netty.channel.epoll.EpollSocketChannel;
import org.apache.flink.shaded.netty4.io.netty.channel.kqueue.KQueue;
import org.apache.flink.shaded.netty4.io.netty.channel.kqueue.KQueueEventLoopGroup;
import org.apache.flink.shaded.netty4.io.netty.channel.kqueue.KQueueSocketChannel;
import org.apache.flink.shaded.netty4.io.netty.channel.nio.NioEventLoopGroup;
import org.apache.flink.shaded.netty4.io.netty.channel.socket.nio.NioSocketChannel;
import org.apache.flink.shaded.netty4.io.netty.handler.ssl.SslContext;
import org.apache.flink.shaded.netty4.io.netty.handler.ssl.SslContextBuilder;
import org.apache.flink.util.IOUtils;

final class NettySharedResources {
    private final AtomicBoolean shutdown = new AtomicBoolean();
    private final Bootstrap bootstrap;
    @Nullable
    private SslContext sslContext;
    private final CloseableRegistry mangedResources = new CloseableRegistry();

    public NettySharedResources() {
        Class<EpollSocketChannel> channelClass;
        EpollEventLoopGroup workerGroup;
        if (Epoll.isAvailable()) {
            workerGroup = new EpollEventLoopGroup(NettySharedResources.demonThreadFactory("netty-http-worker"));
            channelClass = EpollSocketChannel.class;
        } else if (KQueue.isAvailable()) {
            workerGroup = new KQueueEventLoopGroup(NettySharedResources.demonThreadFactory("http-netty-worker"));
            channelClass = KQueueSocketChannel.class;
        } else {
            workerGroup = new NioEventLoopGroup(NettySharedResources.demonThreadFactory("netty-http-client"));
            channelClass = NioSocketChannel.class;
        }
        this.registerClosable(() -> ((EventLoopGroup)workerGroup).shutdownGracefully());
        Bootstrap bootstrap = new Bootstrap();
        bootstrap.group((EventLoopGroup)workerGroup);
        bootstrap.channel(channelClass);
        this.bootstrap = bootstrap;
    }

    public Bootstrap bootstrap() {
        return this.bootstrap;
    }

    public SslContext sslContext() {
        SslContext sslCtx = this.sslContext;
        if (sslCtx != null) {
            return sslCtx;
        }
        try {
            this.sslContext = sslCtx = SslContextBuilder.forClient().build();
            return sslCtx;
        }
        catch (SSLException e) {
            throw new IllegalStateException("Failed to initialize an SSL provider", e);
        }
    }

    public void registerClosable(Closeable closeable) {
        try {
            this.mangedResources.registerCloseable(closeable);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public boolean isShutdown() {
        return this.shutdown.get();
    }

    public void shutdownGracefully() {
        if (this.shutdown.compareAndSet(false, true)) {
            IOUtils.closeQuietly((AutoCloseable)this.mangedResources);
        }
    }

    private static ThreadFactory demonThreadFactory(String name) {
        return runnable -> {
            Thread t = new Thread(runnable);
            t.setDaemon(true);
            t.setName(name);
            return t;
        };
    }
}

