/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.flink.core.logger;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.core.memory.DataOutputSerializer;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.statefun.flink.core.feedback.FeedbackConsumer;
import org.apache.flink.statefun.flink.core.logger.CheckpointedStreamOperations;
import org.apache.flink.statefun.flink.core.logger.FeedbackLogger;
import org.apache.flink.statefun.flink.core.logger.InputStreamUtils;
import org.apache.flink.statefun.flink.core.logger.KeyGroupStream;
import org.apache.flink.util.IOUtils;
import org.apache.flink.util.Preconditions;

public final class UnboundedFeedbackLogger<T>
implements FeedbackLogger<T> {
    private final Supplier<KeyGroupStream<T>> supplier;
    private final ToIntFunction<T> keyGroupAssigner;
    private final Map<Integer, KeyGroupStream<T>> keyGroupStreams;
    private final CheckpointedStreamOperations checkpointedStreamOperations;
    @Nullable
    private OutputStream keyedStateOutputStream;
    private TypeSerializer<T> serializer;
    private Closeable snapshotLease;

    public UnboundedFeedbackLogger(Supplier<KeyGroupStream<T>> supplier, ToIntFunction<T> keyGroupAssigner, CheckpointedStreamOperations ops, TypeSerializer<T> serializer) {
        this.supplier = Objects.requireNonNull(supplier);
        this.keyGroupAssigner = Objects.requireNonNull(keyGroupAssigner);
        this.serializer = Objects.requireNonNull(serializer);
        this.keyGroupStreams = new TreeMap<Integer, KeyGroupStream<T>>();
        this.checkpointedStreamOperations = Objects.requireNonNull(ops);
    }

    @Override
    public void startLogging(OutputStream keyedStateCheckpointOutputStream) {
        this.checkpointedStreamOperations.requireKeyedStateCheckpointed(keyedStateCheckpointOutputStream);
        this.keyedStateOutputStream = Objects.requireNonNull(keyedStateCheckpointOutputStream);
        this.snapshotLease = this.checkpointedStreamOperations.acquireLease(keyedStateCheckpointOutputStream);
    }

    @Override
    public void append(T message) {
        if (this.keyedStateOutputStream == null) {
            return;
        }
        KeyGroupStream<T> keyGroup = this.keyGroupStreamFor(message);
        keyGroup.append(message);
    }

    @Override
    public void commit() {
        try {
            this.flushToKeyedStateOutputStream();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.keyGroupStreams.clear();
            IOUtils.closeQuietly((AutoCloseable)this.snapshotLease);
            this.snapshotLease = null;
            this.keyedStateOutputStream = null;
        }
    }

    private void flushToKeyedStateOutputStream() throws IOException {
        Preconditions.checkState((this.keyedStateOutputStream != null ? 1 : 0) != 0, (Object)"Trying to flush envelopes not in a logging state");
        DataOutputViewStreamWrapper target = new DataOutputViewStreamWrapper(this.keyedStateOutputStream);
        Iterable<Integer> assignedKeyGroupIds = this.checkpointedStreamOperations.keyGroupList(this.keyedStateOutputStream);
        for (Integer keyGroupId : assignedKeyGroupIds) {
            this.checkpointedStreamOperations.startNewKeyGroup(this.keyedStateOutputStream, keyGroupId);
            Header.writeHeader((DataOutputView)target);
            KeyGroupStream<T> stream = this.keyGroupStreams.get(keyGroupId);
            if (stream == null) {
                KeyGroupStream.writeEmptyTo((DataOutputView)target);
                continue;
            }
            stream.writeTo((DataOutputView)target);
        }
    }

    public void replyLoggedEnvelops(InputStream rawKeyedStateInputs, FeedbackConsumer<T> consumer) throws Exception {
        DataInputViewStreamWrapper in = new DataInputViewStreamWrapper(Header.skipHeaderSilently(rawKeyedStateInputs));
        KeyGroupStream.readFrom((DataInputView)in, this.serializer, consumer);
    }

    @Nonnull
    private KeyGroupStream<T> keyGroupStreamFor(T target) {
        int keyGroupId = this.keyGroupAssigner.applyAsInt(target);
        KeyGroupStream<T> keyGroup = this.keyGroupStreams.get(keyGroupId);
        if (keyGroup == null) {
            keyGroup = this.supplier.get();
            this.keyGroupStreams.put(keyGroupId, keyGroup);
        }
        return keyGroup;
    }

    @Override
    public void close() {
        IOUtils.closeQuietly((AutoCloseable)this.snapshotLease);
        this.snapshotLease = null;
        this.keyedStateOutputStream = null;
        this.keyGroupStreams.clear();
    }

    @VisibleForTesting
    static final class Header {
        private static final int STATEFUN_VERSION = 0;
        private static final int STATEFUN_MAGIC = 710818519;
        private static final byte[] HEADER_BYTES = Header.headerBytes();

        Header() {
        }

        public static void writeHeader(DataOutputView target) throws IOException {
            target.write(HEADER_BYTES);
        }

        public static InputStream skipHeaderSilently(InputStream rawKeyedInput) throws IOException {
            byte[] header = new byte[HEADER_BYTES.length];
            PushbackInputStream input = new PushbackInputStream(rawKeyedInput, header.length);
            int bytesRead = InputStreamUtils.tryReadFully(input, header);
            if (bytesRead > 0 && !Arrays.equals(header, HEADER_BYTES)) {
                input.unread(header, 0, bytesRead);
            }
            return input;
        }

        private static byte[] headerBytes() {
            DataOutputSerializer out = new DataOutputSerializer(8);
            try {
                out.writeInt(0);
                out.writeInt(710818519);
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to compute the header bytes");
            }
            return out.getCopyOfBuffer();
        }
    }
}

