/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.clustering.kmeans;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Random;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.serialization.Encoder;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.base.IntSerializer;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.connector.file.src.reader.SimpleStreamFormat;
import org.apache.flink.connector.file.src.reader.StreamFormat;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.ml.common.datastream.TableUtils;
import org.apache.flink.ml.linalg.DenseVector;
import org.apache.flink.ml.linalg.Vector;
import org.apache.flink.ml.linalg.typeinfo.DenseVectorSerializer;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.table.api.internal.TableImpl;
import org.apache.flink.util.Preconditions;

public class KMeansModelData {
    public DenseVector[] centroids;
    public DenseVector weights;

    public KMeansModelData(DenseVector[] centroids, DenseVector weights) {
        Preconditions.checkArgument((centroids.length == weights.size() ? 1 : 0) != 0);
        this.centroids = centroids;
        this.weights = weights;
    }

    public KMeansModelData() {
    }

    public static Table generateRandomModelData(StreamTableEnvironment tEnv, int k, int dim, double weight, long seed) {
        StreamExecutionEnvironment env = TableUtils.getExecutionEnvironment(tEnv);
        return tEnv.fromDataStream((DataStream)env.fromElements((Object[])new Integer[]{1}).map((MapFunction)new RandomCentroidsCreator(k, dim, weight, seed)));
    }

    public static DataStream<KMeansModelData> getModelDataStream(Table modelData) {
        StreamTableEnvironment tEnv = (StreamTableEnvironment)((TableImpl)modelData).getTableEnvironment();
        return tEnv.toDataStream(modelData).map((MapFunction & Serializable)x -> new KMeansModelData((DenseVector[])Arrays.stream((Vector[])x.getField(0)).map(Vector::toDense).toArray(DenseVector[]::new), ((Vector)x.getField(1)).toDense()));
    }

    public static class ModelDataDecoder
    extends SimpleStreamFormat<KMeansModelData> {
        public StreamFormat.Reader<KMeansModelData> createReader(Configuration config, final FSDataInputStream inputStream) {
            return new StreamFormat.Reader<KMeansModelData>(){
                private final DenseVectorSerializer serializer = new DenseVectorSerializer();

                public KMeansModelData read() throws IOException {
                    try {
                        DataInputViewStreamWrapper inputViewStreamWrapper = new DataInputViewStreamWrapper((InputStream)inputStream);
                        int numDenseVectors = IntSerializer.INSTANCE.deserialize((DataInputView)inputViewStreamWrapper);
                        DenseVector[] centroids = new DenseVector[numDenseVectors];
                        for (int i = 0; i < numDenseVectors; ++i) {
                            centroids[i] = this.serializer.deserialize((DataInputView)inputViewStreamWrapper);
                        }
                        DenseVector weights = this.serializer.deserialize((DataInputView)inputViewStreamWrapper);
                        return new KMeansModelData(centroids, weights);
                    }
                    catch (EOFException e) {
                        return null;
                    }
                }

                public void close() throws IOException {
                    inputStream.close();
                }
            };
        }

        public TypeInformation<KMeansModelData> getProducedType() {
            return TypeInformation.of(KMeansModelData.class);
        }
    }

    public static class ModelDataEncoder
    implements Encoder<KMeansModelData> {
        private final DenseVectorSerializer serializer = new DenseVectorSerializer();

        public void encode(KMeansModelData modelData, OutputStream outputStream) throws IOException {
            DataOutputViewStreamWrapper outputViewStreamWrapper = new DataOutputViewStreamWrapper(outputStream);
            IntSerializer.INSTANCE.serialize(Integer.valueOf(modelData.centroids.length), (DataOutputView)outputViewStreamWrapper);
            for (DenseVector denseVector : modelData.centroids) {
                this.serializer.serialize(denseVector, (DataOutputView)new DataOutputViewStreamWrapper(outputStream));
            }
            this.serializer.serialize(modelData.weights, (DataOutputView)new DataOutputViewStreamWrapper(outputStream));
        }
    }

    private static class RandomCentroidsCreator
    implements MapFunction<Integer, KMeansModelData> {
        private final int k;
        private final int dim;
        private final double weight;
        private final long seed;

        private RandomCentroidsCreator(int k, int dim, double weight, long seed) {
            this.k = k;
            this.dim = dim;
            this.weight = weight;
            this.seed = seed;
        }

        public KMeansModelData map(Integer integer) {
            DenseVector[] centroids = new DenseVector[this.k];
            Random random = new Random(this.seed);
            for (int i = 0; i < this.k; ++i) {
                centroids[i] = new DenseVector(this.dim);
                for (int j = 0; j < this.dim; ++j) {
                    centroids[i].values[j] = random.nextDouble();
                }
            }
            DenseVector weights = new DenseVector(this.k);
            Arrays.fill(weights.values, this.weight);
            return new KMeansModelData(centroids, weights);
        }
    }
}

