/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.examples.feature;

import java.util.Arrays;
import java.util.List;
import org.apache.flink.ml.feature.vectorindexer.VectorIndexer;
import org.apache.flink.ml.feature.vectorindexer.VectorIndexerModel;
import org.apache.flink.ml.linalg.Vectors;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.types.Row;
import org.apache.flink.util.CloseableIterator;

public class VectorIndexerExample {
    public static void main(String[] args) {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        StreamTableEnvironment tEnv = StreamTableEnvironment.create((StreamExecutionEnvironment)env);
        List<Row> trainInput = Arrays.asList(Row.of((Object[])new Object[]{Vectors.dense((double[])new double[]{1.0, 1.0})}), Row.of((Object[])new Object[]{Vectors.dense((double[])new double[]{2.0, -1.0})}), Row.of((Object[])new Object[]{Vectors.dense((double[])new double[]{3.0, 1.0})}), Row.of((Object[])new Object[]{Vectors.dense((double[])new double[]{4.0, 0.0})}), Row.of((Object[])new Object[]{Vectors.dense((double[])new double[]{5.0, 0.0})}));
        List<Row> predictInput = Arrays.asList(Row.of((Object[])new Object[]{Vectors.dense((double[])new double[]{0.0, 2.0})}), Row.of((Object[])new Object[]{Vectors.dense((double[])new double[]{0.0, 0.0})}), Row.of((Object[])new Object[]{Vectors.dense((double[])new double[]{0.0, -1.0})}));
        Table trainTable = tEnv.fromDataStream((DataStream)env.fromCollection(trainInput)).as("input", new String[0]);
        Table predictTable = tEnv.fromDataStream((DataStream)env.fromCollection(predictInput)).as("input", new String[0]);
        VectorIndexer vectorIndexer = (VectorIndexer)((VectorIndexer)((VectorIndexer)((VectorIndexer)new VectorIndexer().setInputCol("input")).setOutputCol("output")).setHandleInvalid("keep")).setMaxCategories(3);
        VectorIndexerModel model = vectorIndexer.fit(new Table[]{trainTable});
        Table outputTable = model.transform(new Table[]{predictTable})[0];
        CloseableIterator it = outputTable.execute().collect();
        while (it.hasNext()) {
            Row row = (Row)it.next();
            System.out.printf("Input Value: %s \tOutput Value: %s\n", row.getField(vectorIndexer.getInputCol()), row.getField(vectorIndexer.getOutputCol()));
        }
    }
}

