/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.catalog.CatalogStore;
import org.apache.flink.table.catalog.FileCatalogStore;
import org.apache.flink.table.catalog.FileCatalogStoreFactoryOptions;
import org.apache.flink.table.factories.CatalogStoreFactory;
import org.apache.flink.table.factories.FactoryUtil;

public class FileCatalogStoreFactory
implements CatalogStoreFactory {
    private String path;

    @Override
    public CatalogStore createCatalogStore() {
        return new FileCatalogStore(this.path);
    }

    @Override
    public void open(CatalogStoreFactory.Context context) {
        FactoryUtil.CatalogStoreFactoryHelper factoryHelper = FactoryUtil.createCatalogStoreFactoryHelper(this, context);
        factoryHelper.validate();
        ReadableConfig options = factoryHelper.getOptions();
        this.path = (String)options.get(FileCatalogStoreFactoryOptions.PATH);
    }

    @Override
    public void close() {
    }

    @Override
    public String factoryIdentifier() {
        return "file";
    }

    @Override
    public Set<ConfigOption<?>> requiredOptions() {
        HashSet<ConfigOption<String>> options = new HashSet<ConfigOption<String>>();
        options.add(FileCatalogStoreFactoryOptions.PATH);
        return Collections.unmodifiableSet(options);
    }

    @Override
    public Set<ConfigOption<?>> optionalOptions() {
        return Collections.emptySet();
    }
}

