/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cep.nfa;

import java.io.IOException;
import org.apache.flink.api.common.typeutils.CompositeTypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.cep.nfa.DeweyNumber;
import org.apache.flink.cep.nfa.NFAState;
import org.apache.flink.cep.nfa.NFAStateSerializer;
import org.apache.flink.cep.nfa.sharedbuffer.EventId;
import org.apache.flink.cep.nfa.sharedbuffer.NodeId;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;

public class NFAStateSerializerSnapshot
extends CompositeTypeSerializerSnapshot<NFAState, NFAStateSerializer> {
    private static final int CURRENT_VERSION = 2;
    private static final int FIRST_VERSION_WITH_PREVIOUS_TIMESTAMP = 2;
    private boolean supportsPreviousTimestamp = true;

    public NFAStateSerializerSnapshot() {
        super(NFAStateSerializer.class);
    }

    public NFAStateSerializerSnapshot(NFAStateSerializer serializerInstance) {
        super((TypeSerializer)serializerInstance);
        this.supportsPreviousTimestamp = serializerInstance.isSupportsPreviousTimestamp();
    }

    protected int getCurrentOuterSnapshotVersion() {
        return 2;
    }

    protected void readOuterSnapshot(int readOuterSnapshotVersion, DataInputView in, ClassLoader userCodeClassLoader) throws IOException {
        this.supportsPreviousTimestamp = readOuterSnapshotVersion < 2 ? false : in.readBoolean();
    }

    protected void writeOuterSnapshot(DataOutputView out) throws IOException {
        out.writeBoolean(this.supportsPreviousTimestamp);
    }

    protected CompositeTypeSerializerSnapshot.OuterSchemaCompatibility resolveOuterSchemaCompatibility(NFAStateSerializer newSerializer) {
        if (this.supportsPreviousTimestamp != newSerializer.isSupportsPreviousTimestamp()) {
            return CompositeTypeSerializerSnapshot.OuterSchemaCompatibility.COMPATIBLE_AFTER_MIGRATION;
        }
        return CompositeTypeSerializerSnapshot.OuterSchemaCompatibility.COMPATIBLE_AS_IS;
    }

    protected TypeSerializer<?>[] getNestedSerializers(NFAStateSerializer outerSerializer) {
        TypeSerializer<DeweyNumber> versionSerializer = outerSerializer.getVersionSerializer();
        TypeSerializer<NodeId> nodeIdSerializer = outerSerializer.getNodeIdSerializer();
        TypeSerializer<EventId> eventIdSerializer = outerSerializer.getEventIdSerializer();
        return new TypeSerializer[]{versionSerializer, nodeIdSerializer, eventIdSerializer};
    }

    protected NFAStateSerializer createOuterSerializerWithNestedSerializers(TypeSerializer<?>[] nestedSerializers) {
        TypeSerializer<?> versionSerializer = nestedSerializers[0];
        TypeSerializer<?> nodeIdSerializer = nestedSerializers[1];
        TypeSerializer<?> eventIdSerializer = nestedSerializers[2];
        return new NFAStateSerializer(versionSerializer, nodeIdSerializer, eventIdSerializer, this.supportsPreviousTimestamp);
    }
}

