/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.i18n;

import flex2.compiler.Source;
import flex2.compiler.SymbolTable;
import flex2.compiler.common.CompilerConfiguration;
import flex2.compiler.i18n.ClassReference;
import flex2.compiler.io.ResourceFile;
import flex2.compiler.mxml.lang.StandardDefs;
import flex2.compiler.mxml.rep.AtEmbed;
import flex2.compiler.util.CompilerMessage;
import flex2.compiler.util.OrderedProperties;
import flex2.compiler.util.ThreadLocalToolkit;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class PropertyText
extends OrderedProperties {
    private static final long serialVersionUID = -4748416824610507873L;
    public static final String CLASS_REFERENCE = "ClassReference(";
    public static final String EMBED = "Embed(";
    private boolean flex2Compatible;
    private SymbolTable symbolTable;
    private Source source;
    private String locale;
    Set<String> imports;
    Map<String, AtEmbed> atEmbeds;

    public PropertyText(CompilerConfiguration configuration, SymbolTable symbolTable, Source source, String locale, StandardDefs standardDefs) {
        this.symbolTable = symbolTable;
        this.source = source;
        this.locale = locale;
        this.imports = new HashSet<String>();
        this.atEmbeds = new HashMap<String, AtEmbed>();
        this.imports.add(standardDefs.CLASS_RESOURCEBUNDLE_DOT);
        int version = configuration.getCompatibilityVersion();
        this.flex2Compatible = version < 0x3000000;
    }

    public void load(Reader reader) throws IOException {
        super.load(reader);
        for (String string : this.keySet()) {
            String value = this.getProperty(string);
            Object valueObject = value.startsWith(CLASS_REFERENCE) ? this.processClassReference(string, value) : (value.startsWith(EMBED) ? this.processEmbed(string, value) : value);
            if (valueObject == null) continue;
            this.put(string, valueObject);
        }
    }

    protected String getTerminators() {
        return this.flex2Compatible ? "=" : super.getTerminators();
    }

    protected String removeBadChars(String propLine, String string, boolean isValue) {
        if (this.flex2Compatible) {
            string = PropertyText.removeBadChars(propLine, string, "\\n");
            string = PropertyText.removeBadChars(propLine, string, "\\r");
            if (isValue && !string.startsWith(CLASS_REFERENCE) && !string.startsWith(EMBED)) {
                string = PropertyText.removeBadChars(propLine, string, "\"");
            }
        }
        return string;
    }

    private static String removeBadChars(String propLine, String str, String bad) {
        boolean ignore;
        int index = str.indexOf(bad);
        boolean bl = ignore = index != 0 && str.regionMatches(index - 1, "\\", 0, 1);
        if (index == -1) {
            return str;
        }
        StringBuilder buf = new StringBuilder(str.length());
        int lastIndex = 0;
        boolean errorMessage = false;
        while (index != -1) {
            buf.append(str.substring(lastIndex, index));
            if (ignore) {
                buf.append(bad);
            } else if (!errorMessage) {
                errorMessage = true;
                ThreadLocalToolkit.log(new OrderedProperties.RemovedFromProperty(bad, propLine));
            }
            lastIndex = index + bad.length();
            index = str.indexOf(bad, lastIndex);
            ignore = index != 0 && str.regionMatches(index - 1, "\\", 0, 1);
        }
        buf.append(str.substring(lastIndex));
        return buf.toString();
    }

    private ClassReference processClassReference(String key, String value) {
        ClassReference classReference = null;
        int lineNumber = (Integer)this.lines.get(key);
        String parameter = value.substring(CLASS_REFERENCE.length(), value.length() - 1).trim();
        if (parameter.charAt(0) == '\"' && parameter.indexOf(34, 1) == parameter.length() - 1) {
            parameter = parameter.substring(1, parameter.length() - 1);
            classReference = new ClassReference(parameter, lineNumber);
            this.imports.add(parameter);
        } else if (parameter.equals("null")) {
            classReference = new ClassReference(null, lineNumber);
        } else {
            InvalidClassReference invalidClassReference = new InvalidClassReference();
            invalidClassReference.path = this.getPropertyFileName();
            invalidClassReference.line = lineNumber;
            ThreadLocalToolkit.log(invalidClassReference);
        }
        return classReference;
    }

    private AtEmbed processEmbed(String key, String value) {
        int lineNumber = (Integer)this.lines.get(key);
        String propertiesPath = this.getPropertyFileName();
        AtEmbed atEmbed = AtEmbed.create(this.symbolTable.perCompileData, this.source, value, propertiesPath, lineNumber, "_embed_properties_");
        if (atEmbed != null) {
            this.atEmbeds.put(atEmbed.getPropName(), atEmbed);
        }
        return atEmbed;
    }

    private String getPropertyFileName() {
        ResourceFile f = (ResourceFile)this.source.getBackingFile();
        f.setLocale(this.locale);
        return f.getNameForReporting();
    }

    public static class InvalidClassReference
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = -1168616929938888558L;
    }
}

