/*
 * Decompiled with CFR 0.152.
 */
package macromedia.abc;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class BytecodeBuffer {
    private byte[] bytecodes;
    private int pos;
    private int size;

    public BytecodeBuffer(byte[] bytecodes) {
        this.bytecodes = bytecodes;
        this.size = bytecodes.length;
        this.pos = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BytecodeBuffer(String filename) throws IOException {
        BufferedInputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(filename));
            this.bytecodes = new byte[in.available()];
            in.read(this.bytecodes);
            this.size = this.bytecodes.length;
            this.pos = 0;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public BytecodeBuffer(int preferredSize) {
        preferredSize = preferredSize <= 0 ? 1000 : preferredSize;
        this.bytecodes = new byte[preferredSize];
        this.size = 0;
        this.pos = 0;
    }

    public void clear() {
        this.pos = 0;
        this.size = 0;
    }

    public int pos() {
        return this.pos;
    }

    public int size() {
        return this.size;
    }

    public void delete(int count) {
        this.size -= count;
    }

    public void writeS8(int v) {
        this.writeU8(v);
    }

    public void writeU8(int v) {
        this.resize(1);
        this.bytecodes[this.size++] = (byte)v;
    }

    public void writeU8(int pos, int v) {
        this.bytecodes[pos] = (byte)v;
    }

    public void writeU16(int v) {
        this.resize(2);
        this.bytecodes[this.size++] = (byte)v;
        this.bytecodes[this.size++] = (byte)(v >> 8);
    }

    public void writeS24(int v) {
        this.writeU24(v);
    }

    public void writeS24(int pos, int v) {
        this.bytecodes[pos] = (byte)v;
        this.bytecodes[pos + 1] = (byte)(v >> 8);
        this.bytecodes[pos + 2] = (byte)(v >> 16);
    }

    public void writeU24(int v) {
        this.resize(3);
        this.bytecodes[this.size++] = (byte)v;
        this.bytecodes[this.size++] = (byte)(v >> 8);
        this.bytecodes[this.size++] = (byte)(v >> 16);
    }

    public void writeU32(long v) {
        if (v < 128L && v > -1L) {
            this.resize(1);
            this.bytecodes[this.size++] = (byte)v;
        } else if (v < 16384L && v > -1L) {
            this.resize(2);
            this.bytecodes[this.size++] = (byte)(v & 0x7FL | 0x80L);
            this.bytecodes[this.size++] = (byte)(v >> 7 & 0x7FL);
        } else if (v < 0x200000L && v > -1L) {
            this.resize(3);
            this.bytecodes[this.size++] = (byte)(v & 0x7FL | 0x80L);
            this.bytecodes[this.size++] = (byte)(v >> 7 | 0x80L);
            this.bytecodes[this.size++] = (byte)(v >> 14 & 0x7FL);
        } else if (v < 0x10000000L && v > -1L) {
            this.resize(4);
            this.bytecodes[this.size++] = (byte)(v & 0x7FL | 0x80L);
            this.bytecodes[this.size++] = (byte)(v >> 7 | 0x80L);
            this.bytecodes[this.size++] = (byte)(v >> 14 | 0x80L);
            this.bytecodes[this.size++] = (byte)(v >> 21 & 0x7FL);
        } else {
            this.resize(5);
            this.bytecodes[this.size++] = (byte)(v & 0x7FL | 0x80L);
            this.bytecodes[this.size++] = (byte)(v >> 7 | 0x80L);
            this.bytecodes[this.size++] = (byte)(v >> 14 | 0x80L);
            this.bytecodes[this.size++] = (byte)(v >> 21 | 0x80L);
            this.bytecodes[this.size++] = (byte)(v >> 28 & 0xFL);
        }
    }

    public void writeDouble(double v) {
        this.resize(8);
        long bits = Double.doubleToLongBits(v);
        this.bytecodes[this.size++] = (byte)bits;
        this.bytecodes[this.size++] = (byte)(bits >> 8);
        this.bytecodes[this.size++] = (byte)(bits >> 16);
        this.bytecodes[this.size++] = (byte)(bits >> 24);
        this.bytecodes[this.size++] = (byte)(bits >> 32);
        this.bytecodes[this.size++] = (byte)(bits >> 40);
        this.bytecodes[this.size++] = (byte)(bits >> 48);
        this.bytecodes[this.size++] = (byte)(bits >> 56);
    }

    public void writeBytes(BytecodeBuffer b, int start, int end) {
        this.resize(end - start);
        for (int i = start; i < end; ++i) {
            this.bytecodes[this.size++] = b.bytecodes[i];
        }
    }

    private void resize(int increment) {
        if (this.size + increment > this.bytecodes.length) {
            byte[] temp = new byte[this.bytecodes.length * 3 / 2 + 1];
            System.arraycopy(this.bytecodes, 0, temp, 0, this.bytecodes.length);
            this.bytecodes = temp;
        }
    }

    public int readU8() {
        int value = this.bytecodes[this.pos] & 0xFF;
        ++this.pos;
        return value;
    }

    public int readU8(int pos) {
        return this.bytecodes[pos] & 0xFF;
    }

    public int readU16() {
        return this.readU8() | this.readU8() << 8;
    }

    public int readU32() {
        int result = this.readU8();
        if (0 == (result & 0x80)) {
            return result;
        }
        if (0 == ((result = result & 0x7F | this.readU8() << 7) & 0x4000)) {
            return result;
        }
        if (0 == ((result = result & 0x3FFF | this.readU8() << 14) & 0x200000)) {
            return result;
        }
        if (0 == ((result = result & 0x1FFFFF | this.readU8() << 21) & 0x10000000)) {
            return result;
        }
        return result & 0xFFFFFFF | this.readU8() << 28;
    }

    public long readU32(int pos) {
        int result;
        if (0 == ((result = this.readU8(pos++)) & 0x80)) {
            return result;
        }
        if (0 == ((result = result & 0x7F | this.readU8(pos++) << 7) & 0x4000)) {
            return result;
        }
        if (0 == ((result = result & 0x3FFF | this.readU8(pos++) << 14) & 0x200000)) {
            return result;
        }
        if (0 == ((result = result & 0x1FFFFF | this.readU8(pos++) << 21) & 0x10000000)) {
            return result;
        }
        return result & 0xFFFFFFF | this.readU8(pos++) << 28;
    }

    public int readS8() {
        byte value = this.bytecodes[this.pos];
        ++this.pos;
        return value;
    }

    public int readS24() {
        return this.readU8() | this.readU8() << 8 | this.readS8() << 16;
    }

    public double readDouble() {
        long first = this.readU8() | this.readU8() << 8 | this.readU8() << 16 | this.readU8() << 24;
        long second = this.readU8() | this.readU8() << 8 | this.readU8() << 16 | this.readU8() << 24;
        return Double.longBitsToDouble(first & 0xFFFFFFFFL | second << 32);
    }

    public byte[] readBytes(int length) {
        byte[] bytes = new byte[length];
        System.arraycopy(this.bytecodes, this.pos, bytes, 0, length);
        this.pos += length;
        return bytes;
    }

    public String readString(int length) {
        try {
            return new String(this.bytecodes, this.pos, length, "UTF8");
        }
        catch (UnsupportedEncodingException ex) {
            return null;
        }
    }

    public void close() {
        this.pos = 0;
    }

    public void skip(long length) {
        this.pos = (int)((long)this.pos + length);
    }

    public void skipEntries(long entries) {
        for (long i = 0L; i < entries; ++i) {
            this.readU32();
        }
    }

    public void seek(int pos) {
        this.pos = pos;
    }

    public boolean same(BytecodeBuffer b, int start1, int end1, int start2, int end2) {
        if (end1 - start1 != end2 - start2) {
            return false;
        }
        int i = start1;
        int j = start2;
        while (i < end1) {
            if (this.bytecodes[i] != b.bytecodes[j]) {
                return false;
            }
            ++i;
            ++j;
        }
        return true;
    }

    public int hashCode(int start, int end) {
        long hash = 1234L;
        for (int j = start; j < end; ++j) {
            hash ^= (long)this.bytecodes[j];
        }
        return (int)(hash >> 32 ^ hash);
    }

    public void writeTo(OutputStream out) throws IOException {
        out.write(this.bytecodes, 0, this.size);
    }

    public int minorVersion() {
        return this.bytecodes[0] & 0xFF | (this.bytecodes[1] & 0xFF) << 8;
    }
}

