/*
 * Decompiled with CFR 0.152.
 */
package macromedia.abc;

import java.util.HashSet;
import macromedia.abc.BytecodeBuffer;
import macromedia.abc.ConstantPool;
import macromedia.abc.DecoderException;
import macromedia.abc.Scanner;
import macromedia.abc.Visitor;

public final class Decoder {
    public final int minorVersion;
    public final int majorVersion;
    public final ConstantPool constantPool;
    public final MethodInfo methodInfo;
    public final MetaDataInfo metadataInfo;
    public final ClassInfo classInfo;
    public final ScriptInfo scriptInfo;
    public final MethodBodies methodBodies;
    public final Opcodes opcodes;
    private final BytecodeBuffer in;

    public Decoder(BytecodeBuffer in) throws DecoderException {
        this.minorVersion = in.readU16();
        this.majorVersion = in.readU16();
        this.constantPool = new ConstantPool(in, this.minorVersion >= 17);
        int pos = in.pos();
        this.methodInfo = new MethodInfo(in);
        this.methodInfo.estimatedSize = in.pos() - pos;
        pos = in.pos();
        this.metadataInfo = new MetaDataInfo(in);
        this.metadataInfo.estimatedSize = in.pos() - pos;
        pos = in.pos();
        this.classInfo = new ClassInfo(in);
        this.classInfo.estimatedSize = in.pos() - pos;
        pos = in.pos();
        this.scriptInfo = new ScriptInfo(in);
        this.scriptInfo.estimatedSize = in.pos() - pos;
        pos = in.pos();
        this.methodBodies = new MethodBodies(in);
        this.methodBodies.estimatedSize = in.pos() - pos;
        this.opcodes = new Opcodes(in);
        this.in = in;
    }

    public int pos() {
        return this.in.pos();
    }

    public class Opcodes {
        BytecodeBuffer in;
        private HashSet<Integer> targetSet;

        public Opcodes(BytecodeBuffer in) {
            this.in = in;
        }

        public void addTarget(int pos) {
            if (this.targetSet == null) {
                this.targetSet = new HashSet();
            }
            this.targetSet.add(pos);
        }

        public void reset() {
            this.targetSet = null;
        }

        public void decode(int start, long length, int passes, Visitor v) throws DecoderException {
            for (int i = 0; i < passes; ++i) {
                this.decode(start, length, v);
            }
        }

        public void decode(int start, long length, Visitor v) throws DecoderException {
            int originalPos = this.in.pos();
            this.in.seek(start);
            long end = (long)start + length;
            block184: while ((long)this.in.pos() < end) {
                int pos = this.in.pos();
                int opcode = this.in.readU8();
                if (opcode == 9) {
                    this.addTarget(pos);
                }
                if (this.targetSet != null && this.targetSet.contains(pos)) {
                    v.target(pos);
                }
                switch (opcode) {
                    case 12: {
                        int offset = this.in.readS24();
                        this.addTarget(offset + this.in.pos());
                        v.OP_ifnlt(offset, this.in.pos());
                        continue block184;
                    }
                    case 13: {
                        int offset = this.in.readS24();
                        this.addTarget(offset + this.in.pos());
                        v.OP_ifnle(offset, this.in.pos());
                        continue block184;
                    }
                    case 14: {
                        int offset = this.in.readS24();
                        this.addTarget(offset + this.in.pos());
                        v.OP_ifngt(offset, this.in.pos());
                        continue block184;
                    }
                    case 15: {
                        int offset = this.in.readS24();
                        this.addTarget(offset + this.in.pos());
                        v.OP_ifnge(offset, this.in.pos());
                        continue block184;
                    }
                    case 48: {
                        v.OP_pushscope();
                        continue block184;
                    }
                    case 87: {
                        v.OP_newactivation();
                        continue block184;
                    }
                    case 90: {
                        int index = this.in.readU32();
                        v.OP_newcatch(index);
                        continue block184;
                    }
                    case 91: {
                        v.OP_deldescendants();
                        continue block184;
                    }
                    case 100: {
                        v.OP_getglobalscope();
                        continue block184;
                    }
                    case 208: {
                        v.OP_getlocal0();
                        continue block184;
                    }
                    case 209: {
                        v.OP_getlocal1();
                        continue block184;
                    }
                    case 210: {
                        v.OP_getlocal2();
                        continue block184;
                    }
                    case 211: {
                        v.OP_getlocal3();
                        continue block184;
                    }
                    case 212: {
                        v.OP_setlocal0();
                        continue block184;
                    }
                    case 213: {
                        v.OP_setlocal1();
                        continue block184;
                    }
                    case 214: {
                        v.OP_setlocal2();
                        continue block184;
                    }
                    case 215: {
                        v.OP_setlocal3();
                        continue block184;
                    }
                    case 71: {
                        v.OP_returnvoid();
                        continue block184;
                    }
                    case 72: {
                        v.OP_returnvalue();
                        continue block184;
                    }
                    case 2: {
                        v.OP_nop();
                        continue block184;
                    }
                    case 1: {
                        v.OP_bkpt();
                        continue block184;
                    }
                    case 243: {
                        v.OP_timestamp();
                        continue block184;
                    }
                    case 240: {
                        int linenum = this.in.readU32();
                        v.OP_debugline(linenum);
                        continue block184;
                    }
                    case 242: {
                        this.in.readU32();
                        v.OP_bkptline();
                        continue block184;
                    }
                    case 239: {
                        int di_local = this.in.readU8();
                        int index = this.in.readU32();
                        int slot = this.in.readU8();
                        int linenum = this.in.readU32();
                        v.OP_debug(di_local, index, slot, linenum);
                        continue block184;
                    }
                    case 241: {
                        int index = this.in.readU32();
                        v.OP_debugfile(index);
                        continue block184;
                    }
                    case 16: {
                        int jump = this.in.readS24();
                        this.addTarget(jump + this.in.pos());
                        v.OP_jump(jump, this.in.pos());
                        continue block184;
                    }
                    case 32: {
                        v.OP_pushnull();
                        continue block184;
                    }
                    case 33: {
                        v.OP_pushundefined();
                        continue block184;
                    }
                    case 44: {
                        int index = this.in.readU32();
                        v.OP_pushstring(index);
                        continue block184;
                    }
                    case 49: {
                        int index = this.in.readU32();
                        v.OP_pushnamespace(index);
                        continue block184;
                    }
                    case 45: {
                        int index = this.in.readU32();
                        v.OP_pushint(index);
                        continue block184;
                    }
                    case 46: {
                        int index = this.in.readU32();
                        v.OP_pushuint(index);
                        continue block184;
                    }
                    case 47: {
                        int index = this.in.readU32();
                        v.OP_pushdouble(index);
                        continue block184;
                    }
                    case 51: {
                        int index = this.in.readU32();
                        v.OP_pushdecimal(index);
                        continue block184;
                    }
                    case 98: {
                        int index = this.in.readU32();
                        v.OP_getlocal(index);
                        continue block184;
                    }
                    case 38: {
                        v.OP_pushtrue();
                        continue block184;
                    }
                    case 39: {
                        v.OP_pushfalse();
                        continue block184;
                    }
                    case 40: {
                        v.OP_pushnan();
                        continue block184;
                    }
                    case 52: {
                        v.OP_pushdnan();
                        continue block184;
                    }
                    case 41: {
                        v.OP_pop();
                        continue block184;
                    }
                    case 42: {
                        v.OP_dup();
                        continue block184;
                    }
                    case 43: {
                        v.OP_swap();
                        continue block184;
                    }
                    case 112: {
                        v.OP_convert_s();
                        continue block184;
                    }
                    case 113: {
                        v.OP_esc_xelem();
                        continue block184;
                    }
                    case 114: {
                        v.OP_esc_xattr();
                        continue block184;
                    }
                    case 120: {
                        v.OP_checkfilter();
                        continue block184;
                    }
                    case 117: {
                        v.OP_convert_d();
                        continue block184;
                    }
                    case 118: {
                        v.OP_convert_b();
                        continue block184;
                    }
                    case 119: {
                        v.OP_convert_o();
                        continue block184;
                    }
                    case 121: {
                        v.OP_convert_m();
                        continue block184;
                    }
                    case 122: {
                        int param = this.in.readU32();
                        v.OP_convert_m_p(param);
                        continue block184;
                    }
                    case 144: {
                        v.OP_negate();
                        continue block184;
                    }
                    case 143: {
                        int param = this.in.readU32();
                        v.OP_negate_p(param);
                        continue block184;
                    }
                    case 196: {
                        v.OP_negate_i();
                        continue block184;
                    }
                    case 145: {
                        v.OP_increment();
                        continue block184;
                    }
                    case 156: {
                        int param = this.in.readU32();
                        v.OP_increment_p(param);
                        continue block184;
                    }
                    case 192: {
                        v.OP_increment_i();
                        continue block184;
                    }
                    case 146: {
                        int index = this.in.readU32();
                        v.OP_inclocal(index);
                        continue block184;
                    }
                    case 157: {
                        int param = this.in.readU32();
                        int index = this.in.readU32();
                        v.OP_inclocal_p(param, index);
                        continue block184;
                    }
                    case 8: {
                        int index = this.in.readU32();
                        v.OP_kill(index);
                        continue block184;
                    }
                    case 9: {
                        v.OP_label();
                        continue block184;
                    }
                    case 194: {
                        int index = this.in.readU32();
                        v.OP_inclocal_i(index);
                        continue block184;
                    }
                    case 147: {
                        v.OP_decrement();
                        continue block184;
                    }
                    case 158: {
                        int param = this.in.readU32();
                        v.OP_decrement_p(param);
                        continue block184;
                    }
                    case 193: {
                        v.OP_decrement_i();
                        continue block184;
                    }
                    case 148: {
                        int index = this.in.readU32();
                        v.OP_declocal(index);
                        continue block184;
                    }
                    case 159: {
                        int param = this.in.readU32();
                        int index = this.in.readU32();
                        v.OP_declocal_p(param, index);
                        continue block184;
                    }
                    case 195: {
                        int index = this.in.readU32();
                        v.OP_declocal_i(index);
                        continue block184;
                    }
                    case 149: {
                        v.OP_typeof();
                        continue block184;
                    }
                    case 150: {
                        v.OP_not();
                        continue block184;
                    }
                    case 151: {
                        v.OP_bitnot();
                        continue block184;
                    }
                    case 99: {
                        int index = this.in.readU32();
                        v.OP_setlocal(index);
                        continue block184;
                    }
                    case 160: {
                        v.OP_add();
                        continue block184;
                    }
                    case 181: {
                        int param = this.in.readU32();
                        v.OP_add_p(param);
                        continue block184;
                    }
                    case 197: {
                        v.OP_add_i();
                        continue block184;
                    }
                    case 161: {
                        v.OP_subtract();
                        continue block184;
                    }
                    case 182: {
                        int param = this.in.readU32();
                        v.OP_subtract_p(param);
                        continue block184;
                    }
                    case 198: {
                        v.OP_subtract_i();
                        continue block184;
                    }
                    case 162: {
                        v.OP_multiply();
                        continue block184;
                    }
                    case 183: {
                        int param = this.in.readU32();
                        v.OP_multiply_p(param);
                        continue block184;
                    }
                    case 199: {
                        v.OP_multiply_i();
                        continue block184;
                    }
                    case 163: {
                        v.OP_divide();
                        continue block184;
                    }
                    case 184: {
                        int param = this.in.readU32();
                        v.OP_divide_p(param);
                        continue block184;
                    }
                    case 164: {
                        v.OP_modulo();
                        continue block184;
                    }
                    case 185: {
                        int param = this.in.readU32();
                        v.OP_modulo_p(param);
                        continue block184;
                    }
                    case 165: {
                        v.OP_lshift();
                        continue block184;
                    }
                    case 166: {
                        v.OP_rshift();
                        continue block184;
                    }
                    case 167: {
                        v.OP_urshift();
                        continue block184;
                    }
                    case 168: {
                        v.OP_bitand();
                        continue block184;
                    }
                    case 169: {
                        v.OP_bitor();
                        continue block184;
                    }
                    case 170: {
                        v.OP_bitxor();
                        continue block184;
                    }
                    case 171: {
                        v.OP_equals();
                        continue block184;
                    }
                    case 172: {
                        v.OP_strictequals();
                        continue block184;
                    }
                    case 27: {
                        int opPos = this.in.pos() - 1;
                        int defaultPos = this.in.readS24();
                        this.addTarget(defaultPos + opPos);
                        int size_1 = this.in.readU32();
                        int[] casePos = new int[size_1 + 1];
                        int caseTablePos = this.in.pos();
                        int size = casePos.length;
                        for (int i = 0; i < size; ++i) {
                            casePos[i] = this.in.readS24();
                            this.addTarget(casePos[i] + opPos);
                        }
                        v.OP_lookupswitch(defaultPos, casePos, opPos, caseTablePos);
                        continue block184;
                    }
                    case 17: {
                        int offset = this.in.readS24();
                        this.addTarget(offset + this.in.pos());
                        v.OP_iftrue(offset, this.in.pos());
                        continue block184;
                    }
                    case 18: {
                        int offset = this.in.readS24();
                        this.addTarget(offset + this.in.pos());
                        v.OP_iffalse(offset, this.in.pos());
                        continue block184;
                    }
                    case 19: {
                        int offset = this.in.readS24();
                        this.addTarget(offset + this.in.pos());
                        v.OP_ifeq(offset, this.in.pos());
                        continue block184;
                    }
                    case 20: {
                        int offset = this.in.readS24();
                        this.addTarget(offset + this.in.pos());
                        v.OP_ifne(offset, this.in.pos());
                        continue block184;
                    }
                    case 25: {
                        int offset = this.in.readS24();
                        this.addTarget(offset + this.in.pos());
                        v.OP_ifstricteq(offset, this.in.pos());
                        continue block184;
                    }
                    case 26: {
                        int offset = this.in.readS24();
                        this.addTarget(offset + this.in.pos());
                        v.OP_ifstrictne(offset, this.in.pos());
                        continue block184;
                    }
                    case 21: {
                        int offset = this.in.readS24();
                        this.addTarget(offset + this.in.pos());
                        v.OP_iflt(offset, this.in.pos());
                        continue block184;
                    }
                    case 22: {
                        int offset = this.in.readS24();
                        this.addTarget(offset + this.in.pos());
                        v.OP_ifle(offset, this.in.pos());
                        continue block184;
                    }
                    case 23: {
                        int offset = this.in.readS24();
                        this.addTarget(offset + this.in.pos());
                        v.OP_ifgt(offset, this.in.pos());
                        continue block184;
                    }
                    case 24: {
                        int offset = this.in.readS24();
                        this.addTarget(offset + this.in.pos());
                        v.OP_ifge(offset, this.in.pos());
                        continue block184;
                    }
                    case 173: {
                        v.OP_lessthan();
                        continue block184;
                    }
                    case 174: {
                        v.OP_lessequals();
                        continue block184;
                    }
                    case 175: {
                        v.OP_greaterthan();
                        continue block184;
                    }
                    case 176: {
                        v.OP_greaterequals();
                        continue block184;
                    }
                    case 85: {
                        int size = this.in.readU32();
                        v.OP_newobject(size);
                        continue block184;
                    }
                    case 86: {
                        int size = this.in.readU32();
                        v.OP_newarray(size);
                        continue block184;
                    }
                    case 102: {
                        int index = this.in.readU32();
                        v.OP_getproperty(index);
                        continue block184;
                    }
                    case 97: {
                        int index = this.in.readU32();
                        v.OP_setproperty(index);
                        continue block184;
                    }
                    case 104: {
                        int index = this.in.readU32();
                        v.OP_initproperty(index);
                        continue block184;
                    }
                    case 89: {
                        int index = this.in.readU32();
                        v.OP_getdescendants(index);
                        continue block184;
                    }
                    case 93: {
                        int index = this.in.readU32();
                        v.OP_findpropstrict(index);
                        continue block184;
                    }
                    case 96: {
                        int index = this.in.readU32();
                        v.OP_getlex(index);
                        continue block184;
                    }
                    case 94: {
                        int index = this.in.readU32();
                        v.OP_findproperty(index);
                        continue block184;
                    }
                    case 95: {
                        int index = this.in.readU32();
                        v.OP_finddef(index);
                        continue block184;
                    }
                    case 30: {
                        v.OP_nextname();
                        continue block184;
                    }
                    case 35: {
                        v.OP_nextvalue();
                        continue block184;
                    }
                    case 31: {
                        v.OP_hasnext();
                        continue block184;
                    }
                    case 50: {
                        int objectRegister = this.in.readU32();
                        int indexRegister = this.in.readU32();
                        v.OP_hasnext2(objectRegister, indexRegister);
                        continue block184;
                    }
                    case 106: {
                        int index = this.in.readU32();
                        v.OP_deleteproperty(index);
                        continue block184;
                    }
                    case 109: {
                        int index = this.in.readU32();
                        v.OP_setslot(index);
                        continue block184;
                    }
                    case 108: {
                        int index = this.in.readU32();
                        v.OP_getslot(index);
                        continue block184;
                    }
                    case 111: {
                        int index = this.in.readU32();
                        v.OP_setglobalslot(index);
                        continue block184;
                    }
                    case 110: {
                        int index = this.in.readU32();
                        v.OP_getglobalslot(index);
                        continue block184;
                    }
                    case 65: {
                        int size = this.in.readU32();
                        v.OP_call(size);
                        continue block184;
                    }
                    case 66: {
                        int size = this.in.readU32();
                        v.OP_construct(size);
                        continue block184;
                    }
                    case 83: {
                        int size = this.in.readU32();
                        v.OP_applytype(size);
                        continue block184;
                    }
                    case 64: {
                        int id = this.in.readU32();
                        v.OP_newfunction(id);
                        continue block184;
                    }
                    case 88: {
                        int id = this.in.readU32();
                        v.OP_newclass(id);
                        continue block184;
                    }
                    case 68: {
                        int id = this.in.readU32();
                        int argc = this.in.readU32();
                        v.OP_callstatic(id, argc);
                        continue block184;
                    }
                    case 67: {
                        int id = this.in.readU32();
                        int argc = this.in.readU32();
                        v.OP_callmethod(id, argc);
                        continue block184;
                    }
                    case 70: {
                        int index = this.in.readU32();
                        int argc = this.in.readU32();
                        v.OP_callproperty(index, argc);
                        continue block184;
                    }
                    case 76: {
                        int index = this.in.readU32();
                        int argc = this.in.readU32();
                        v.OP_callproplex(index, argc);
                        continue block184;
                    }
                    case 74: {
                        int index = this.in.readU32();
                        int argc = this.in.readU32();
                        v.OP_constructprop(index, argc);
                        continue block184;
                    }
                    case 69: {
                        int index = this.in.readU32();
                        int argc = this.in.readU32();
                        v.OP_callsuper(index, argc);
                        continue block184;
                    }
                    case 4: {
                        int index = this.in.readU32();
                        v.OP_getsuper(index);
                        continue block184;
                    }
                    case 5: {
                        int index = this.in.readU32();
                        v.OP_setsuper(index);
                        continue block184;
                    }
                    case 73: {
                        int argc = this.in.readU32();
                        v.OP_constructsuper(argc);
                        continue block184;
                    }
                    case 37: {
                        int n = this.in.readU32();
                        v.OP_pushshort(n);
                        continue block184;
                    }
                    case 134: {
                        int index = this.in.readU32();
                        v.OP_astype(index);
                        continue block184;
                    }
                    case 135: {
                        v.OP_astypelate();
                        continue block184;
                    }
                    case 128: {
                        int index = this.in.readU32();
                        v.OP_coerce(index);
                        continue block184;
                    }
                    case 129: {
                        v.OP_coerce_b();
                        continue block184;
                    }
                    case 137: {
                        v.OP_coerce_o();
                        continue block184;
                    }
                    case 130: {
                        v.OP_coerce_a();
                        continue block184;
                    }
                    case 131: {
                        v.OP_coerce_i();
                        continue block184;
                    }
                    case 136: {
                        v.OP_coerce_u();
                        continue block184;
                    }
                    case 132: {
                        v.OP_coerce_d();
                        continue block184;
                    }
                    case 133: {
                        v.OP_coerce_s();
                        continue block184;
                    }
                    case 178: {
                        int index = this.in.readU32();
                        v.OP_istype(index);
                        continue block184;
                    }
                    case 179: {
                        v.OP_istypelate();
                        continue block184;
                    }
                    case 36: {
                        int n = this.in.readU8();
                        v.OP_pushbyte(n);
                        continue block184;
                    }
                    case 101: {
                        int index = this.in.readU8();
                        v.OP_getscopeobject(index);
                        continue block184;
                    }
                    case 28: {
                        v.OP_pushwith();
                        continue block184;
                    }
                    case 29: {
                        v.OP_popscope();
                        continue block184;
                    }
                    case 115: {
                        v.OP_convert_i();
                        continue block184;
                    }
                    case 116: {
                        v.OP_convert_u();
                        continue block184;
                    }
                    case 3: {
                        v.OP_throw();
                        continue block184;
                    }
                    case 177: {
                        v.OP_instanceof();
                        continue block184;
                    }
                    case 180: {
                        v.OP_in();
                        continue block184;
                    }
                    case 6: {
                        int index = this.in.readU32();
                        v.OP_dxns(index);
                        continue block184;
                    }
                    case 7: {
                        v.OP_dxnslate();
                        continue block184;
                    }
                    case 34: {
                        int id = this.in.readU32();
                        v.OP_pushconstant(id);
                        continue block184;
                    }
                    case 78: {
                        int index = this.in.readU32();
                        int argc = this.in.readU32();
                        v.OP_callsupervoid(index, argc);
                        continue block184;
                    }
                    case 79: {
                        int index = this.in.readU32();
                        int argc = this.in.readU32();
                        v.OP_callpropvoid(index, argc);
                        continue block184;
                    }
                    case 53: {
                        v.OP_li8();
                        continue block184;
                    }
                    case 54: {
                        v.OP_li16();
                        continue block184;
                    }
                    case 55: {
                        v.OP_li32();
                        continue block184;
                    }
                    case 56: {
                        v.OP_lf32();
                        continue block184;
                    }
                    case 57: {
                        v.OP_lf64();
                        continue block184;
                    }
                    case 58: {
                        v.OP_si8();
                        continue block184;
                    }
                    case 59: {
                        v.OP_si16();
                        continue block184;
                    }
                    case 60: {
                        v.OP_si32();
                        continue block184;
                    }
                    case 61: {
                        v.OP_sf32();
                        continue block184;
                    }
                    case 62: {
                        v.OP_sf64();
                        continue block184;
                    }
                    case 80: {
                        v.OP_sxi1();
                        continue block184;
                    }
                    case 81: {
                        v.OP_sxi8();
                        continue block184;
                    }
                    case 82: {
                        v.OP_sxi16();
                        continue block184;
                    }
                }
                throw new DecoderException("unknown opcode?? " + opcode);
            }
            this.in.seek(originalPos);
        }
    }

    class Traits {
        BytecodeBuffer in;

        Traits(BytecodeBuffer in) {
            this.in = in;
        }

        void decode(Visitor visitor) throws DecoderException {
            int count = this.in.readU32();
            visitor.traitCount(count);
            block6: for (int i = 0; i < count; ++i) {
                int name = this.in.readU32();
                int kind = this.in.readU8();
                int value_kind = 0;
                switch (kind & 0xF) {
                    case 0: 
                    case 6: {
                        int slotID = this.in.readU32();
                        int typeID = this.in.readU32();
                        int valueID = this.in.readU32();
                        if (valueID != 0) {
                            value_kind = this.in.readU8();
                        }
                        visitor.slotTrait(kind, name, slotID, typeID, valueID, value_kind, this.decodeMetaData(kind));
                        continue block6;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        int dispID = this.in.readU32();
                        int methInfo = this.in.readU32();
                        visitor.methodTrait(kind, name, dispID, methInfo, this.decodeMetaData(kind));
                        continue block6;
                    }
                    case 4: {
                        int slotID = this.in.readU32();
                        int classID = this.in.readU32();
                        visitor.classTrait(kind, name, slotID, classID, this.decodeMetaData(kind));
                        continue block6;
                    }
                    case 5: {
                        int slotID = this.in.readU32();
                        int methInfo = this.in.readU32();
                        visitor.functionTrait(kind, name, slotID, methInfo, this.decodeMetaData(kind));
                        continue block6;
                    }
                }
            }
        }

        private int[] decodeMetaData(int kind) {
            int length;
            int[] md = null;
            if ((kind >> 4 & 4) != 0 && (length = this.in.readU32()) > 0) {
                md = new int[length];
                for (int i = 0; i < length; ++i) {
                    md[i] = this.in.readU32();
                }
            }
            return md;
        }
    }

    public final class MethodBodies {
        BytecodeBuffer in;
        int estimatedSize;
        private int[] positions;
        private Traits traits;

        MethodBodies(BytecodeBuffer in) {
            this(in, Scanner.scanMethodBodies(in));
        }

        MethodBodies(BytecodeBuffer in, int[] positions) {
            this.in = in;
            this.positions = positions;
            this.traits = new Traits(in);
        }

        public int size() {
            return this.positions.length;
        }

        public void decode(int index, Visitor visitor) throws DecoderException {
            this.decode(index, 1, visitor);
        }

        public void decode(int index, int opcodePass, Visitor visitor) throws DecoderException {
            int pos = this.positions[index];
            int originalPos = this.in.pos();
            this.in.seek(pos);
            int methodInfo = this.in.readU32();
            int maxStack = this.in.readU32();
            int maxRegs = this.in.readU32();
            int scopeDepth = this.in.readU32();
            int maxScope = this.in.readU32();
            long codeLength = this.in.readU32();
            int codeStart = this.in.pos();
            this.in.skip((int)codeLength);
            visitor.startMethodBody(methodInfo, maxStack, maxRegs, scopeDepth, maxScope, codeStart, codeLength);
            int exPos = this.in.pos();
            for (int i = 0; i < opcodePass; ++i) {
                Decoder.this.opcodes.reset();
                this.in.seek(exPos);
                int exCount = this.in.readU32();
                visitor.startOpcodes(methodInfo);
                visitor.startExceptions(exCount);
                this.decodeExceptions(this.in, codeStart, visitor, exCount);
                Decoder.this.opcodes.decode(codeStart, codeLength, visitor);
                visitor.endOpcodes();
                visitor.endExceptions();
            }
            this.traits.decode(visitor);
            visitor.endMethodBody();
            this.in.seek(originalPos);
        }

        private void decodeExceptions(BytecodeBuffer in, int codeStart, Visitor visitor, int exCount) {
            boolean hasNames = in.minorVersion() != 15;
            for (int i = 0; i < exCount; ++i) {
                long start = codeStart + in.readU32();
                long end = codeStart + in.readU32();
                long target = codeStart + in.readU32();
                int type = in.readU32();
                int nameIndex = hasNames ? in.readU32() : 0;
                Decoder.this.opcodes.addTarget((int)start);
                Decoder.this.opcodes.addTarget((int)end);
                Decoder.this.opcodes.addTarget((int)target);
                visitor.exception(start, end, target, type, nameIndex);
            }
        }
    }

    public final class ScriptInfo {
        BytecodeBuffer in;
        int estimatedSize;
        private int[] positions;
        private Traits traits;

        ScriptInfo(BytecodeBuffer in) {
            this(in, Scanner.scanScripts(in));
        }

        ScriptInfo(BytecodeBuffer in, int[] positions) {
            this.in = in;
            this.positions = positions;
            this.traits = new Traits(in);
        }

        public int size() {
            return this.positions.length;
        }

        public void decode(int index, Visitor visitor) throws DecoderException {
            int pos = this.positions[index];
            int originalPos = this.in.pos();
            this.in.seek(pos);
            int initID = this.in.readU32();
            visitor.startScript(initID);
            this.traits.decode(visitor);
            visitor.endScript();
            this.in.seek(originalPos);
        }
    }

    public final class ClassInfo {
        BytecodeBuffer in;
        int estimatedSize;
        private int[] cPositions;
        private int[] iPositions;
        private Traits cTraits;
        private Traits iTraits;

        ClassInfo(BytecodeBuffer in) {
            this.in = in;
            int size = in.readU32();
            this.iPositions = Scanner.scanInstances(in, size);
            this.iTraits = new Traits(in);
            this.cPositions = Scanner.scanClasses(in, size);
            this.cTraits = new Traits(in);
        }

        public int size() {
            return this.cPositions.length;
        }

        public void decode(int index, Visitor visitor) throws DecoderException {
            int name = this.decodeInstance(index, visitor);
            this.decodeClass(index, name, visitor);
        }

        public int decodeInstance(int index, Visitor visitor) throws DecoderException {
            int pos = this.iPositions[index];
            int originalPos = this.in.pos();
            this.in.seek(pos);
            int name = this.in.readU32();
            int superName = this.in.readU32();
            int flags = this.in.readU8();
            boolean isFinal = (flags & 2) != 0;
            boolean isDynamic = (flags & 1) == 0;
            boolean isInterface = (flags & 4) != 0;
            boolean hasProtected = (flags & 8) != 0;
            int protectedNamespace = hasProtected ? this.in.readU32() : 0;
            int interfaceCount = this.in.readU32();
            int[] interfaces = new int[interfaceCount];
            if (interfaceCount > 0) {
                for (int j = 0; j < interfaceCount; ++j) {
                    interfaces[j] = this.in.readU32();
                }
            }
            int iinit = this.in.readU32();
            visitor.startInstance(name, superName, isDynamic, isFinal, isInterface, interfaces, iinit, protectedNamespace);
            this.iTraits.decode(visitor);
            visitor.endInstance();
            this.in.seek(originalPos);
            return name;
        }

        public void decodeClass(int index, int name, Visitor visitor) throws DecoderException {
            int pos = this.cPositions[index];
            int originalPos = this.in.pos();
            this.in.seek(pos);
            int cinit = this.in.readU32();
            visitor.startClass(name, cinit);
            this.cTraits.decode(visitor);
            visitor.endClass();
            this.in.seek(originalPos);
        }
    }

    public final class MetaDataInfo {
        BytecodeBuffer in;
        int estimatedSize;
        private int[] positions;

        MetaDataInfo(BytecodeBuffer in) {
            this(in, Scanner.scanMetadata(in));
        }

        MetaDataInfo(BytecodeBuffer in, int[] positions) {
            this.in = in;
            this.positions = positions;
        }

        public int size() {
            return this.positions.length;
        }

        public void decode(int index, Visitor visitor) throws DecoderException {
            int pos = this.positions[index];
            int originalPos = this.in.pos();
            this.in.seek(pos);
            int nameIndex = this.in.readU32();
            int valueCount = this.in.readU32();
            int[] keys = null;
            int[] values = null;
            if (valueCount > 0) {
                int j;
                keys = new int[valueCount];
                values = new int[valueCount];
                for (j = 0; j < valueCount; ++j) {
                    keys[j] = this.in.readU32();
                }
                for (j = 0; j < valueCount; ++j) {
                    values[j] = this.in.readU32();
                }
            }
            this.in.seek(originalPos);
            visitor.metadataInfo(index, nameIndex, keys, values);
        }
    }

    public final class MethodInfo {
        BytecodeBuffer in;
        int estimatedSize;
        private int[] positions;

        MethodInfo(BytecodeBuffer in) {
            this(in, Scanner.scanMethods(in));
        }

        MethodInfo(BytecodeBuffer in, int[] positions) {
            this.in = in;
            this.positions = positions;
        }

        public int size() {
            return this.positions.length;
        }

        public void decode(int index, Visitor visitor) throws DecoderException {
            int paramNameCount;
            int pos = this.positions[index];
            int originalPos = this.in.pos();
            this.in.seek(pos);
            int paramCount = this.in.readU32();
            int returnType = this.in.readU32();
            int[] paramTypes = null;
            if (paramCount > 0) {
                paramTypes = new int[paramCount];
                for (int j = 0; j < paramCount; ++j) {
                    paramTypes[j] = this.in.readU32();
                }
            }
            int nativeName = this.in.readU32();
            int flags = this.in.readU8();
            int optionalCount = (flags & 8) != 0 ? this.in.readU32() : 0;
            int[] values = null;
            int[] value_kinds = null;
            if (optionalCount > 0) {
                values = new int[optionalCount];
                value_kinds = new int[optionalCount];
                for (int j = 0; j < optionalCount; ++j) {
                    values[j] = this.in.readU32();
                    value_kinds[j] = this.in.readU8();
                }
            }
            int[] paramNames = null;
            int n = paramNameCount = (flags & 0x80) != 0 ? paramCount : 0;
            if (paramNameCount > 0) {
                paramNames = new int[paramNameCount];
                for (int j = 0; j < paramNameCount; ++j) {
                    paramNames[j] = this.in.readU32();
                }
            }
            this.in.seek(originalPos);
            visitor.methodInfo(returnType, paramTypes, nativeName, flags, values, value_kinds, paramNames);
        }
    }
}

