/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.mxml.builder;

import flex2.compiler.CompilationUnit;
import flex2.compiler.mxml.InvalidStateSpecificValue;
import flex2.compiler.mxml.MxmlConfiguration;
import flex2.compiler.mxml.builder.AbstractBuilder;
import flex2.compiler.mxml.dom.CDATANode;
import flex2.compiler.mxml.dom.DeclarationsNode;
import flex2.compiler.mxml.dom.DesignLayerNode;
import flex2.compiler.mxml.dom.LayeredNode;
import flex2.compiler.mxml.dom.LibraryNode;
import flex2.compiler.mxml.dom.Node;
import flex2.compiler.mxml.dom.ReparentNode;
import flex2.compiler.mxml.dom.ScriptNode;
import flex2.compiler.mxml.dom.StateNode;
import flex2.compiler.mxml.lang.AttributeHandler;
import flex2.compiler.mxml.lang.BindingHandler;
import flex2.compiler.mxml.lang.ChildNodeHandler;
import flex2.compiler.mxml.lang.NodeTypeResolver;
import flex2.compiler.mxml.lang.TextParser;
import flex2.compiler.mxml.reflect.DynamicProperty;
import flex2.compiler.mxml.reflect.Effect;
import flex2.compiler.mxml.reflect.Event;
import flex2.compiler.mxml.reflect.Property;
import flex2.compiler.mxml.reflect.Style;
import flex2.compiler.mxml.reflect.Type;
import flex2.compiler.mxml.reflect.TypeTable;
import flex2.compiler.mxml.rep.BindingExpression;
import flex2.compiler.mxml.rep.DesignLayer;
import flex2.compiler.mxml.rep.Model;
import flex2.compiler.mxml.rep.MovieClip;
import flex2.compiler.mxml.rep.MxmlDocument;
import flex2.compiler.mxml.rep.Primitive;
import flex2.compiler.mxml.rep.Reparent;
import flex2.compiler.mxml.rep.init.Initializer;
import flex2.compiler.util.CompilerMessage;
import flex2.compiler.util.NameFormatter;
import flex2.compiler.util.QName;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;

public class ComponentBuilder
extends AbstractBuilder {
    protected Model parent;
    protected boolean topLevelChild;
    private String name;
    private String state;
    protected BindingHandler bindingHandler;
    protected ComponentAttributeHandler attributeHandler;
    protected ComponentChildNodeHandler childNodeHandler;
    Model component;

    ComponentBuilder(CompilationUnit unit, TypeTable typeTable, MxmlConfiguration mxmlConfiguration, MxmlDocument document, Model parent, String name, String state, boolean topLevelChild, BindingHandler bindingHandler) {
        super(unit, typeTable, mxmlConfiguration, document);
        this.parent = parent;
        this.topLevelChild = topLevelChild;
        this.bindingHandler = bindingHandler;
        if (bindingHandler == null) {
            this.bindingHandler = new ComponentDeclarationBindingHandler();
        }
        this.name = name;
        this.state = state;
        this.attributeHandler = new ComponentAttributeHandler();
        this.childNodeHandler = new ComponentChildNodeHandler(typeTable);
    }

    public void analyze(Node node) {
        assert (this.component == null) : "ComponentBuilder.analyze(Node) called twice";
        Type type = this.nodeTypeResolver.resolveType(node, this.document);
        this.constructComponent(type, node.beginLine);
        this.component.setParentIndex(this.name, this.state);
        this.processAttributes(node, type);
        this.processChildren(node, type);
        this.registerModel(node, this.component, this.topLevelChild);
    }

    public void analyze(LayeredNode node) {
        this.analyze((Node)node);
        this.processLayerParent(node);
    }

    public void analyze(ScriptNode node) {
    }

    public void analyze(DesignLayerNode node) {
        Type type = this.nodeTypeResolver.resolveType(node, this.document);
        this.component = new DesignLayer(this.document, type, node.beginLine);
        this.processAttributes(node, type);
        this.processLayerParent(node);
        this.document.addLayerModel(node, (DesignLayer)this.component);
        if (node.getAttributeCount() > 0) {
            this.registerModel(node, this.component, true);
        }
    }

    public void analyze(ReparentNode node) {
        Type type = this.nodeTypeResolver.resolveType(node, this.document);
        String target = (String)node.getAttributeValue("target");
        this.component = new Reparent(this.document, type, this.parent, target, node.beginLine);
        this.processAttributes(node, type);
    }

    public void analyze(StateNode node) {
        Type type = this.nodeTypeResolver.resolveType(node, this.document);
        this.constructComponent(type, node.beginLine);
        this.processAttributes(node, type);
        this.registerModel(node, this.component, this.topLevelChild);
        if (this.document.getVersion() < 4) {
            this.processChildren(node, type);
        } else {
            this.document.registerState(this.component, node);
            if (node.getChildCount() > 0 || node.getAttributeValue("overrides") != null) {
                this.log(node.beginLine, (CompilerMessage)new InvalidOverrideDeclaration());
            }
        }
    }

    protected void constructComponent(Type type, int line) {
        Model model = this.component = this.standardDefs.isIUIComponent(type) ? new MovieClip(this.document, type, this.parent, line) : new Model(this.document, type, this.parent, line);
        if (type.equals(this.typeTable.objectType)) {
            this.component.setInspectable(true);
        }
    }

    protected void processAttributes(Node node, Type type) {
        this.processSpecialAttributes(node);
        Iterator<QName> iter = node.getAttributeNames();
        while (iter.hasNext()) {
            this.attributeHandler.invoke(node, type, iter.next());
        }
    }

    protected void processLayerParent(LayeredNode node) {
        DesignLayerNode layerParent = node.getLayerParent();
        if (layerParent != null) {
            while (layerParent != null) {
                if (layerParent.getAttributeCount() > 0) {
                    Boolean hasStatefulAttrs = this.hasStateSpecificAttributes(layerParent);
                    String alphaValue = (String)layerParent.getAttributeValue("alpha");
                    String visibleValue = (String)layerParent.getAttributeValue("visible");
                    String idValue = (String)layerParent.getAttributeValue("id");
                    Boolean opaque = alphaValue != null && (alphaValue.equals("1.0") || alphaValue.equals("1")) || alphaValue == null;
                    Boolean visible = visibleValue != null && visibleValue.equals("true") || visibleValue == null;
                    if (idValue != null || !opaque.booleanValue() || !visible.booleanValue() || hasStatefulAttrs.booleanValue()) break;
                }
                layerParent = layerParent.getLayerParent();
            }
            if (layerParent != null) {
                DesignLayer layerModel = this.document.getLayerModel(layerParent);
                if (layerModel == null) {
                    ComponentBuilder builder = new ComponentBuilder(this.unit, this.typeTable, this.mxmlConfiguration, this.document, this.component, null, null, true, null);
                    layerParent.analyze(builder);
                    layerModel = (DesignLayer)builder.component;
                }
                this.component.layerParent = layerModel;
            }
        }
    }

    private Boolean hasStateSpecificAttributes(Node node) {
        Iterator<QName> attributes = node.getAttributeNames();
        while (attributes != null && attributes.hasNext()) {
            QName qname = attributes.next();
            String localPart = qname.getLocalPart();
            if (!TextParser.isScopedName(localPart)) continue;
            return true;
        }
        return false;
    }

    protected void unknownAttributeError(String namespace, String localPart, int line) {
        if (namespace != null && namespace.length() > 0) {
            this.log(line, (CompilerMessage)new UnknownQualifiedAttribute(namespace, localPart, NameFormatter.toDot(this.component.getType().getName())));
        } else {
            this.log(line, (CompilerMessage)new UnknownAttribute(localPart, NameFormatter.toDot(this.component.getType().getName())));
        }
    }

    protected void processChildren(Node node, Type type) {
        this.childNodeHandler.scanChildNodes(node, type);
        if (!this.childNodeHandler.getDefaultPropertyNodes().isEmpty()) {
            this.processPropertyNodes(this.childNodeHandler.getDefaultPropertyNodes(), type.getDefaultProperty(), this.component, node.beginLine);
        }
    }

    protected boolean isLegalLanguageNode(Node node) {
        Class<?> nodeClass = node.getClass();
        return nodeClass == ScriptNode.class || nodeClass == DeclarationsNode.class || nodeClass == LibraryNode.class || nodeClass == ReparentNode.class;
    }

    protected void processVisualChild(Node node) {
        ComponentBuilder builder = new ComponentBuilder(this.unit, this.typeTable, this.mxmlConfiguration, this.document, this.component, null, null, false, null);
        node.analyze(builder);
        ((MovieClip)this.component).addChild((MovieClip)builder.component);
    }

    protected void processTextInitializer(CDATANode cdata) {
        if (!this.component.isEmpty()) {
            this.log(cdata.beginLine, (CompilerMessage)new MixedInitializers());
        } else {
            int line;
            int flags;
            String text = cdata.image;
            Type type = this.component.getType();
            Object value = this.textParser.parseValue(text, type, this.typeTable.objectType, flags = cdata.inCDATA ? 1 : 0, line = cdata.beginLine, NameFormatter.toDot(type.getName()));
            if (value != null) {
                if (value instanceof BindingExpression) {
                    if (this.bindingHandler != null) {
                        this.bindingHandler.invoke((BindingExpression)value, this.component);
                    } else {
                        this.log(line, (CompilerMessage)new AbstractBuilder.BindingNotAllowed());
                    }
                } else {
                    Model preppedComponent = this.component;
                    this.component = value instanceof Model ? (Model)value : new Primitive(this.document, preppedComponent.getType(), value, line);
                    this.component.setId(preppedComponent.getId(), preppedComponent.getIdIsAutogenerated());
                }
            }
        }
    }

    protected boolean isAllowedProperty(Property property) {
        return !property.getName().equals("states") || !property.getType().equals(this.typeTable.arrayType);
    }

    protected boolean isSpecialAttribute(String namespace, String localPart) {
        boolean isSpecial = false;
        if (this.document.getVersion() < 4) {
            if (namespace.length() == 0 && "id".equals(localPart)) {
                isSpecial = true;
            }
        } else if ((namespace.length() == 0 || namespace.equals(this.document.getLanguageNamespace())) && ("id".equals(localPart) || "includeIn".equals(localPart) || "excludeFrom".equals(localPart) || "itemCreationPolicy".equals(localPart) || "itemDestructionPolicy".equals(localPart))) {
            isSpecial = true;
        }
        return isSpecial;
    }

    protected void processSpecialAttributes(Node node) {
        this.processStateAttributes(node, this.component);
    }

    public static class UnsupportedStatefulPropertySyntax
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = 7624702513255022417L;
        public String name;

        public UnsupportedStatefulPropertySyntax(String propertyName) {
            this.name = propertyName;
        }
    }

    public static class RepeatersRequireHaloContainerParent
    extends CompilerMessage.CompilerError {
    }

    public static class HaloNavigatorsRequireHaloContainerChildren
    extends CompilerMessage.CompilerError {
    }

    public static class InvalidOverrideDeclaration
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = 2254406474080898341L;
    }

    public static class MixedInitializers
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = 2254406874080898341L;
    }

    public static class IllegalLanguageNode
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = 7624702544805022417L;
        public String image;

        public IllegalLanguageNode(String image) {
            this.image = image;
        }
    }

    public static class InitializersNotAllowed
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = -4021816606896363410L;
    }

    public static class MixedContent
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = 1917736469938208273L;
    }

    public static class NestedDeclaration
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = 5826513690825239320L;
    }

    public static class SparkPrimitiveInHalo
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = -4291778911086982102L;
        public String type;
        public String parentType;

        public SparkPrimitiveInHalo(String type, String parentType) {
            this.type = type;
            this.parentType = parentType;
        }
    }

    public static class NestedFlexDeclaration
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = 8825421061991216942L;
        public String interfaceName;

        public NestedFlexDeclaration(String interfaceName) {
            this.interfaceName = interfaceName;
        }
    }

    public static class NonContiguous
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = -1292997329913440526L;
        public String parentTypeName;
        public String propertyName;

        public NonContiguous(String parentTypeName, String propertyName) {
            this.parentTypeName = parentTypeName;
            this.propertyName = propertyName;
        }
    }

    public static class UnknownQualifiedAttribute
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = -154678836882378518L;
        public String namespace;
        public String localPart;
        public String type;

        public UnknownQualifiedAttribute(String namespace, String localPart, String type) {
            this.namespace = namespace;
            this.localPart = localPart;
            this.type = type;
        }
    }

    public static class UnknownAttribute
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = 9083393507315473854L;
        public String name;
        public String type;

        public UnknownAttribute(String name, String type) {
            this.name = name;
            this.type = type;
        }
    }

    public static class UnknownNamespace
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = -2726612392306645841L;
        public String namespace;
        public String text;

        public UnknownNamespace(String namespace, String text) {
            this.namespace = namespace;
            this.text = text;
        }
    }

    public static class InvalidStyleThemeWarning
    extends CompilerMessage.CompilerWarning {
        private static final long serialVersionUID = -655374071288180328L;
        public String stylePropertyName;
        public String typeName;
        public String styleThemes;

        public InvalidStyleThemeWarning(String stylePropertyName, String typeName, String styleThemes) {
            this.stylePropertyName = stylePropertyName;
            this.typeName = typeName;
            this.styleThemes = styleThemes;
        }
    }

    public static class InvalidStyleThemeError
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = -655374071288180327L;
        public String stylePropertyName;
        public String typeName;
        public String styleThemes;

        public InvalidStyleThemeError(String stylePropertyName, String typeName, String styleThemes) {
            this.stylePropertyName = stylePropertyName;
            this.typeName = typeName;
            this.styleThemes = styleThemes;
        }
    }

    public static class ExcludedStyleProperty
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = -655374071288180326L;
        public String stylePropertyName;
        public String typeName;

        public ExcludedStyleProperty(String stylePropertyName, String typeName) {
            this.stylePropertyName = stylePropertyName;
            this.typeName = typeName;
        }
    }

    protected static class ComponentDeclarationBindingHandler
    implements BindingHandler {
        protected ComponentDeclarationBindingHandler() {
        }

        public BindingExpression invoke(BindingExpression bindingExpression, Model dest) {
            bindingExpression.setDestination(dest);
            return bindingExpression;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ComponentChildNodeHandler
    extends ChildNodeHandler {
        protected Collection<Node> defaultPropertyNodes;

        public ComponentChildNodeHandler(TypeTable typeTable) {
            super(typeTable, "http://ns.adobe.com/fxg/2008".equals(ComponentBuilder.this.document.getLanguageNamespace()));
        }

        public Collection<Node> getDefaultPropertyNodes() {
            return this.defaultPropertyNodes != null ? this.defaultPropertyNodes : Collections.emptyList();
        }

        protected void addDefaultPropertyNode(Node node) {
            (this.defaultPropertyNodes != null ? this.defaultPropertyNodes : (this.defaultPropertyNodes = new ArrayList<Node>(1))).add(node);
        }

        @Override
        protected void event(Event event) {
            CDATANode cdata = ComponentBuilder.this.getTextContent(this.child.getChildren(), false);
            if (cdata != null) {
                ComponentBuilder.this.processEventText(event, cdata.image, cdata.beginLine, ComponentBuilder.this.component);
            }
        }

        @Override
        protected void states(Property property) {
            this.property(property);
            if (ComponentBuilder.this.document.getVersion() >= 4) {
                Map<String, Initializer> properties = ComponentBuilder.this.component.getProperties();
                properties.remove(property.getName());
                if (property.isStateSpecific()) {
                    ComponentBuilder.this.log(this.child, new InvalidStateSpecificValue("states"));
                }
            }
        }

        @Override
        protected void property(Property property) {
            Type type = property.getType();
            if (ComponentBuilder.this.checkNonEmpty(this.child, type)) {
                ComponentBuilder.this.processPropertyNodes(this.child, property, ComponentBuilder.this.component);
            } else if (this.typeTable.stringType.isAssignableTo(type)) {
                ComponentBuilder.this.processPropertyText(property, "", AbstractBuilder.TextOrigin.FROM_CHILD_CDATA, this.child.beginLine, ComponentBuilder.this.component);
            } else if (this.typeTable.arrayType.isAssignableTo(type)) {
                ComponentBuilder.this.processPropertySyntheticArray(property, this.child.beginLine, ComponentBuilder.this.component);
            }
        }

        @Override
        protected void effect(Effect effect) {
            if (ComponentBuilder.this.checkNonEmpty(this.child, this.typeTable.classType)) {
                ComponentBuilder.this.processEffectNodes(this.child, effect, ComponentBuilder.this.component);
            }
        }

        @Override
        protected void style(Style style) {
            Type type = style.getType();
            if (ComponentBuilder.this.checkNonEmpty(this.child, type)) {
                ComponentBuilder.this.processStyleNodes(this.child, style, ComponentBuilder.this.component);
            } else if (ComponentBuilder.this.allowEmptyDefault(type)) {
                ComponentBuilder.this.processStyleText(style, "", AbstractBuilder.TextOrigin.FROM_CHILD_CDATA, this.child.beginLine, ComponentBuilder.this.component);
            }
        }

        @Override
        protected void dynamicProperty(String name, String state) {
            Type type = this.typeTable.objectType;
            if (ComponentBuilder.this.checkNonEmpty(this.child, type)) {
                DynamicProperty dynamicProperty = this.typeTable.getDynamicProperty(name, state);
                ComponentBuilder.this.processDynamicPropertyNodes(this.child, dynamicProperty, ComponentBuilder.this.component);
            } else if (ComponentBuilder.this.allowEmptyDefault(type)) {
                ComponentBuilder.this.processDynamicPropertyText(name, "", AbstractBuilder.TextOrigin.FROM_CHILD_CDATA, this.child.beginLine, ComponentBuilder.this.component, state);
            }
        }

        @Override
        protected void defaultPropertyElement(boolean locError) {
            if (locError) {
                ComponentBuilder.this.log(this.child, (CompilerMessage)new NonContiguous(NameFormatter.retrieveClassName(this.parentType.getName()), this.parentType.getDefaultProperty().getName()));
            }
            Type childType = this.nodeTypeResolver.resolveType(this.child, ComponentBuilder.this.document);
            if (ComponentBuilder.this.standardDefs.isRepeater(childType) && !ComponentBuilder.this.standardDefs.isContainer(this.parentType)) {
                ComponentBuilder.this.log(this.child, (CompilerMessage)new RepeatersRequireHaloContainerParent());
            } else {
                this.addDefaultPropertyNode(this.child);
            }
        }

        @Override
        protected void nestedDeclaration() {
            this.nestedDeclaration(true);
        }

        protected void nestedDeclaration(boolean checkHaloNavigatorRequirements) {
            Type childType = this.nodeTypeResolver.resolveType(this.child, ComponentBuilder.this.document);
            assert (childType != null) : "nested declaration node type == null, node = " + this.child.image;
            String mimeType = ComponentBuilder.this.document.getCompilationUnit().getSource().getMimeType();
            if (checkHaloNavigatorRequirements && ComponentBuilder.this.standardDefs.isHaloNavigator(this.parentType) && !ComponentBuilder.this.standardDefs.isNavigatorContent(childType) && !(this.child instanceof ReparentNode)) {
                ComponentBuilder.this.log(this.child, (CompilerMessage)new HaloNavigatorsRequireHaloContainerChildren());
            } else if (ComponentBuilder.this.standardDefs.isContainer(this.parentType) && ComponentBuilder.this.standardDefs.isIUIComponent(childType) && (mimeType.equals("text/mxml") && ComponentBuilder.this.document.getVersion() < 4 || this.parentType.getDefaultProperty() == null)) {
                ComponentBuilder.this.processVisualChild(this.child);
            } else if (ComponentBuilder.this.standardDefs.isContainer(this.parentType) && (childType.isAssignableTo(((ComponentBuilder)ComponentBuilder.this).standardDefs.CLASS_RADIOBUTTONGROUP) || childType.isAssignableTo(((ComponentBuilder)ComponentBuilder.this).standardDefs.CLASS_SPARK_RADIOBUTTONGROUP)) || this.child instanceof ReparentNode) {
                ComponentBuilder builder = new ComponentBuilder(ComponentBuilder.this.unit, this.typeTable, ComponentBuilder.this.mxmlConfiguration, ComponentBuilder.this.document, ComponentBuilder.this.component, null, null, true, null);
                this.child.analyze(builder);
            } else {
                this.processNestedDeclaration(childType);
            }
        }

        protected void processNestedDeclaration(Type childType) {
            if (ComponentBuilder.this.standardDefs.isSparkGraphic(childType)) {
                ComponentBuilder.this.log(this.child, new SparkPrimitiveInHalo(this.child.getLocalPart(), this.parent.getLocalPart()));
            } else if (ComponentBuilder.this.standardDefs.isContainer(this.parentType)) {
                ComponentBuilder.this.log(this.child, new NestedFlexDeclaration(NameFormatter.toDot(((ComponentBuilder)ComponentBuilder.this).standardDefs.INTERFACE_IUICOMPONENT)));
            } else {
                ComponentBuilder.this.log(this.child, new NestedDeclaration());
            }
        }

        @Override
        protected void textContent() {
            if (this.parent.getChildCount() > 1) {
                ComponentBuilder.this.log(this.child, new MixedContent());
            } else if (ComponentBuilder.this.hasAttributeInitializers(this.parent)) {
                ComponentBuilder.this.log(this.child, new InitializersNotAllowed());
            } else {
                ComponentBuilder.this.processTextInitializer((CDATANode)this.child);
            }
        }

        @Override
        protected void languageNode() {
            if (ComponentBuilder.this.isLegalLanguageNode(this.child)) {
                this.child.analyze(ComponentBuilder.this);
            } else {
                ComponentBuilder.this.log(this.child, new IllegalLanguageNode(this.child.image));
            }
        }

        @Override
        protected void invoke(Node parent, Type parentType, Node child) {
            this.parent = parent;
            this.parentType = parentType;
            this.child = child;
            if (NodeTypeResolver.isValueNode(child)) {
                String namespace = child.getNamespace();
                String localPart = child.getLocalPart();
                if (child.getAttributeCount() == 0 && namespace.equals(this.parent.getNamespace())) {
                    if (TextParser.isScopedName(localPart)) {
                        String[] statefulName = TextParser.analyzeScopedName(localPart);
                        if (ComponentBuilder.this.document.getVersion() >= 4) {
                            if (statefulName != null && ComponentBuilder.this.document.validateState(statefulName[1], child.beginLine)) {
                                ComponentBuilder.this.component.ensureDeclaration();
                                ComponentBuilder.this.component.ensureBindable();
                                this.invoke(this.parentType, namespace, statefulName[0], statefulName[1]);
                            }
                        } else {
                            ComponentBuilder.this.log(child, new UnsupportedStatefulPropertySyntax(localPart));
                        }
                    } else {
                        this.coreDeclarationHandler.invoke(this.parentType, namespace, localPart);
                    }
                } else {
                    this.unknown(null, null);
                }
            } else {
                super.invoke(parent, parentType, child);
            }
        }
    }

    protected class ComponentAttributeHandler
    extends AttributeHandler {
        protected ComponentAttributeHandler() {
        }

        protected boolean isSpecial(String namespace, String localPart) {
            return ComponentBuilder.this.isSpecialAttribute(namespace, localPart);
        }

        protected void special(Type type, String namespace, String localPart) {
        }

        protected void qualifiedAttribute(Node node, Type type, String namespace, String localPart) {
            int version = ComponentBuilder.this.document.getVersion();
            if (version < 4) {
                this.unknownNamespace(namespace, localPart);
            } else if (namespace.equals(ComponentBuilder.this.document.getLanguageNamespace())) {
                this.unknown(namespace, localPart);
            } else if (namespace.equals(node.getNamespace())) {
                this.invoke(type, namespace, localPart);
            }
        }

        protected void event(Event event) {
            ComponentBuilder.this.checkEventDeprecation(event, ComponentBuilder.this.document.getSourcePath(), this.line);
            ComponentBuilder.this.processEventText(event, this.text, this.line, ComponentBuilder.this.component);
        }

        protected void states(Property property) {
            this.property(property);
        }

        protected void property(Property property) {
            ComponentBuilder.this.processPropertyText(property, this.text, AbstractBuilder.TextOrigin.FROM_ATTRIBUTE, this.line, ComponentBuilder.this.component);
        }

        protected void effect(Effect effect) {
            ComponentBuilder.this.checkEffectDeprecation(effect, ComponentBuilder.this.document.getSourcePath(), this.line);
            ComponentBuilder.this.processEffectText(effect, this.text, AbstractBuilder.TextOrigin.FROM_ATTRIBUTE, this.line, ComponentBuilder.this.component);
        }

        protected void style(Style style) {
            ComponentBuilder.this.checkStyleDeprecation(style, ComponentBuilder.this.document.getSourcePath(), this.line);
            ComponentBuilder.this.processStyleText(style, this.text, AbstractBuilder.TextOrigin.FROM_ATTRIBUTE, this.line, ComponentBuilder.this.component);
        }

        protected void dynamicProperty(String name, String state) {
            ComponentBuilder.this.processDynamicPropertyText(name, this.text, AbstractBuilder.TextOrigin.FROM_ATTRIBUTE, this.line, ComponentBuilder.this.component, state);
        }

        protected void unknownNamespace(String namespace, String localPart) {
            ComponentBuilder.this.log(this.line, new UnknownNamespace(namespace, this.text));
        }

        protected void unknown(String namespace, String localPart) {
            String styleThemes = this.type.getStyleThemes(localPart);
            if (this.type.isExcludedStyle(localPart)) {
                ComponentBuilder.this.log(this.line, new ExcludedStyleProperty(localPart, NameFormatter.toDot(ComponentBuilder.this.component.getType().getName())));
            } else if (styleThemes != null) {
                if (ComponentBuilder.this.mxmlConfiguration.reportInvalidStylesAsWarnings()) {
                    ComponentBuilder.this.log(this.line, new InvalidStyleThemeWarning(localPart, NameFormatter.toDot(ComponentBuilder.this.component.getType().getName()), styleThemes));
                } else {
                    ComponentBuilder.this.log(this.line, new InvalidStyleThemeError(localPart, NameFormatter.toDot(ComponentBuilder.this.component.getType().getName()), styleThemes));
                }
            } else {
                ComponentBuilder.this.unknownAttributeError(namespace, localPart, this.line);
            }
        }

        protected void invoke(Type type, String namespace, String localPart) {
            if (TextParser.isScopedName(localPart)) {
                if (ComponentBuilder.this.document.getVersion() >= 4) {
                    String[] statefulName = TextParser.analyzeScopedName(localPart);
                    if (statefulName != null && ComponentBuilder.this.document.validateState(statefulName[1], this.line)) {
                        if (this.isSpecial(namespace, statefulName[0])) {
                            ComponentBuilder.this.log(this.line, new InvalidStateSpecificValue(statefulName[0]));
                        } else {
                            ComponentBuilder.this.component.ensureDeclaration();
                            ComponentBuilder.this.component.ensureBindable();
                            super.invoke(type, namespace, statefulName[0], statefulName[1]);
                        }
                    } else if (statefulName == null) {
                        ComponentBuilder.this.unknownAttributeError(namespace, localPart, this.line);
                    }
                } else {
                    ComponentBuilder.this.log(this.line, new UnsupportedStatefulPropertySyntax(localPart));
                }
            } else {
                super.invoke(type, namespace, localPart);
            }
        }
    }
}

