////////////////////////////////////////////////////////////////////////////////
//
//  Licensed to the Apache Software Foundation (ASF) under one or more
//  contributor license agreements.  See the NOTICE file distributed with
//  this work for additional information regarding copyright ownership.
//  The ASF licenses this file to You under the Apache License, Version 2.0
//  (the "License"); you may not use this file except in compliance with
//  the License.  You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
////////////////////////////////////////////////////////////////////////////////

/**
 *  Controls word wrapping within the container.
 * 
 *  <p><b>For the Spark theme, see
 *  flashx.textLayout.formats.ITextLayoutFormat.blockProgression.</b></p>
 *
 *  <p><b>For the Mobile theme, this is not supported.</b></p>
 * 
 *  @see flashx.textLayout.formats.ITextLayoutFormat#lineBreak
 * 
 *  @langversion 3.0
 *  @playerversion Flash 10
 *  @playerversion AIR 1.5
 *  @productversion Flex 4
 */
[Style(name="lineBreak", type="String", enumeration="toFit,explicit", inherit="no")]

/**
 *  Bottom inset, in pixels.
 * 
 *  <p><b>For the Spark theme, see
 *  flashx.textLayout.formats.ITextLayoutFormat.paddingBottom.</b></p>
 *
 *  <p><b>For the Mobile theme, this is not supported.</b></p>
 * 
 *  @see flashx.textLayout.formats.ITextLayoutFormat#paddingBottom
 * 
 *  @langversion 3.0
 *  @playerversion Flash 10
 *  @playerversion AIR 1.5
 *  @productversion Flex 4
 */
[Style(name="paddingBottom", type="Number", format="Length", inherit="no", minValue="0.0", maxValue="1000.0")]

/**
 *  Left inset, in pixels.
 * 
 *  <p><b>For the Spark theme, see
 *  flashx.textLayout.formats.ITextLayoutFormat.paddingLeft.</b></p>
 *
 *  <p><b>For the Mobile theme, this is not supported.</b></p>
 * 
 *  @see flashx.textLayout.formats.ITextLayoutFormat#paddingLeft
 * 
 *  @langversion 3.0
 *  @playerversion Flash 10
 *  @playerversion AIR 1.5
 *  @productversion Flex 4
 */
[Style(name="paddingLeft", type="Number", format="Length", inherit="no", minValue="0.0", maxValue="1000.0")]

/**
 *  Right inset, in pixels.
 * 
 *  <p><b>For the Spark theme, see
 *  flashx.textLayout.formats.ITextLayoutFormat.paddingRight.</b></p>
 *
 *  <p><b>For the Mobile theme, this is not supported.</b></p>
 * 
 *  @see flashx.textLayout.formats.ITextLayoutFormat#paddingRight
 * 
 *  @langversion 3.0
 *  @playerversion Flash 10
 *  @playerversion AIR 1.5
 *  @productversion Flex 4
 */
[Style(name="paddingRight", type="Number", format="Length", inherit="no", minValue="0.0", maxValue="1000.0")]

/**
 *  Top inset, in pixels.
 * 
 *  <p><b>For the Spark theme, see
 *  flashx.textLayout.formats.ITextLayoutFormat.paddingRight.</b></p>
 *
 *  <p><b>For the Mobile theme, this is not supported.</b></p>
 * 
 *  @see flashx.textLayout.formats.ITextLayoutFormat#paddingRight
 * 
 *  @langversion 3.0
 *  @playerversion Flash 10
 *  @playerversion AIR 1.5
 *  @productversion Flex 4
 */
[Style(name="paddingTop", type="Number", format="Length", inherit="no", minValue="0.0", maxValue="1000.0")]

/**
 *  Vertical alignment or justification.
 * 
 *  <p><b>For the Spark theme, see
 *  flashx.textLayout.formats.ITextLayoutFormat.verticalAlign.</b></p>
 *
 *  <p><b>For the Mobile theme, this is not supported.</b></p>
 * 
 *  @see flashx.textLayout.formats.ITextLayoutFormat#verticalAlign
 * 
 *  @langversion 3.0
 *  @playerversion Flash 10
 *  @playerversion AIR 1.5
 *  @productversion Flex 4
 */
[Style(name="verticalAlign", type="String", enumeration="top,middle,bottom,justify", inherit="no")]
