/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.maven.osgicheck.impl.featureutil;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.felix.maven.osgicheck.impl.featureutil.PackageInfo;
import org.apache.sling.commons.osgi.ManifestHeader;

public class ManifestUtil {
    public static Manifest getManifest(File artifact) throws IOException {
        try (JarFile file = new JarFile(artifact);){
            Manifest manifest = file.getManifest();
            return manifest;
        }
    }

    public static List<PackageInfo> extractPackages(Manifest m, String headerName, String defaultVersion, boolean checkOptional) {
        String pckInfo = m.getMainAttributes().getValue(headerName);
        if (pckInfo != null) {
            ManifestHeader header = ManifestHeader.parse((String)pckInfo);
            ArrayList<PackageInfo> pcks = new ArrayList<PackageInfo>();
            for (ManifestHeader.Entry entry : header.getEntries()) {
                String version = entry.getAttributeValue("version");
                if (version == null) {
                    version = defaultVersion;
                }
                boolean optional = false;
                if (checkOptional) {
                    String resolution = entry.getDirectiveValue("resolution");
                    optional = "optional".equalsIgnoreCase(resolution);
                }
                PackageInfo pck = new PackageInfo(entry.getValue(), version, optional);
                pcks.add(pck);
            }
            return pcks;
        }
        return Collections.emptyList();
    }

    public static List<PackageInfo> extractExportedPackages(Manifest m) {
        return ManifestUtil.extractPackages(m, "Export-Package", "0.0.0", false);
    }

    public static List<PackageInfo> extractImportedPackages(Manifest m) {
        return ManifestUtil.extractPackages(m, "Import-Package", null, true);
    }

    public static List<PackageInfo> extractDynamicImportedPackages(Manifest m) {
        return ManifestUtil.extractPackages(m, "DynamicImport-Package", null, false);
    }
}

