/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.upnp.basedriver.importer.core.upnp;

import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.felix.upnp.basedriver.importer.core.upnp.UPnPActionImpl;
import org.apache.felix.upnp.basedriver.importer.core.upnp.UPnPStateVariableImpl;
import org.cybergarage.upnp.Action;
import org.cybergarage.upnp.ActionList;
import org.cybergarage.upnp.Service;
import org.cybergarage.upnp.ServiceStateTable;
import org.cybergarage.upnp.StateVariable;
import org.osgi.service.upnp.UPnPAction;
import org.osgi.service.upnp.UPnPService;
import org.osgi.service.upnp.UPnPStateVariable;

public class UPnPServiceImpl
implements UPnPService {
    private Service service;
    private Hashtable actions;
    private Hashtable stateVariables;

    public UPnPServiceImpl(Service service) {
        this.service = service;
        this.actions = new Hashtable();
        this.stateVariables = new Hashtable();
        ActionList actionlist = service.getActionList();
        for (int i = 0; i < actionlist.size(); ++i) {
            Action act = actionlist.getAction(i);
            this.actions.put(act.getName(), new UPnPActionImpl(act, this));
        }
        ServiceStateTable stateTable = service.getServiceStateTable();
        for (int i = 0; i < stateTable.size(); ++i) {
            StateVariable var = stateTable.getStateVariable(i);
            this.stateVariables.put(var.getName(), new UPnPStateVariableImpl(var));
        }
    }

    public String getId() {
        return this.service.getServiceID();
    }

    public String getType() {
        return this.service.getServiceType();
    }

    public String getVersion() {
        String serviceType = this.service.getServiceType();
        int start = serviceType.lastIndexOf(58);
        String version = serviceType.substring(start + 1);
        return version;
    }

    public UPnPAction getAction(String name) {
        return (UPnPAction)this.actions.get(name);
    }

    public UPnPAction[] getActions() {
        Enumeration e = this.actions.elements();
        if (e == null) {
            return null;
        }
        UPnPAction[] uPnPacts = new UPnPAction[this.actions.size()];
        int i = 0;
        while (e.hasMoreElements()) {
            uPnPacts[i] = (UPnPActionImpl)e.nextElement();
            ++i;
        }
        return uPnPacts;
    }

    public UPnPStateVariable[] getStateVariables() {
        UPnPStateVariable[] vars = new UPnPStateVariableImpl[this.stateVariables.size()];
        Enumeration e = this.stateVariables.elements();
        if (e == null) {
            return null;
        }
        int i = 0;
        while (e.hasMoreElements()) {
            vars[i] = (UPnPStateVariableImpl)e.nextElement();
            ++i;
        }
        return vars;
    }

    public UPnPStateVariable getStateVariable(String name) {
        return (UPnPStateVariableImpl)this.stateVariables.get(name);
    }

    public Service getCyberService() {
        return this.service;
    }
}

