/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.manipulator.metadata.annotation.registry;

import java.lang.annotation.ElementType;
import java.util.ArrayList;
import java.util.List;
import org.apache.felix.ipojo.manipulator.Reporter;
import org.apache.felix.ipojo.manipulator.metadata.annotation.ComponentWorkbench;
import org.apache.felix.ipojo.manipulator.metadata.annotation.registry.Binding;
import org.apache.felix.ipojo.manipulator.metadata.annotation.registry.BindingRegistry;
import org.apache.felix.ipojo.manipulator.spi.BindingContext;
import org.apache.felix.ipojo.manipulator.util.ChainedAnnotationVisitor;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;

public class Selection {
    private BindingRegistry registry;
    private ComponentWorkbench workbench;
    private Reporter reporter;
    private FieldNode field;
    private MethodNode method;
    private ClassNode clazz;
    private int index = -1;
    private String annotation;
    private ElementType elementType = null;
    private Object visitor;

    public Selection(BindingRegistry registry, ComponentWorkbench workbench, Reporter reporter) {
        this.registry = registry;
        this.workbench = workbench;
        this.reporter = reporter;
    }

    public Selection field(FieldVisitor visitor, FieldNode node) {
        this.visitor = visitor;
        this.field = node;
        this.elementType = ElementType.FIELD;
        return this;
    }

    public Selection method(MethodVisitor visitor, MethodNode node) {
        this.visitor = visitor;
        this.method = node;
        this.elementType = ElementType.METHOD;
        return this;
    }

    public Selection type(ClassVisitor visitor, ClassNode node) {
        this.visitor = visitor;
        this.clazz = node;
        this.elementType = ElementType.TYPE;
        return this;
    }

    public Selection parameter(MethodVisitor visitor, MethodNode node, int index) {
        this.visitor = visitor;
        this.index = index;
        this.method = node;
        this.elementType = ElementType.PARAMETER;
        return this;
    }

    public Selection annotatedWith(String desc) {
        this.annotation = desc;
        return this;
    }

    public AnnotationVisitor get() {
        List<AnnotationVisitor> visitors = this.list();
        if (visitors.isEmpty()) {
            return null;
        }
        if (visitors.size() == 1) {
            return visitors.get(0);
        }
        ChainedAnnotationVisitor chained = new ChainedAnnotationVisitor();
        chained.getVisitors().addAll(visitors);
        return chained;
    }

    private List<AnnotationVisitor> list() {
        BindingContext context = this.elementType == ElementType.FIELD ? new BindingContext(this.workbench, this.reporter, Type.getType(this.annotation), this.field, this.elementType, this.index, this.visitor) : (this.elementType == ElementType.TYPE ? new BindingContext(this.workbench, this.reporter, Type.getType(this.annotation), this.clazz, this.elementType, this.index, this.visitor) : new BindingContext(this.workbench, this.reporter, Type.getType(this.annotation), this.method, this.elementType, this.index, this.visitor));
        List<Binding> predicates = this.registry.getBindings(this.annotation);
        ArrayList<AnnotationVisitor> visitors = new ArrayList<AnnotationVisitor>();
        if (predicates != null && !predicates.isEmpty()) {
            this.collectMatchingVisitors(predicates, context, visitors);
        }
        return visitors;
    }

    private void collectMatchingVisitors(List<Binding> bindings, BindingContext context, List<AnnotationVisitor> visitors) {
        for (Binding binding : bindings) {
            AnnotationVisitor visitor;
            if (!binding.getPredicate().matches(context) || (visitor = binding.getFactory().newAnnotationVisitor(context)) == null) continue;
            visitors.add(visitor);
        }
    }
}

