/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.extender.internal.processor;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.felix.ipojo.IPojoFactory;
import org.apache.felix.ipojo.extender.internal.BundleProcessor;
import org.apache.felix.ipojo.extender.internal.builder.ReflectiveFactoryBuilder;
import org.apache.felix.ipojo.extender.internal.declaration.DefaultExtensionDeclaration;
import org.apache.felix.ipojo.metadata.Element;
import org.apache.felix.ipojo.parser.ParseUtils;
import org.apache.felix.ipojo.util.Log;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionBundleProcessor
implements BundleProcessor {
    public static final String IPOJO_EXTENSION = "IPOJO-Extension";
    private final Log m_logger;
    private Map<Bundle, List<DefaultExtensionDeclaration>> m_extensions = new HashMap<Bundle, List<DefaultExtensionDeclaration>>();

    public ExtensionBundleProcessor(Log logger) {
        this.m_logger = logger;
    }

    @Override
    public void activate(Bundle bundle) {
        Dictionary dict = bundle.getHeaders();
        String extension = (String)dict.get(IPOJO_EXTENSION);
        if (extension != null) {
            this.activateExtensions(bundle, extension);
        }
    }

    @Override
    public void deactivate(Bundle bundle) {
        List<DefaultExtensionDeclaration> declarations = this.m_extensions.get(bundle);
        if (declarations != null) {
            for (DefaultExtensionDeclaration declaration : declarations) {
                declaration.stop();
            }
            this.m_extensions.remove(bundle);
        }
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    private void activateExtensions(Bundle bundle, String header) {
        String[] extensions = ParseUtils.split(header, ",");
        for (int i = 0; extensions != null && i < extensions.length; ++i) {
            Class<IPojoFactory> clazz;
            String[] segments = ParseUtils.split(extensions[i], ":");
            String[] nameparts = ParseUtils.split(segments[0].trim(), " \t");
            String type = nameparts.length == 1 ? nameparts[0] : nameparts[0] + ":" + nameparts[1];
            String classname = segments[1];
            try {
                clazz = bundle.loadClass(classname).asSubclass(IPojoFactory.class);
            }
            catch (ClassNotFoundException e) {
                String message = String.format("Cannot load class '%s' from bundle %s (%s) for extension '%s'", classname, bundle.getSymbolicName(), bundle.getVersion(), type);
                this.m_logger.log(1, message, e);
                return;
            }
            try {
                ReflectiveFactoryBuilder builder = new ReflectiveFactoryBuilder(clazz.getConstructor(BundleContext.class, Element.class));
                DefaultExtensionDeclaration declaration = new DefaultExtensionDeclaration(bundle.getBundleContext(), builder, type);
                this.getBundleDeclarations(bundle).add(declaration);
                declaration.start();
                this.m_logger.log(4, "New factory type available: " + type);
                continue;
            }
            catch (NoSuchMethodException e) {
                this.m_logger.log(1, String.format("Extension '%s' is missing the required (BundleContext, Element) public constructor", clazz.getName()));
            }
        }
    }

    private List<DefaultExtensionDeclaration> getBundleDeclarations(Bundle bundle) {
        List<DefaultExtensionDeclaration> declarations = this.m_extensions.get(bundle);
        if (declarations == null) {
            declarations = new ArrayList<DefaultExtensionDeclaration>();
            this.m_extensions.put(bundle, declarations);
        }
        return declarations;
    }
}

