/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.manipulator.spi;

import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import org.objectweb.asm.Type;

public abstract class AnnotationLiteral<T extends Annotation>
implements Annotation {
    private Class<? extends Annotation> annotationType;

    @Override
    public Class<? extends Annotation> annotationType() {
        if (this.annotationType == null) {
            this.annotationType = AnnotationLiteral.findAnnotationType(this.getClass());
            if (this.annotationType == null) {
                throw new IllegalStateException(String.format("Annotation %s does not specify its annotation type (T) in AnnotationLiteral<T>", this.getClass().getName()));
            }
        }
        return this.annotationType;
    }

    public Type getType() {
        return Type.getType(this.annotationType());
    }

    private static Class<Annotation> findAnnotationType(Class<? extends AnnotationLiteral> type) {
        Class<AnnotationLiteral> implementer = AnnotationLiteral.findImplementer(type);
        return AnnotationLiteral.findTypeParameter(implementer);
    }

    private static Class<Annotation> findTypeParameter(Class<?> clazz) {
        java.lang.reflect.Type type = clazz.getGenericSuperclass();
        if (type instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)type;
            return (Class)pType.getActualTypeArguments()[0];
        }
        return null;
    }

    private static Class<? extends AnnotationLiteral> findImplementer(Class<? extends AnnotationLiteral> type) {
        Class<AnnotationLiteral> superClass = type.getSuperclass().asSubclass(AnnotationLiteral.class);
        if (AnnotationLiteral.class.equals(superClass)) {
            return type;
        }
        return AnnotationLiteral.findImplementer(superClass);
    }
}

