/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.api;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.List;
import java.util.Properties;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.ConfigurationException;
import org.apache.felix.ipojo.Factory;
import org.apache.felix.ipojo.MissingHandlerException;
import org.apache.felix.ipojo.UnacceptableConfiguration;

public abstract class ComponentType {
    private List m_instances = new ArrayList();

    public abstract Factory getFactory();

    public abstract void start();

    public abstract void stop();

    public ComponentInstance createInstance() throws UnacceptableConfiguration, MissingHandlerException, ConfigurationException {
        ComponentInstance ci = this.ensureAndGetFactory().createComponentInstance(null);
        this.m_instances.add(ci);
        return ci;
    }

    public ComponentInstance createInstance(String name) throws UnacceptableConfiguration, MissingHandlerException, ConfigurationException {
        Properties dict = null;
        if (name != null) {
            dict = new Properties();
            ((Dictionary)dict).put("instance.name", name);
        }
        ComponentInstance ci = this.ensureAndGetFactory().createComponentInstance((Dictionary)dict);
        this.m_instances.add(ci);
        return ci;
    }

    public ComponentInstance createInstance(Dictionary conf) throws UnacceptableConfiguration, MissingHandlerException, ConfigurationException {
        ComponentInstance ci = this.ensureAndGetFactory().createComponentInstance(conf);
        this.m_instances.add(ci);
        return ci;
    }

    public boolean disposeInstance(ComponentInstance ci) {
        if (this.m_instances.remove(ci)) {
            ci.dispose();
            return true;
        }
        System.err.println("The instance was not created from this component type");
        return false;
    }

    public ComponentInstance getInstanceByName(String name) {
        for (int i = 0; i < this.m_instances.size(); ++i) {
            ComponentInstance ci = (ComponentInstance)this.m_instances.get(i);
            if (!ci.getInstanceName().equals(name)) continue;
            return ci;
        }
        return null;
    }

    public boolean disposeInstance(String name) {
        ComponentInstance ci = this.getInstanceByName(name);
        if (ci == null) {
            System.err.println("The instance was not found in this component type");
            return false;
        }
        return this.disposeInstance(ci);
    }

    private Factory ensureAndGetFactory() {
        this.ensureFactory();
        return this.getFactory();
    }

    private void ensureFactory() {
        if (this.getFactory() == null) {
            throw new IllegalStateException("The factory associated with the component type is not created");
        }
        if (this.getFactory().getState() == 0) {
            throw new IllegalStateException("The factory associated with the component type is invalid (not started or missing handlers)");
        }
    }
}

