/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server.transport;

import java.io.IOException;
import java.io.PrintWriter;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.bayeux.server.ServerSession;
import org.cometd.server.AbstractServerTransport;
import org.cometd.server.BayeuxServerImpl;
import org.cometd.server.ServerSessionImpl;
import org.cometd.server.transport.HttpTransport;
import org.eclipse.jetty.continuation.Continuation;
import org.eclipse.jetty.continuation.ContinuationListener;
import org.eclipse.jetty.continuation.ContinuationSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LongPollingTransport
extends HttpTransport {
    public static final String PREFIX = "long-polling";
    public static final String BROWSER_ID_OPTION = "browserId";
    public static final String BROWSER_COOKIE_NAME_OPTION = "browserCookieName";
    public static final String BROWSER_COOKIE_DOMAIN_OPTION = "browserCookieDomain";
    public static final String BROWSER_COOKIE_PATH_OPTION = "browserCookiePath";
    public static final String MAX_SESSIONS_PER_BROWSER_OPTION = "maxSessionsPerBrowser";
    public static final String MULTI_SESSION_INTERVAL_OPTION = "multiSessionInterval";
    public static final String AUTOBATCH_OPTION = "autoBatch";
    public static final String ALLOW_MULTI_SESSIONS_NO_BROWSER_OPTION = "allowMultiSessionsNoBrowser";
    private final Logger _logger = LoggerFactory.getLogger(this.getClass());
    private final ConcurrentHashMap<String, AtomicInteger> _browserMap = new ConcurrentHashMap();
    private final Map<String, AtomicInteger> _browserSweep = new ConcurrentHashMap<String, AtomicInteger>();
    private String _browserCookieName;
    private String _browserCookieDomain;
    private String _browserCookiePath;
    private int _maxSessionsPerBrowser;
    private long _multiSessionInterval;
    private boolean _autoBatch;
    private boolean _allowMultiSessionsNoBrowser;
    private long _lastSweep;

    protected LongPollingTransport(BayeuxServerImpl bayeux, String name) {
        super(bayeux, name);
        this.setOptionPrefix(PREFIX);
    }

    protected void init() {
        super.init();
        this._browserCookieName = this.getOption(BROWSER_COOKIE_NAME_OPTION, this.getOption(BROWSER_ID_OPTION, "BAYEUX_BROWSER"));
        this._browserCookieDomain = this.getOption(BROWSER_COOKIE_DOMAIN_OPTION, null);
        this._browserCookiePath = this.getOption(BROWSER_COOKIE_PATH_OPTION, "/");
        this._maxSessionsPerBrowser = this.getOption(MAX_SESSIONS_PER_BROWSER_OPTION, 1);
        this._multiSessionInterval = this.getOption(MULTI_SESSION_INTERVAL_OPTION, 2000);
        this._autoBatch = this.getOption(AUTOBATCH_OPTION, true);
        this._allowMultiSessionsNoBrowser = this.getOption(ALLOW_MULTI_SESSIONS_NO_BROWSER_OPTION, false);
    }

    protected String findBrowserId(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!this._browserCookieName.equals(cookie.getName())) continue;
                return cookie.getValue();
            }
        }
        return null;
    }

    protected String setBrowserId(HttpServletRequest request, HttpServletResponse response) {
        String browserId = Long.toHexString(request.getRemotePort()) + Long.toString(this.getBayeux().randomLong(), 36) + Long.toString(System.currentTimeMillis(), 36) + Long.toString(request.getRemotePort(), 36);
        Cookie cookie = new Cookie(this._browserCookieName, browserId);
        if (this._browserCookieDomain != null) {
            cookie.setDomain(this._browserCookieDomain);
        }
        cookie.setPath(this._browserCookiePath);
        cookie.setMaxAge(-1);
        response.addCookie(cookie);
        return browserId;
    }

    protected boolean incBrowserId(String browserId) {
        int sessions;
        AtomicInteger newCount;
        if (this._maxSessionsPerBrowser < 0) {
            return true;
        }
        if (this._maxSessionsPerBrowser == 0) {
            return false;
        }
        AtomicInteger count = this._browserMap.get(browserId);
        if (count == null && (count = this._browserMap.putIfAbsent(browserId, newCount = new AtomicInteger())) == null) {
            count = newCount;
        }
        if ((sessions = count.incrementAndGet()) == 1) {
            this._browserSweep.remove(browserId);
        }
        if (sessions > this._maxSessionsPerBrowser) {
            count.decrementAndGet();
            return false;
        }
        return true;
    }

    protected void decBrowserId(String browserId) {
        if (browserId == null) {
            return;
        }
        AtomicInteger count = this._browserMap.get(browserId);
        if (count != null && count.decrementAndGet() == 0) {
            this._browserSweep.put(browserId, new AtomicInteger(0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void handle(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        scheduler = (LongPollScheduler)request.getAttribute("org.cometd.scheduler");
        if (scheduler == null) {
            batch = false;
            session = null;
            connect = false;
            try {
                messages = this.parseMessages(request);
                if (messages == null) {
                    return;
                }
                writer = null;
                for (ServerMessage.Mutable message : messages) {
                    connect = "/meta/connect".equals(message.getChannel());
                    client_id = message.getClientId();
                    if (session == null || client_id != null && !client_id.equals(session.getId())) {
                        session = (ServerSessionImpl)this.getBayeux().getSession(client_id);
                        if (this._autoBatch && !batch && session != null && !connect && !message.isMeta()) {
                            batch = true;
                            session.startBatch();
                        }
                    } else if (!session.isHandshook()) {
                        batch = false;
                        session = null;
                    }
                    if (connect && session != null) {
                        session.setScheduler(null);
                    }
                    wasConnected = session != null && session.isConnected() != false;
                    reply = this.bayeuxServerHandle(session, message);
                    if (reply != null) {
                        if (session == null) {
                            session = (ServerSessionImpl)this.getBayeux().getSession(reply.getClientId());
                            if (session != null && (browserId = this.findBrowserId(request)) == null) {
                                this.setBrowserId(request, response);
                            }
                        } else if (connect) {
                            try {
                                if (session.hasNonLazyMessages() || !reply.isSuccessful()) ** GOTO lbl77
                                browserId = this.findBrowserId(request);
                                if (browserId != null) {
                                    allowSuspendConnect = this.incBrowserId(browserId);
                                } else {
                                    v0 = allowSuspendConnect = this._allowMultiSessionsNoBrowser != false || request.getHeader("Origin") != null;
                                }
                                if (allowSuspendConnect) {
                                    timeout = session.calculateTimeout(this.getTimeout());
                                    if (timeout > 0L && wasConnected && session.isConnected()) {
                                        continuation = ContinuationSupport.getContinuation((ServletRequest)request);
                                        continuation.setTimeout(timeout);
                                        continuation.suspend((ServletResponse)response);
                                        scheduler = this.newLongPollScheduler(session, continuation, reply, browserId);
                                        request.setAttribute("org.cometd.scheduler", (Object)scheduler);
                                        session.setScheduler(scheduler);
                                        reply = null;
                                        this.metaConnectSuspended(request, session, timeout);
                                    }
                                    this.decBrowserId(browserId);
                                }
                                advice = reply.getAdvice(true);
                                if (browserId != null) {
                                    advice.put("multiple-clients", true);
                                }
                                if (this._multiSessionInterval > 0L) {
                                    advice.put("reconnect", "retry");
                                    advice.put("interval", this._multiSessionInterval);
                                } else {
                                    advice.put("reconnect", "none");
                                    reply.setSuccessful(false);
                                }
                                session.reAdvise();
                            }
                            finally {
                                if (reply != null) {
                                    writer = this.writeQueueForMetaConnect(request, response, session, writer);
                                }
                            }
                        } else if (!this.isMetaConnectDeliveryOnly() && !session.isMetaConnectDeliveryOnly()) {
                            writer = this.writeQueue(request, response, session, writer);
                        }
lbl77:
                        // 8 sources

                        if (reply != null) {
                            if (connect && session != null && session.isDisconnected()) {
                                reply.getAdvice(true).put("reconnect", "none");
                            }
                            if ((reply = this.getBayeux().extendReply(session, session, reply)) != null) {
                                this.getBayeux().freeze(reply);
                                writer = this.writeMessage(request, response, writer, session, reply);
                            }
                        }
                    }
                    message.setAssociated(null);
                }
                if (writer == null) ** GOTO lbl111
                this.finishWrite(writer, session);
            }
            catch (ParseException x) {
                this.handleJSONParseException(request, response, x.getMessage(), x.getCause());
            }
            finally {
                if (batch) {
                    if (!session.endBatch() && this.isAlwaysFlushingAfterHandle()) {
                        session.flush();
                    }
                } else if (session != null && !connect && this.isAlwaysFlushingAfterHandle()) {
                    session.flush();
                }
            }
        } else {
            session = scheduler.getSession();
            this.metaConnectResumed(request, session);
            writer = this.writeQueueForMetaConnect(request, response, session, null);
            reply = scheduler.getReply();
            if (session.isDisconnected()) {
                reply.getAdvice(true).put("reconnect", "none");
            }
            if ((reply = this.getBayeux().extendReply(session, session, reply)) != null) {
                this.getBayeux().freeze(reply);
                writer = this.writeMessage(request, response, writer, session, reply);
            }
            this.finishWrite(writer, session);
        }
lbl111:
        // 4 sources

    }

    protected LongPollScheduler newLongPollScheduler(ServerSessionImpl session, Continuation continuation, ServerMessage.Mutable metaConnectReply, String browserId) {
        return new LongPollScheduler(session, continuation, metaConnectReply, browserId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PrintWriter writeQueueForMetaConnect(HttpServletRequest request, HttpServletResponse response, ServerSessionImpl session, PrintWriter writer) throws IOException {
        try {
            PrintWriter printWriter = this.writeQueue(request, response, session, writer);
            return printWriter;
        }
        finally {
            if (session.isConnected()) {
                session.startIntervalTimeout(this.getInterval());
            }
        }
    }

    protected ServerMessage.Mutable bayeuxServerHandle(ServerSessionImpl session, ServerMessage.Mutable message) {
        return this.getBayeux().handle(session, message);
    }

    protected void metaConnectSuspended(HttpServletRequest request, ServerSession session, long timeout) {
    }

    protected void metaConnectResumed(HttpServletRequest request, ServerSession session) {
    }

    protected void handleJSONParseException(HttpServletRequest request, HttpServletResponse response, String json, Throwable exception) throws ServletException, IOException {
        this._logger.warn("Error parsing JSON: " + json, exception);
        response.sendError(400);
    }

    protected void sweep() {
        long now = System.currentTimeMillis();
        long elapsed = now - this._lastSweep;
        if (this._lastSweep > 0L && elapsed > 0L) {
            int maxSweeps = (int)(2L * this.getMaxInterval() / elapsed);
            for (Map.Entry<String, AtomicInteger> entry : this._browserSweep.entrySet()) {
                String key;
                AtomicInteger count = entry.getValue();
                if (count == null || count.incrementAndGet() <= maxSweeps || this._browserSweep.remove(key = entry.getKey()) != count || this._browserMap.get(key).get() != 0) continue;
                this._browserMap.remove(key);
                this._logger.debug("Swept browserId {}", (Object)key);
            }
        }
        this._lastSweep = now;
    }

    private PrintWriter writeQueue(HttpServletRequest request, HttpServletResponse response, ServerSessionImpl session, PrintWriter writer) throws IOException {
        List<ServerMessage> queue = session.takeQueue();
        for (ServerMessage m : queue) {
            writer = this.writeMessage(request, response, writer, session, m);
        }
        return writer;
    }

    protected ServerMessage.Mutable[] parseMessages(String[] requestParameters) throws IOException, ParseException {
        if (requestParameters == null || requestParameters.length == 0) {
            throw new IOException("Missing 'message' request parameter");
        }
        if (requestParameters.length == 1) {
            return this.parseMessages(requestParameters[0]);
        }
        ArrayList<ServerMessage.Mutable> messages = new ArrayList<ServerMessage.Mutable>();
        for (String batch : requestParameters) {
            if (batch == null) continue;
            messages.addAll(Arrays.asList(this.parseMessages(batch)));
        }
        return messages.toArray(new ServerMessage.Mutable[messages.size()]);
    }

    protected abstract ServerMessage.Mutable[] parseMessages(HttpServletRequest var1) throws IOException, ParseException;

    protected abstract boolean isAlwaysFlushingAfterHandle();

    protected abstract PrintWriter writeMessage(HttpServletRequest var1, HttpServletResponse var2, PrintWriter var3, ServerSessionImpl var4, ServerMessage var5) throws IOException;

    protected abstract void finishWrite(PrintWriter var1, ServerSessionImpl var2) throws IOException;

    protected class LongPollScheduler
    implements AbstractServerTransport.OneTimeScheduler,
    ContinuationListener {
        private static final String ATTRIBUTE = "org.cometd.scheduler";
        private final ServerSessionImpl _session;
        private final Continuation _continuation;
        private final ServerMessage.Mutable _reply;
        private final String _browserId;

        public LongPollScheduler(ServerSessionImpl session, Continuation continuation, ServerMessage.Mutable reply, String browserId) {
            this._session = session;
            this._continuation = continuation;
            this._continuation.addContinuationListener((ContinuationListener)this);
            this._reply = reply;
            this._browserId = browserId;
        }

        public void cancel() {
            if (this._continuation != null && this._continuation.isSuspended() && !this._continuation.isExpired()) {
                try {
                    this.decBrowserId();
                    ((HttpServletResponse)this._continuation.getServletResponse()).sendError(408);
                }
                catch (IOException x) {
                    LongPollingTransport.this._logger.trace("", (Throwable)x);
                }
                try {
                    this._continuation.complete();
                }
                catch (Exception x) {
                    LongPollingTransport.this._logger.trace("", (Throwable)x);
                }
            }
        }

        public void schedule() {
            this.decBrowserId();
            this._continuation.resume();
        }

        public ServerSessionImpl getSession() {
            return this._session;
        }

        public ServerMessage.Mutable getReply() {
            Map<String, Object> advice = this._session.takeAdvice();
            if (advice != null) {
                this._reply.put("advice", advice);
            }
            return this._reply;
        }

        public void onComplete(Continuation continuation) {
        }

        public void onTimeout(Continuation continuation) {
            this.decBrowserId();
            this._session.setScheduler(null);
        }

        private void decBrowserId() {
            LongPollingTransport.this.decBrowserId(this._browserId);
        }
    }
}

