/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.gogo.jline;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.felix.gogo.jline.ParsedLineImpl;
import org.apache.felix.gogo.runtime.Parser;
import org.apache.felix.gogo.runtime.Token;
import org.jline.reader.EOFError;
import org.jline.reader.ParsedLine;
import org.jline.reader.Parser;
import org.jline.reader.SyntaxError;

public class Parser
implements org.jline.reader.Parser {
    public ParsedLine parse(String line, int cursor, Parser.ParseContext context) throws SyntaxError {
        try {
            return this.doParse(line, cursor, context);
        }
        catch (org.apache.felix.gogo.runtime.EOFError e) {
            throw new EOFError(e.line(), e.column(), e.getMessage(), e.missing());
        }
        catch (org.apache.felix.gogo.runtime.SyntaxError e) {
            throw new SyntaxError(e.line(), e.column(), e.getMessage());
        }
    }

    private ParsedLine doParse(String line, int cursor, Parser.ParseContext parseContext) throws org.apache.felix.gogo.runtime.SyntaxError {
        Parser.Program program = null;
        List statements = null;
        String repaired = line;
        while (program == null) {
            try {
                org.apache.felix.gogo.runtime.Parser parser = new org.apache.felix.gogo.runtime.Parser((CharSequence)repaired);
                program = parser.program();
                statements = parser.statements();
            }
            catch (org.apache.felix.gogo.runtime.EOFError e) {
                if (parseContext == Parser.ParseContext.COMPLETE && repaired.length() < line.length() + 1024) {
                    repaired = repaired + " " + e.repair();
                    continue;
                }
                throw e;
            }
        }
        Parser.Statement statement = null;
        for (int i = statements.size() - 1; i >= 0; --i) {
            Parser.Statement s = (Parser.Statement)statements.get(i);
            if (s.start() > cursor) continue;
            boolean isOk = true;
            if (s.start() + s.length() < cursor) {
                for (int j = s.start() + s.length(); isOk && j < cursor; ++j) {
                    isOk = Character.isWhitespace(line.charAt(j));
                }
            }
            statement = s;
            break;
        }
        if (statement != null && statement.tokens() != null && !statement.tokens().isEmpty()) {
            if (repaired != line) {
                Token stmt = statement.subSequence(0, line.length() - statement.start());
                ArrayList<Token> tokens = new ArrayList<Token>(statement.tokens());
                Token last = (Token)tokens.get(tokens.size() - 1);
                tokens.set(tokens.size() - 1, last.subSequence(0, line.length() - last.start()));
                return new ParsedLineImpl(program, stmt, cursor, tokens);
            }
            return new ParsedLineImpl(program, (Token)statement, cursor, statement.tokens());
        }
        return new ParsedLineImpl(program, (Token)program, cursor, Collections.singletonList(program));
    }
}

