/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jmx;

import java.util.concurrent.ExecutorService;
import javax.management.MBeanServer;
import org.apache.aries.jmx.Logger;
import org.apache.aries.jmx.agent.JMXAgentContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class MBeanServiceTracker
extends ServiceTracker {
    private JMXAgentContext agentContext;

    public MBeanServiceTracker(JMXAgentContext agentContext) {
        super(agentContext.getBundleContext(), MBeanServer.class.getName(), null);
        this.agentContext = agentContext;
    }

    public Object addingService(ServiceReference reference) {
        final MBeanServer mbeanServer = (MBeanServer)this.context.getService(reference);
        Logger logger = this.agentContext.getLogger();
        logger.log(4, "Discovered MBean server " + mbeanServer);
        ExecutorService executor = this.agentContext.getRegistrationExecutor();
        executor.submit(new Runnable(){

            public void run() {
                MBeanServiceTracker.this.agentContext.registerMBeans(mbeanServer);
            }
        });
        return super.addingService(reference);
    }

    public void removedService(ServiceReference reference, Object service) {
        final MBeanServer mbeanServer = (MBeanServer)this.context.getService(reference);
        Logger logger = this.agentContext.getLogger();
        logger.log(4, "MBean server " + mbeanServer + " is unregistered from SeviceRegistry");
        ExecutorService executor = this.agentContext.getRegistrationExecutor();
        executor.submit(new Runnable(){

            public void run() {
                MBeanServiceTracker.this.agentContext.unregisterMBeans(mbeanServer);
            }
        });
        super.removedService(reference, service);
    }
}

