/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.agentdir;

import java.io.File;
import java.io.IOException;
import java.util.Objects;
import java.util.jar.JarFile;

final class JarFileUtils {
    JarFileUtils() {
    }

    public static JarFile openJarFile(File file) {
        Objects.requireNonNull(file, "file");
        if (!file.exists()) {
            throw new IllegalArgumentException(file + " not found");
        }
        if (file.isDirectory()) {
            throw new IllegalArgumentException(file + " is directory");
        }
        if (!file.isFile()) {
            throw new IllegalArgumentException(file + " not file");
        }
        if (!file.canRead()) {
            throw new IllegalArgumentException(file + " can read");
        }
        try {
            return new JarFile(file);
        }
        catch (IOException e) {
            throw new IllegalStateException(file + " create fail Caused by:" + e.getMessage(), e);
        }
    }
}

