/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap;

import com.navercorp.pinpoint.bootstrap.Agent;
import com.navercorp.pinpoint.bootstrap.AgentBootLoader;
import com.navercorp.pinpoint.bootstrap.AgentIdResolver;
import com.navercorp.pinpoint.bootstrap.AgentIdResolverBuilder;
import com.navercorp.pinpoint.bootstrap.AgentIds;
import com.navercorp.pinpoint.bootstrap.AgentOption;
import com.navercorp.pinpoint.bootstrap.AgentType;
import com.navercorp.pinpoint.bootstrap.BootLogger;
import com.navercorp.pinpoint.bootstrap.ContainerResolver;
import com.navercorp.pinpoint.bootstrap.DefaultAgentOption;
import com.navercorp.pinpoint.bootstrap.ModuleBootLoader;
import com.navercorp.pinpoint.bootstrap.PathUtils;
import com.navercorp.pinpoint.bootstrap.agentdir.AgentDirectory;
import com.navercorp.pinpoint.bootstrap.agentdir.LogDirCleaner;
import com.navercorp.pinpoint.bootstrap.banner.PinpointBannerImpl;
import com.navercorp.pinpoint.bootstrap.classloader.PinpointClassLoaderFactory;
import com.navercorp.pinpoint.bootstrap.classloader.ProfilerLibs;
import com.navercorp.pinpoint.bootstrap.config.ProfilerConfig;
import com.navercorp.pinpoint.bootstrap.config.ProfilerConfigLoader;
import com.navercorp.pinpoint.bootstrap.config.PropertyLoader;
import com.navercorp.pinpoint.bootstrap.config.PropertyLoaderFactory;
import com.navercorp.pinpoint.common.banner.PinpointBanner;
import com.navercorp.pinpoint.common.util.OsEnvSimpleProperty;
import com.navercorp.pinpoint.common.util.PropertySnapshot;
import com.navercorp.pinpoint.common.util.SimpleProperty;
import com.navercorp.pinpoint.common.util.StringUtils;
import com.navercorp.pinpoint.common.util.SystemProperty;
import java.lang.instrument.Instrumentation;
import java.net.URL;
import java.nio.file.Path;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;

class PinpointStarter {
    private final BootLogger logger = BootLogger.getLogger(this.getClass());
    public static final String AGENT_TYPE = "AGENT_TYPE";
    public static final String DEFAULT_AGENT = "DEFAULT_AGENT";
    public static final String BOOT_CLASS = "com.navercorp.pinpoint.profiler.DefaultAgent";
    public static final String PLUGIN_TEST_AGENT = "PLUGIN_TEST";
    public static final String PLUGIN_TEST_BOOT_CLASS = "com.navercorp.pinpoint.test.PluginTestAgent";
    private SimpleProperty systemProperty = SystemProperty.INSTANCE;
    private final Map<String, String> agentArgs;
    private final AgentType agentType;
    private final AgentDirectory agentDirectory;
    private final Instrumentation instrumentation;
    private final ClassLoader parentClassLoader;
    private final ModuleBootLoader moduleBootLoader;
    private static String PINPOINT_PREFIX = "pinpoint-";

    public PinpointStarter(ClassLoader parentClassLoader, Map<String, String> agentArgs, AgentDirectory agentDirectory, Instrumentation instrumentation, ModuleBootLoader moduleBootLoader) {
        this.agentArgs = Objects.requireNonNull(agentArgs, "agentArgs");
        this.agentType = this.getAgentType(agentArgs);
        this.parentClassLoader = parentClassLoader;
        this.agentDirectory = Objects.requireNonNull(agentDirectory, "agentDirectory");
        this.instrumentation = Objects.requireNonNull(instrumentation, "instrumentation");
        this.moduleBootLoader = moduleBootLoader;
    }

    private AgentType getAgentType(Map<String, String> agentArgs) {
        String agentTypeParameter = agentArgs.get(AGENT_TYPE);
        return AgentType.getAgentType(agentTypeParameter);
    }

    boolean start() {
        AgentIds agentIds = this.resolveAgentIds();
        if (agentIds == null) {
            this.logger.warn("Failed to resolve AgentId and ApplicationId");
            return false;
        }
        String agentId = agentIds.getAgentId();
        if (agentId == null) {
            this.logger.warn("agentId is null");
            return false;
        }
        String applicationName = agentIds.getApplicationName();
        if (applicationName == null) {
            this.logger.warn("applicationName is null");
            return false;
        }
        ContainerResolver containerResolver = new ContainerResolver();
        boolean isContainer = containerResolver.isContainer();
        try {
            Properties properties = this.loadProperties();
            ProfilerConfig profilerConfig = ProfilerConfigLoader.load((Properties)properties);
            this.saveAgentIdForLog(agentIds);
            this.saveLogFilePath(this.agentDirectory.getAgentLogFilePath());
            this.savePinpointVersion();
            this.cleanLogDir(this.agentDirectory.getAgentLogFilePath(), profilerConfig);
            URL[] urls = this.resolveLib(this.agentDirectory);
            ClassLoader agentClassLoader = this.createClassLoader("pinpoint.agent", urls, this.parentClassLoader);
            if (this.moduleBootLoader != null) {
                this.logger.info("defineAgentModule");
                this.moduleBootLoader.defineAgentModule(agentClassLoader, urls);
            }
            String bootClass = this.getBootClass();
            AgentBootLoader agentBootLoader = new AgentBootLoader(bootClass, agentClassLoader);
            this.logger.info(String.format("pinpoint agent [%s] starting...", bootClass));
            List<Path> pluginJars = this.agentDirectory.getPlugins();
            String agentName = agentIds.getAgentName();
            AgentOption option = this.createAgentOption(agentId, agentName, applicationName, isContainer, profilerConfig, this.instrumentation, pluginJars, this.agentDirectory.getBootDir().getJarPath());
            Agent pinpointAgent = agentBootLoader.boot(option);
            pinpointAgent.start();
            pinpointAgent.registerStopHandler();
            this.logger.info("pinpoint agent started normally.");
            PinpointBannerImpl banner = new PinpointBannerImpl(profilerConfig.readList("pinpoint.banner.configs"), this.logger);
            banner.setPinpointBannerMode(PinpointBanner.Mode.valueOf((String)profilerConfig.readString("pinpoint.banner.mode", "CONSOLE").toUpperCase()));
            banner.setPinpointBannerProperty(properties);
            banner.printBanner();
        }
        catch (Exception e) {
            this.logger.warn("pinpoint start failed.", e);
            return false;
        }
        return true;
    }

    private void cleanLogDir(Path agentLogFilePath, ProfilerConfig config) {
        int logDirMaxBackupSize = config.getLogDirMaxBackupSize();
        this.logger.info("Log directory maxbackupsize=" + logDirMaxBackupSize);
        LogDirCleaner logDirCleaner = new LogDirCleaner(agentLogFilePath, logDirMaxBackupSize);
        logDirCleaner.clean();
    }

    private AgentIds resolveAgentIds() {
        AgentIdResolverBuilder builder = new AgentIdResolverBuilder();
        builder.addAgentArgument(this.agentArgs);
        builder.addEnvProperties(System.getenv());
        builder.addSystemProperties(System.getProperties());
        AgentIdResolver agentIdResolver = builder.build();
        return agentIdResolver.resolve();
    }

    private Properties loadProperties() {
        Path agentDirPath = this.agentDirectory.getAgentDirPath();
        Path profilesPath = this.agentDirectory.getProfilesPath();
        String[] profileDirs = this.agentDirectory.getProfileDirs();
        SimpleProperty javaSystemProperty = this.copyJavaSystemProperty();
        SimpleProperty osEnvProperty = this.copyOSEnvVariables();
        PropertyLoaderFactory factory = new PropertyLoaderFactory(javaSystemProperty, osEnvProperty, agentDirPath, profilesPath, profileDirs);
        PropertyLoader loader = factory.newPropertyLoader();
        Properties properties = loader.load();
        if (this.agentType == AgentType.PLUGIN_TEST) {
            properties.put("profiler.interceptor.exception.propagate", "true");
        }
        String importPluginIds = StringUtils.defaultString((String)this.agentArgs.get("IMPORT_PLUGIN"), (String)"");
        properties.put("profiler.plugin.import-plugin", importPluginIds);
        return properties;
    }

    private SimpleProperty copyJavaSystemProperty() {
        return new PropertySnapshot(System.getProperties());
    }

    private SimpleProperty copyOSEnvVariables() {
        return new OsEnvSimpleProperty(System.getenv());
    }

    private ClassLoader createClassLoader(final String name, final URL[] urls, final ClassLoader parentClassLoader) {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return PinpointClassLoaderFactory.createClassLoader((String)name, (URL[])urls, (ClassLoader)parentClassLoader, (List)ProfilerLibs.PINPOINT_PROFILER_CLASS);
                }
            });
        }
        return PinpointClassLoaderFactory.createClassLoader((String)name, (URL[])urls, (ClassLoader)parentClassLoader, (List)ProfilerLibs.PINPOINT_PROFILER_CLASS);
    }

    private String getBootClass() {
        if (this.isTestAgent()) {
            return PLUGIN_TEST_BOOT_CLASS;
        }
        return BOOT_CLASS;
    }

    private boolean isTestAgent() {
        String agentType = this.getAgentType();
        return PLUGIN_TEST_AGENT.equalsIgnoreCase(agentType);
    }

    private String getAgentType() {
        String agentType = this.agentArgs.get(AGENT_TYPE);
        if (agentType == null) {
            return DEFAULT_AGENT;
        }
        return agentType;
    }

    private AgentOption createAgentOption(String agentId, String agentName, String applicationName, boolean isContainer, ProfilerConfig profilerConfig, Instrumentation instrumentation, List<Path> pluginJars, List<Path> bootstrapJarPaths) {
        List<String> pluginJarStrPath = this.toPathList(pluginJars);
        List<String> bootstrapJarPathStrPath = this.toPathList(bootstrapJarPaths);
        return new DefaultAgentOption(instrumentation, agentId, agentName, applicationName, isContainer, profilerConfig, pluginJarStrPath, bootstrapJarPathStrPath);
    }

    private List<String> toPathList(List<Path> paths) {
        ArrayList<String> list = new ArrayList<String>(paths.size());
        for (Path path : paths) {
            list.add(path.toString());
        }
        return list;
    }

    void setSystemProperty(SimpleProperty systemProperty) {
        this.systemProperty = systemProperty;
    }

    private void saveAgentIdForLog(AgentIds agentIds) {
        this.systemProperty.setProperty("pinpoint.agentId", agentIds.getAgentId());
    }

    private void saveLogFilePath(Path agentLogFilePath) {
        this.logger.info("logPath:" + agentLogFilePath);
        this.systemProperty.setProperty("pinpoint.log", agentLogFilePath.toString());
    }

    private void savePinpointVersion() {
        this.logger.info(String.format("pinpoint version:%s", "2.4.1"));
        this.systemProperty.setProperty("pinpoint.version", "2.4.1");
    }

    private URL[] resolveLib(AgentDirectory classPathResolver) {
        Path agentJarFullPath = classPathResolver.getAgentJarFullPath();
        Path agentLibPath = classPathResolver.getAgentLibPath();
        List<Path> libUrlList = this.resolveLib(classPathResolver.getLibs());
        Path agentConfigPath = classPathResolver.getAgentConfigPath();
        if (this.logger.isInfoEnabled()) {
            this.logger.info(String.format("agent JarPath:%s", agentJarFullPath));
            this.logger.info(String.format("agent LibDir:%s", agentLibPath));
            for (Path url : libUrlList) {
                this.logger.info(String.format("agent Lib:%s", url));
            }
            this.logger.info(String.format("agent config:%s", agentConfigPath));
        }
        return PathUtils.toURLs(libUrlList);
    }

    private List<Path> resolveLib(List<Path> urlList) {
        if (DEFAULT_AGENT.equalsIgnoreCase(this.getAgentType())) {
            List<Path> releaseLib = this.filterTest(urlList);
            return this.order(releaseLib);
        }
        this.logger.info("load PLUGIN_TEST lib");
        return this.order(urlList);
    }

    private List<Path> order(List<Path> releaseLib) {
        Path fileName;
        ArrayList<Path> orderList = new ArrayList<Path>(releaseLib.size());
        for (Path path : releaseLib) {
            fileName = path.getFileName();
            if (!fileName.startsWith(PINPOINT_PREFIX)) continue;
            orderList.add(path);
        }
        for (Path path : releaseLib) {
            fileName = path.getFileName();
            if (fileName.startsWith(PINPOINT_PREFIX)) continue;
            orderList.add(path);
        }
        return orderList;
    }

    private List<Path> filterTest(List<Path> pathList) {
        ArrayList<Path> releaseLib = new ArrayList<Path>(pathList.size());
        for (Path path : pathList) {
            if (path.toString().contains("pinpoint-profiler-test")) continue;
            releaseLib.add(path);
        }
        return releaseLib;
    }
}

