/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.protocol.meshmessage.resolver.http;

import io.cloudevents.CloudEvent;
import io.cloudevents.SpecVersion;
import io.cloudevents.core.builder.CloudEventBuilder;
import java.net.URI;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.Constants;
import org.apache.eventmesh.common.protocol.http.body.Body;
import org.apache.eventmesh.common.protocol.http.body.message.SendMessageBatchV2RequestBody;
import org.apache.eventmesh.common.protocol.http.header.Header;
import org.apache.eventmesh.common.protocol.http.header.message.SendMessageBatchV2RequestHeader;
import org.apache.eventmesh.protocol.api.exception.ProtocolHandleException;

public class SendMessageBatchV2ProtocolResolver {
    public static CloudEvent buildEvent(Header header, Body body) throws ProtocolHandleException {
        try {
            SendMessageBatchV2RequestHeader sendMessageBatchV2RequestHeader = (SendMessageBatchV2RequestHeader)header;
            SendMessageBatchV2RequestBody sendMessageBatchV2RequestBody = (SendMessageBatchV2RequestBody)body;
            CloudEventBuilder cloudEventBuilder = CloudEventBuilder.fromSpecVersion((SpecVersion)SpecVersion.parse((String)sendMessageBatchV2RequestHeader.getProtocolVersion()));
            return SendMessageBatchV2ProtocolResolver.getBuildCloudEvent(sendMessageBatchV2RequestHeader, sendMessageBatchV2RequestBody, cloudEventBuilder);
        }
        catch (Exception e) {
            throw new ProtocolHandleException(e.getMessage(), e.getCause());
        }
    }

    private static CloudEvent getBuildCloudEvent(SendMessageBatchV2RequestHeader sendMessageBatchV2RequestHeader, SendMessageBatchV2RequestBody sendMessageBatchV2RequestBody, CloudEventBuilder cloudEventBuilder) {
        cloudEventBuilder = cloudEventBuilder.withId(sendMessageBatchV2RequestBody.getBizSeqNo()).withSubject(sendMessageBatchV2RequestBody.getTopic()).withType("eventmeshmessage").withSource(URI.create("/")).withData(sendMessageBatchV2RequestBody.getMsg().getBytes(Constants.DEFAULT_CHARSET)).withExtension("code", sendMessageBatchV2RequestHeader.getCode()).withExtension("env", sendMessageBatchV2RequestHeader.getEnv()).withExtension("idc", sendMessageBatchV2RequestHeader.getIdc()).withExtension("ip", sendMessageBatchV2RequestHeader.getIp()).withExtension("pid", sendMessageBatchV2RequestHeader.getPid()).withExtension("sys", sendMessageBatchV2RequestHeader.getSys()).withExtension("username", sendMessageBatchV2RequestHeader.getUsername()).withExtension("passwd", sendMessageBatchV2RequestHeader.getPasswd()).withExtension("version", sendMessageBatchV2RequestHeader.getVersion().getVersion()).withExtension("language", sendMessageBatchV2RequestHeader.getLanguage()).withExtension("protocoltype", sendMessageBatchV2RequestHeader.getProtocolType()).withExtension("protocoldesc", sendMessageBatchV2RequestHeader.getProtocolDesc()).withExtension("protocolversion", sendMessageBatchV2RequestHeader.getProtocolVersion()).withExtension("bizseqno", sendMessageBatchV2RequestBody.getBizSeqNo()).withExtension("producergroup", sendMessageBatchV2RequestBody.getProducerGroup()).withExtension("ttl", sendMessageBatchV2RequestBody.getTtl());
        if (StringUtils.isNotEmpty((CharSequence)sendMessageBatchV2RequestBody.getTag())) {
            cloudEventBuilder = cloudEventBuilder.withExtension("tag", sendMessageBatchV2RequestBody.getTag());
        }
        return cloudEventBuilder.build();
    }
}

