/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.assertj.core.util.Preconditions;

public class Arrays {
    public static boolean isArray(Object o) {
        return o != null && o.getClass().isArray();
    }

    public static <T> boolean isNullOrEmpty(T[] array) {
        return array == null || Arrays.isEmpty(array);
    }

    @SafeVarargs
    public static <T> T[] array(T ... values) {
        return values;
    }

    public static <T> List<T> nonNullElementsIn(T[] array) {
        if (array == null) {
            return Collections.emptyList();
        }
        ArrayList<T> nonNullElements = new ArrayList<T>();
        for (T o : array) {
            if (o == null) continue;
            nonNullElements.add(o);
        }
        return nonNullElements;
    }

    public static <T> boolean hasOnlyNullElements(T[] array) {
        Preconditions.checkNotNull(array);
        if (Arrays.isEmpty(array)) {
            return false;
        }
        for (T o : array) {
            if (o == null) continue;
            return false;
        }
        return true;
    }

    private static <T> boolean isEmpty(T[] array) {
        return array.length == 0;
    }

    public static boolean isObjectArray(Object o) {
        return Arrays.isArray(o) && !Arrays.isArrayTypePrimitive(o);
    }

    public static boolean isArrayTypePrimitive(Object o) {
        return o != null && o.getClass().getComponentType().isPrimitive();
    }

    public static IllegalArgumentException notAnArrayOfPrimitives(Object o) {
        return new IllegalArgumentException(String.format("<%s> is not an array of primitives", o));
    }

    private Arrays() {
    }
}

