/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.admin.rocketmq.util;

import com.sun.net.httpserver.HttpExchange;
import org.apache.eventmesh.admin.rocketmq.util.UrlMappingPattern;
import org.apache.eventmesh.common.enums.HttpMethod;

public final class RequestMapping {
    public static boolean postMapping(String value, HttpExchange httpExchange) {
        return RequestMapping.isUrlMatch(value, httpExchange, HttpMethod.POST.name());
    }

    public static boolean getMapping(String value, HttpExchange httpExchange) {
        return RequestMapping.isUrlMatch(value, httpExchange, HttpMethod.GET.name());
    }

    public static boolean putMapping(String value, HttpExchange httpExchange) {
        return RequestMapping.isUrlMatch(value, httpExchange, HttpMethod.PUT.name());
    }

    public static boolean deleteMapping(String value, HttpExchange httpExchange) {
        return RequestMapping.isUrlMatch(value, httpExchange, HttpMethod.DELETE.name());
    }

    private static boolean isUrlMatch(String value, HttpExchange httpExchange, String methodType) {
        if (methodType.equalsIgnoreCase(httpExchange.getRequestMethod())) {
            String requestUri = httpExchange.getRequestURI().getPath();
            UrlMappingPattern matcher = new UrlMappingPattern(value);
            return matcher.matches(requestUri);
        }
        return false;
    }

    private RequestMapping() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

